/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.config;

import com.ubivismedia.aidungeon.AIDungeon;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigMigrator {
    private final AIDungeon plugin;
    private final FileConfiguration config;
    private final File configFile;
    private boolean migrationPerformed = false;

    public ConfigMigrator(AIDungeon plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
    }

    public boolean migrateConfig() {
        this.migrateReportingConfig();
        if (this.migrationPerformed) {
            try {
                this.config.save(this.configFile);
                this.plugin.getLogger().info("Configuration migration completed and saved");
                return true;
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to save migrated config", e);
            }
        }
        return this.migrationPerformed;
    }

    private void migrateReportingConfig() {
        if (this.config.contains("reporting") && !this.config.contains("api_reporting")) {
            this.plugin.getLogger().info("Migrating from old 'reporting' to new 'api_reporting' configuration");
            boolean enabled = this.config.getBoolean("reporting.enabled", false);
            String endpoint = this.config.getString("reporting.endpoint", "https://api.ubivismedia.com/api/index.php");
            this.config.set("api_reporting.enabled", (Object)enabled);
            this.config.set("api_reporting.base_url", (Object)endpoint);
            this.config.set("api_reporting.report_frequency", (Object)60);
            this.config.set("api_reporting.batch_size", (Object)10);
            this.config.set("api_reporting.resend_cooldown", (Object)72);
            this.config.set("reporting", null);
            this.migrationPerformed = true;
            this.plugin.getLogger().info("Migrated reporting configuration to api_reporting");
        }
    }
}

