/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.config;

import com.ubivismedia.aidungeon.AIDungeon;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUpgrader {
    private final AIDungeon plugin;
    private final File configFile;
    private final YamlConfiguration defaultConfig;
    private final FileConfiguration currentConfig;

    public ConfigUpgrader(AIDungeon plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
        this.defaultConfig = this.loadDefaultConfig();
        this.currentConfig = plugin.getConfig();
    }

    private YamlConfiguration loadDefaultConfig() {
        InputStream defaultConfigStream = this.plugin.getResource("config.yml");
        if (defaultConfigStream == null) {
            this.plugin.getLogger().severe("Could not load default config.yml from jar");
            return new YamlConfiguration();
        }
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultConfigStream, StandardCharsets.UTF_8));
    }

    public boolean upgradeConfig() {
        boolean configChanged = false;
        Set defaultKeys = this.defaultConfig.getKeys(false);
        Set currentKeys = this.currentConfig.getKeys(false);
        for (String key : defaultKeys) {
            if (currentKeys.contains(key)) continue;
            this.plugin.getLogger().info("Adding new configuration section: " + key);
            if (this.defaultConfig.isConfigurationSection(key)) {
                this.currentConfig.createSection(key, this.defaultConfig.getConfigurationSection(key).getValues(true));
            } else {
                this.currentConfig.set(key, this.defaultConfig.get(key));
            }
            configChanged = true;
        }
        if (configChanged |= this.processSection((ConfigurationSection)this.defaultConfig, (ConfigurationSection)this.currentConfig, "")) {
            try {
                this.currentConfig.save(this.configFile);
                this.plugin.getLogger().info("Configuration file updated with new options");
                return true;
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save updated config", e);
            }
        }
        return false;
    }

    private boolean processSection(ConfigurationSection defaultSection, ConfigurationSection currentSection, String path) {
        boolean changed = false;
        Set defaultKeys = defaultSection.getKeys(false);
        for (String key : defaultKeys) {
            String fullPath;
            String string = fullPath = path.isEmpty() ? key : path + "." + key;
            if (defaultSection.isConfigurationSection(key)) {
                if (!currentSection.isConfigurationSection(key)) {
                    this.plugin.getLogger().info("Adding missing config section: " + fullPath);
                    currentSection.createSection(key);
                    changed = true;
                }
                ConfigurationSection defaultSubSection = defaultSection.getConfigurationSection(key);
                ConfigurationSection currentSubSection = currentSection.getConfigurationSection(key);
                changed |= this.processSection(defaultSubSection, currentSubSection, fullPath);
                continue;
            }
            if (currentSection.contains(key)) continue;
            this.plugin.getLogger().info("Added missing config option: " + fullPath);
            currentSection.set(key, defaultSection.get(key));
            changed = true;
        }
        return changed;
    }

    public Map<String, String> validateConfig() {
        HashMap<String, String> issues = new HashMap<String, String>();
        if (this.currentConfig.getBoolean("api_reporting.enabled", false)) {
            String baseUrl;
            String apiKey = this.currentConfig.getString("gemini.apiKey", "");
            if (apiKey == null || apiKey.isEmpty()) {
                issues.put("gemini.apiKey", "API key is required when api_reporting is enabled");
            }
            if ((baseUrl = this.currentConfig.getString("api_reporting.base_url", "")) == null || baseUrl.isEmpty()) {
                issues.put("api_reporting.base_url", "API base URL is required when api_reporting is enabled");
            }
        }
        if (this.currentConfig.contains("reporting.enabled") && !this.currentConfig.contains("api_reporting.enabled")) {
            issues.put("configuration", "Legacy 'reporting' section should be migrated to 'api_reporting'");
        }
        return issues;
    }
}

