/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.database;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.config.ConfigManager;
import com.ubivismedia.aidungeon.lib.hikari.HikariConfig;
import com.ubivismedia.aidungeon.lib.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;

public class DatabaseManager {
    private final AIDungeon plugin;
    private final ConfigManager configManager;
    private HikariDataSource dataSource;
    private boolean hikariInitialized = false;
    private String jdbcUrl;
    private String username;
    private String password;

    public DatabaseManager(AIDungeon plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        if (this.configManager.getDbType().equalsIgnoreCase("mysql")) {
            this.jdbcUrl = "jdbc:mysql://" + this.configManager.getDbHost() + ":" + this.configManager.getDbPort() + "/" + this.configManager.getDbName() + "?useSSL=false&allowPublicKeyRetrieval=true";
            this.username = this.configManager.getDbUser();
            this.password = this.configManager.getDbPassword();
        } else {
            File dbFile = new File(plugin.getDataFolder(), this.configManager.getDbFile());
            if (!dbFile.getParentFile().exists()) {
                dbFile.getParentFile().mkdirs();
            }
            this.jdbcUrl = "jdbc:sqlite:" + dbFile.getAbsolutePath();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean setupConnection() {
        HikariConfig config = new HikariConfig();
        if (this.configManager.getDbType().equalsIgnoreCase("mysql")) {
            config.setJdbcUrl(this.jdbcUrl);
            config.setUsername(this.username);
            config.setPassword(this.password);
            config.setDriverClassName("com.mysql.cj.jdbc.Driver");
            config.addDataSourceProperty("cachePrepStmts", "true");
            config.addDataSourceProperty("prepStmtCacheSize", "250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            config.addDataSourceProperty("useServerPrepStmts", "true");
            config.addDataSourceProperty("useLocalSessionState", "true");
            config.addDataSourceProperty("rewriteBatchedStatements", "true");
            config.addDataSourceProperty("cacheResultSetMetadata", "true");
            config.addDataSourceProperty("cacheServerConfiguration", "true");
            config.addDataSourceProperty("elideSetAutoCommits", "true");
            config.addDataSourceProperty("maintainTimeStats", "false");
            config.setMaximumPoolSize(10);
            config.setMinimumIdle(1);
        } else {
            config.setJdbcUrl(this.jdbcUrl);
            config.setDriverClassName("org.sqlite.JDBC");
            config.addDataSourceProperty("foreign_keys", "true");
            config.addDataSourceProperty("synchronous", "normal");
            config.addDataSourceProperty("journal_mode", "WAL");
            config.setMaximumPoolSize(5);
            config.setMinimumIdle(1);
        }
        config.setPoolName("AIDungeonPool");
        config.setMaxLifetime(600000L);
        config.setIdleTimeout(300000L);
        config.setConnectionTimeout(20000L);
        config.setInitializationFailTimeout(30000L);
        config.setKeepaliveTime(60000L);
        config.setConnectionTestQuery("SELECT 1");
        config.setAutoCommit(true);
        try {
            this.testDirectConnection();
            this.dataSource = new HikariDataSource(config);
            try (Connection conn = this.dataSource.getConnection();){
                if (conn != null && !conn.isClosed()) {
                    this.plugin.getLogger().info("HikariCP database connection pool initialized successfully.");
                    this.hikariInitialized = true;
                    boolean bl = true;
                    return bl;
                }
            }
            this.plugin.getLogger().severe("Failed to initialize database connection pool!");
            return false;
        }
        catch (Exception e) {
            try {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to setup HikariCP connection pool: ", e);
                return false;
            }
            catch (Exception e2) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to setup database connection: ", e2);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDirectConnection() throws SQLException {
        Connection conn = null;
        try {
            conn = this.configManager.getDbType().equalsIgnoreCase("mysql") ? DriverManager.getConnection(this.jdbcUrl, this.username, this.password) : DriverManager.getConnection(this.jdbcUrl);
            try (PreparedStatement stmt = conn.prepareStatement("SELECT 1");){
                stmt.executeQuery();
            }
            this.plugin.getLogger().info("Direct database connection test successful.");
        }
        finally {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.hikariInitialized && this.dataSource != null && !this.dataSource.isClosed()) {
            try {
                return this.dataSource.getConnection();
            }
            catch (SQLException e) {
                this.plugin.getLogger().warning("HikariCP connection failed: " + e.getMessage() + ". Attempting direct connection...");
            }
        }
        if (this.configManager.getDbType().equalsIgnoreCase("mysql")) {
            return DriverManager.getConnection(this.jdbcUrl, this.username, this.password);
        }
        return DriverManager.getConnection(this.jdbcUrl);
    }

    public void closeConnection() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    public boolean createTables() {
        boolean bl;
        block39: {
            Connection conn = this.getConnection();
            try {
                String createDungeonsTable = "CREATE TABLE IF NOT EXISTS dungeons (id INTEGER PRIMARY KEY " + (this.configManager.getDbType().equalsIgnoreCase("mysql") ? "AUTO_INCREMENT" : "AUTOINCREMENT") + ", world_name VARCHAR(64) NOT NULL, biome_type VARCHAR(32) NOT NULL, theme VARCHAR(32) NOT NULL, x_coord INTEGER NOT NULL, y_coord INTEGER NOT NULL, z_coord INTEGER NOT NULL, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, status VARCHAR(16) NOT NULL, boss_defeated BOOLEAN DEFAULT 0)";
                String createRoomsTable = "CREATE TABLE IF NOT EXISTS rooms (id INTEGER PRIMARY KEY " + (this.configManager.getDbType().equalsIgnoreCase("mysql") ? "AUTO_INCREMENT" : "AUTOINCREMENT") + ", dungeon_id INTEGER NOT NULL, room_type VARCHAR(32) NOT NULL, x_coord INTEGER NOT NULL, y_coord INTEGER NOT NULL, z_coord INTEGER NOT NULL, width INTEGER NOT NULL, height INTEGER NOT NULL, length INTEGER NOT NULL, exploration_status VARCHAR(16) DEFAULT 'UNEXPLORED', FOREIGN KEY (dungeon_id) REFERENCES dungeons(id) ON DELETE CASCADE)";
                String createPlayerProgressTable = "CREATE TABLE IF NOT EXISTS player_progress (id INTEGER PRIMARY KEY " + (this.configManager.getDbType().equalsIgnoreCase("mysql") ? "AUTO_INCREMENT" : "AUTOINCREMENT") + ", player_uuid VARCHAR(36) NOT NULL, dungeon_id INTEGER NOT NULL, exploration_percent DOUBLE DEFAULT 0, last_visit TIMESTAMP DEFAULT CURRENT_TIMESTAMP, FOREIGN KEY (dungeon_id) REFERENCES dungeons(id) ON DELETE CASCADE, UNIQUE (player_uuid, dungeon_id))";
                String createPendingLocationsTable = "CREATE TABLE IF NOT EXISTS pending_locations (id INTEGER PRIMARY KEY " + (this.configManager.getDbType().equalsIgnoreCase("mysql") ? "AUTO_INCREMENT" : "AUTOINCREMENT") + ", world_name VARCHAR(64) NOT NULL, biome_type VARCHAR(32) NOT NULL, x_coord INTEGER NOT NULL, z_coord INTEGER NOT NULL, discovered_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)";
                String createProcessedChunksTable = "CREATE TABLE IF NOT EXISTS processed_chunks (id INTEGER PRIMARY KEY " + (this.configManager.getDbType().equalsIgnoreCase("mysql") ? "AUTO_INCREMENT" : "AUTOINCREMENT") + ", world_name VARCHAR(64) NOT NULL, chunk_x INTEGER NOT NULL, chunk_z INTEGER NOT NULL, processed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, UNIQUE (world_name, chunk_x, chunk_z))";
                try (PreparedStatement stmt1 = conn.prepareStatement(createDungeonsTable);
                     PreparedStatement stmt2 = conn.prepareStatement(createRoomsTable);
                     PreparedStatement stmt3 = conn.prepareStatement(createPlayerProgressTable);
                     PreparedStatement stmt4 = conn.prepareStatement(createPendingLocationsTable);
                     PreparedStatement stmt5 = conn.prepareStatement(createProcessedChunksTable);){
                    stmt1.executeUpdate();
                    stmt2.executeUpdate();
                    stmt3.executeUpdate();
                    stmt4.executeUpdate();
                    stmt5.executeUpdate();
                }
                bl = true;
                if (conn == null) break block39;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to create database tables: ", e);
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    public void performCleanup() {
        try {
            if (this.dataSource != null) {
                this.dataSource.getHikariPoolMXBean().softEvictConnections();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error during database connection pool cleanup", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isConnectionHealthy() {
        try (Connection conn = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement("SELECT 1");
                try {
                    bl = stmt.executeQuery().next();
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Database connection health check failed", e);
            return false;
        }
    }

    public boolean isHikariInitialized() {
        return this.hikariInitialized && this.dataSource != null && !this.dataSource.isClosed();
    }
}

