/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.dungeon;

import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.util.Vector;

public class DungeonCollapser {
    public static Material getReplacementMaterial(World world, Vector pos) {
        Biome biome = world.getBiome(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
        if (pos.getY() == (double)world.getHighestBlockYAt(pos.getBlockX(), pos.getBlockZ())) {
            return DungeonCollapser.getSurfaceMaterial(biome);
        }
        if (pos.getY() < 60.0) {
            return DungeonCollapser.getUndergroundMaterial(biome);
        }
        return Material.AIR;
    }

    private static Material getSurfaceMaterial(Biome biome) {
        String biomeName = biome.toString();
        if (biomeName.contains("DESERT") || biomeName.contains("BADLANDS")) {
            return Material.SAND;
        }
        if (biomeName.contains("SNOWY") || biomeName.contains("ICE") || biomeName.contains("FROZEN")) {
            return Material.SNOW_BLOCK;
        }
        if (biomeName.contains("NETHER")) {
            return Material.NETHERRACK;
        }
        if (biomeName.contains("END")) {
            return Material.END_STONE;
        }
        if (biomeName.contains("MOUNTAINS") || biomeName.contains("PEAKS") || biomeName.contains("HILLS")) {
            double random = Math.random();
            if (random < 0.7) {
                return Material.STONE;
            }
            if (random < 0.9) {
                return Material.ANDESITE;
            }
            return Material.GRAVEL;
        }
        if (biomeName.contains("BEACH")) {
            return Material.SAND;
        }
        if (biomeName.contains("SWAMP")) {
            double random = Math.random();
            if (random < 0.7) {
                return Material.GRASS_BLOCK;
            }
            return Material.DIRT;
        }
        return Material.GRASS_BLOCK;
    }

    private static Material getUndergroundMaterial(Biome biome) {
        String biomeName = biome.toString();
        if (biomeName.contains("NETHER")) {
            double random = Math.random();
            if (random < 0.7) {
                return Material.NETHERRACK;
            }
            if (random < 0.9) {
                return Material.SOUL_SAND;
            }
            return Material.MAGMA_BLOCK;
        }
        if (biomeName.contains("END")) {
            return Material.END_STONE;
        }
        if (biomeName.contains("DEEP") || biomeName.contains("LUSH_CAVES") || biomeName.contains("DRIPSTONE")) {
            double random = Math.random();
            if (random < 0.5) {
                return Material.DEEPSLATE;
            }
            if (random < 0.8) {
                return Material.TUFF;
            }
            return Material.DEEPSLATE_COPPER_ORE;
        }
        double random = Math.random();
        if (random < 0.6) {
            return Material.STONE;
        }
        if (random < 0.75) {
            return Material.ANDESITE;
        }
        if (random < 0.9) {
            return Material.GRANITE;
        }
        return Material.DIORITE;
    }
}

