/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.dungeon;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.api.LightweightGeminiClient;
import com.ubivismedia.aidungeon.dungeon.DungeonCollapser;
import com.ubivismedia.aidungeon.dungeon.DungeonManager;
import com.ubivismedia.aidungeon.dungeon.blocks.BlockPaletteManager;
import com.ubivismedia.aidungeon.dungeon.boss.BossManager;
import com.ubivismedia.aidungeon.dungeon.features.FeatureGenerator;
import com.ubivismedia.aidungeon.dungeon.rooms.RoomBuilder;
import com.ubivismedia.aidungeon.dungeon.theme.ThemeSelector;
import com.ubivismedia.aidungeon.integration.CustomMobResolver;
import com.ubivismedia.aidungeon.lib.gson.Gson;
import com.ubivismedia.aidungeon.lib.gson.GsonBuilder;
import com.ubivismedia.aidungeon.lib.gson.JsonObject;
import com.ubivismedia.aidungeon.lib.gson.JsonParser;
import com.ubivismedia.aidungeon.lib.gson.JsonSyntaxException;
import com.ubivismedia.aidungeon.lib.gson.stream.JsonReader;
import com.ubivismedia.aidungeon.model.Dungeon;
import com.ubivismedia.aidungeon.model.Room;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class DungeonGenerator {
    private final AIDungeon plugin;
    private final DungeonManager dungeonManager;
    private final LightweightGeminiClient geminiApiClient;
    private final Random random = new Random();
    private final CustomMobResolver customMobResolver;
    private final BlockPaletteManager blockPaletteManager;
    private final FeatureGenerator featureGenerator;
    private final BossManager bossManager;
    private final RoomBuilder roomBuilder;
    private final ThemeSelector themeSelector;
    private final Gson gson;

    public DungeonGenerator(AIDungeon plugin, DungeonManager dungeonManager, LightweightGeminiClient geminiApiClient, CustomMobResolver customMobResolver) {
        this.plugin = plugin;
        this.dungeonManager = dungeonManager;
        this.geminiApiClient = geminiApiClient;
        this.customMobResolver = customMobResolver;
        this.blockPaletteManager = new BlockPaletteManager();
        this.featureGenerator = new FeatureGenerator(plugin);
        this.bossManager = new BossManager(plugin);
        this.roomBuilder = new RoomBuilder(plugin, this.blockPaletteManager);
        this.themeSelector = new ThemeSelector(plugin);
        this.gson = new GsonBuilder().setLenient().create();
    }

    public CompletableFuture<Dungeon> generateDungeon(World world, int x, int y, int z, String biomeType) {
        int dungeonY;
        int highestY;
        Material material;
        int groundY;
        String theme = this.themeSelector.selectThemeForBiome(biomeType);
        boolean isPyramidTheme = theme.toLowerCase().contains("pyramid") || theme.toLowerCase().contains("temple") && biomeType.toLowerCase().contains("desert");
        for (groundY = highestY = world.getHighestBlockYAt(x, z); groundY > 0 && (!(material = world.getBlockAt(x, groundY, z).getType()).isSolid() || material.name().contains("LEAVES") || material.name().contains("LOG") || material.name().contains("FENCE") || material.name().contains("VINE") || material.equals((Object)Material.SNOW) || material.equals((Object)Material.SNOW_BLOCK)); --groundY) {
        }
        if (groundY < 40 || !this.hasContinuousSolidTerrain(world, x, groundY, z, 5)) {
            this.plugin.getLogger().info("Location at " + x + "," + groundY + "," + z + " not suitable for dungeon: insufficient solid terrain");
            return CompletableFuture.completedFuture(null);
        }
        if (this.isWaterArea(world, x, groundY, z, 10)) {
            this.plugin.getLogger().info("Location at " + x + "," + groundY + "," + z + " not suitable for dungeon: water body detected");
            return CompletableFuture.completedFuture(null);
        }
        if (isPyramidTheme) {
            dungeonY = groundY - 3;
        } else {
            int minDepth = 20;
            int maxDepth = 50;
            int targetDepth = Math.min(minDepth + this.random.nextInt(maxDepth - minDepth), groundY - 10);
            dungeonY = groundY - targetDepth;
            dungeonY = Math.max(dungeonY, 20);
        }
        Dungeon dungeon = new Dungeon();
        dungeon.setWorldName(world.getName());
        dungeon.setBiomeType(biomeType);
        dungeon.setXCoord(x);
        dungeon.setYCoord(dungeonY);
        dungeon.setZCoord(z);
        dungeon.setCreatedAt(LocalDateTime.now());
        dungeon.setStatus(Dungeon.Status.GENERATING);
        dungeon.setTheme(theme);
        CompletableFuture<Dungeon> future = new CompletableFuture<Dungeon>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection conn = this.plugin.getDatabaseManager().getConnection();
                 PreparedStatement stmt = conn.prepareStatement("INSERT INTO dungeons (world_name, biome_type, theme, x_coord, y_coord, z_coord, status) VALUES (?, ?, ?, ?, ?, ?, ?)", 1);){
                stmt.setString(1, dungeon.getWorldName());
                stmt.setString(2, dungeon.getBiomeType());
                stmt.setString(3, dungeon.getTheme());
                stmt.setInt(4, dungeon.getXCoord());
                stmt.setInt(5, dungeon.getYCoord());
                stmt.setInt(6, dungeon.getZCoord());
                stmt.setString(7, dungeon.getStatus().toString());
                int affectedRows = stmt.executeUpdate();
                if (affectedRows == 0) {
                    future.completeExceptionally(new SQLException("Creating dungeon failed, no rows affected."));
                    return;
                }
                try (ResultSet generatedKeys = stmt.getGeneratedKeys();){
                    if (!generatedKeys.next()) {
                        future.completeExceptionally(new SQLException("Creating dungeon failed, no ID obtained."));
                        return;
                    }
                    dungeon.setId(generatedKeys.getInt(1));
                }
                ((CompletableFuture)this.callGeminiForDungeonDesign(biomeType, theme, world.getSeed()).thenAccept(dungeonDesign -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((CompletableFuture)this.createDungeonFromDesign(dungeon, world, (String)dungeonDesign).thenAccept(rooms -> ((CompletableFuture)this.saveRoomsToDB(dungeon.getId(), (List<Room>)rooms).thenRun(() -> ((CompletableFuture)this.updateDungeonStatus(dungeon.getId(), Dungeon.Status.ACTIVE).thenRun(() -> {
                    dungeon.setStatus(Dungeon.Status.ACTIVE);
                    dungeon.setRooms((List<Room>)rooms);
                    future.complete(dungeon);
                })).exceptionally(ex -> {
                    future.completeExceptionally((Throwable)ex);
                    return null;
                }))).exceptionally(ex -> {
                    future.completeExceptionally((Throwable)ex);
                    return null;
                }))).exceptionally(ex -> {
                    future.completeExceptionally((Throwable)ex);
                    return null;
                })))).exceptionally(ex -> {
                    this.plugin.getLogger().log(Level.WARNING, "Gemini API error, using fallback generation: ", (Throwable)ex);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((CompletableFuture)this.createFallbackDungeon(dungeon, world).thenAccept(rooms -> ((CompletableFuture)this.saveRoomsToDB(dungeon.getId(), (List<Room>)rooms).thenRun(() -> ((CompletableFuture)this.updateDungeonStatus(dungeon.getId(), Dungeon.Status.ACTIVE).thenRun(() -> {
                        dungeon.setStatus(Dungeon.Status.ACTIVE);
                        dungeon.setRooms((List<Room>)rooms);
                        future.complete(dungeon);
                    })).exceptionally(fallbackEx -> {
                        future.completeExceptionally((Throwable)fallbackEx);
                        return null;
                    }))).exceptionally(fallbackEx -> {
                        future.completeExceptionally((Throwable)fallbackEx);
                        return null;
                    }))).exceptionally(fallbackEx -> {
                        future.completeExceptionally((Throwable)fallbackEx);
                        return null;
                    }));
                    return null;
                });
                return;
            }
            catch (SQLException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private boolean hasContinuousSolidTerrain(World world, int x, int y, int z, int depth) {
        int continuousSolidBlocks = 0;
        int requiredSolidBlocks = 3;
        for (int i = 0; i < depth; ++i) {
            Material material = world.getBlockAt(x, y - i, z).getType();
            if (!(!material.isSolid() || material.name().contains("LEAVES") || material.name().contains("LOG") || material.name().contains("FENCE") || material.equals((Object)Material.SNOW) || material.equals((Object)Material.SNOW_BLOCK))) {
                if (++continuousSolidBlocks < requiredSolidBlocks) continue;
                return true;
            }
            continuousSolidBlocks = 0;
        }
        return false;
    }

    private boolean isWaterArea(World world, int x, int y, int z, int radius) {
        int waterBlocks = 0;
        int totalBlocks = 0;
        for (int dx = -radius; dx <= radius; dx += 2) {
            for (int dz = -radius; dz <= radius; dz += 2) {
                Material material = world.getBlockAt(x + dx, y, z + dz).getType();
                ++totalBlocks;
                if (!material.equals((Object)Material.WATER) && !material.equals((Object)Material.ICE) && !material.name().contains("OCEAN") && !material.name().contains("WATER") && !material.name().contains("SEAGRASS")) continue;
                ++waterBlocks;
            }
        }
        return (double)waterBlocks / (double)totalBlocks > 0.25;
    }

    private CompletableFuture<String> callGeminiForDungeonDesign(String biomeType, String theme, long worldSeed) {
        StringBuilder prompt = new StringBuilder();
        prompt.append("Generate a Minecraft dungeon design with the following specifications:\n");
        prompt.append("Biome Type: ").append(biomeType).append("\n");
        prompt.append("Theme: ").append(theme).append("\n");
        prompt.append("World Seed: ").append(worldSeed).append("\n\n");
        prompt.append("Requirements:\n");
        prompt.append("1. The dungeon must have between 5-15 rooms, including an entrance room and a boss room.\n");
        prompt.append("2. Each room should have a specific type (ONLY use one of these exact types: ENTRANCE, CORRIDOR, TRAP, TREASURE, PUZZLE, BOSS).\n");
        prompt.append("3. Room dimensions should be between 5x5x3 and 20x20x8 (width x length x height).\n");
        prompt.append("4. The rooms should connect logically with corridors/doorways.\n");
        prompt.append("5. Include monster spawners appropriate for the theme and biome.\n");
        prompt.append("6. Include treasure chest locations with loot rarity (common, uncommon, rare, epic).\n");
        prompt.append("7. Design a unique boss entity for the boss room.\n\n");
        prompt.append("IMPORTANT CONSTRAINTS:\n");
        prompt.append("- For the boss 'baseEntity' field, prefer using these valid entity types: ZOMBIE, SKELETON, SPIDER, CAVE_SPIDER, CREEPER, ENDERMAN, WITCH, BLAZE, WITHER_SKELETON, VINDICATOR, EVOKER, PILLAGER.\n");
        prompt.append("- For biome-specific bosses, suggest a thematic entity type that matches the biome's environment. Custom entity types can be used but may be substituted if not found.\n");
        prompt.append("- For the boss 'abilities' array, use these ability names: teleport, summon_minions, fire_aura, speed_boost, resistance, regeneration, slow_aura, frost_attack.\n");
        prompt.append("- Tailor the boss abilities to match the theme and biome - fire abilities for hot biomes, frost abilities for cold biomes, etc.\n\n");
        prompt.append("Return the dungeon design as a JSON object with the following structure:\n");
        prompt.append("{\n");
        prompt.append("  \"rooms\": [\n");
        prompt.append("    {\n");
        prompt.append("      \"roomType\": \"ENTRANCE/CORRIDOR/TRAP/TREASURE/PUZZLE/BOSS\",\n");
        prompt.append("      \"width\": number,\n");
        prompt.append("      \"height\": number,\n");
        prompt.append("      \"length\": number,\n");
        prompt.append("      \"relativePosition\": { \"x\": number, \"y\": number, \"z\": number },\n");
        prompt.append("      \"features\": [\n");
        prompt.append("        { \"type\": \"FEATURE_TYPE\", \"x\": number, \"y\": number, \"z\": number, \"data\": {...} }\n");
        prompt.append("      ]\n");
        prompt.append("    }\n");
        prompt.append("  ],\n");
        prompt.append("  \"boss\": {\n");
        prompt.append("    \"name\": \"Boss Name\",\n");
        prompt.append("    \"baseEntity\": \"ENTITY_TYPE\",\n");
        prompt.append("    \"health\": number,\n");
        prompt.append("    \"abilities\": [ \"ability1\", \"ability2\" ],\n");
        prompt.append("    \"drops\": [ { \"type\": \"ITEM_TYPE\", \"chance\": number } ]\n");
        prompt.append("  },\n");
        prompt.append("  \"description\": \"A brief description of the dungeon\"\n");
        prompt.append("}\n");
        return this.geminiApiClient.generateContent(prompt.toString());
    }

    private CompletableFuture<List<Room>> createDungeonFromDesign(Dungeon dungeon, World world, String dungeonDesign) {
        CompletableFuture<List<Room>> future = new CompletableFuture<List<Room>>();
        try {
            JsonObject design;
            if (this.plugin.getConfigManager().getConfig().getBoolean("debug.logApiCalls", false)) {
                this.plugin.getLogger().info("Received dungeon design from Gemini API: " + dungeonDesign);
            }
            try {
                JsonReader reader = new JsonReader(new StringReader(dungeonDesign));
                reader.setLenient(true);
                design = JsonParser.parseReader(reader).getAsJsonObject();
            }
            catch (JsonSyntaxException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error parsing dungeon design JSON: ", e);
                this.plugin.getLogger().log(Level.SEVERE, "Invalid JSON: " + dungeonDesign);
                ((CompletableFuture)this.createFallbackDungeon(dungeon, world).thenAccept(future::complete)).exceptionally(ex -> {
                    future.completeExceptionally((Throwable)ex);
                    return null;
                });
                return future;
            }
            ((CompletableFuture)this.roomBuilder.buildDungeonFromDesign(dungeon, world, design).thenAccept(rooms -> {
                this.createRoomConnections(world, (List<Room>)rooms, dungeon, dungeon.getTheme());
                Room bossRoom = this.getRoomByType((List<Room>)rooms, "BOSS");
                if (bossRoom != null && design.has("boss")) {
                    this.bossManager.spawnBoss(world, bossRoom, design.getAsJsonObject("boss"), dungeon.getId(), dungeon);
                }
                future.complete((List<Room>)rooms);
            })).exceptionally(ex -> {
                this.plugin.getLogger().log(Level.SEVERE, "Error building dungeon: ", (Throwable)ex);
                future.completeExceptionally((Throwable)ex);
                return null;
            });
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error creating dungeon from design: ", e);
            future.completeExceptionally(e);
        }
        return future;
    }

    private Room getRoomByType(List<Room> rooms, String roomType) {
        for (Room room : rooms) {
            if (!room.getRoomType().equals(roomType)) continue;
            return room;
        }
        return null;
    }

    private CompletableFuture<List<Room>> createFallbackDungeon(Dungeon dungeon, World world) {
        this.plugin.getLogger().info("Creating fallback dungeon for ID: " + dungeon.getId());
        return this.roomBuilder.buildFallbackDungeon(dungeon, world).thenApply(rooms -> {
            this.createRoomConnections(world, (List<Room>)rooms, dungeon, dungeon.getTheme());
            Room bossRoom = this.getRoomByType((List<Room>)rooms, "BOSS");
            if (bossRoom != null) {
                JsonObject simpleBossData = new JsonObject();
                simpleBossData.addProperty("name", "Ancient Guardian");
                simpleBossData.addProperty("baseEntity", "ZOMBIE");
                simpleBossData.addProperty("health", 100.0);
                this.bossManager.spawnBoss(world, bossRoom, simpleBossData, dungeon.getId(), dungeon);
            }
            return rooms;
        });
    }

    private CompletableFuture<Void> saveRoomsToDB(int dungeonId, List<Room> rooms) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection conn = this.plugin.getDatabaseManager().getConnection();
                 PreparedStatement stmt = conn.prepareStatement("INSERT INTO rooms (dungeon_id, room_type, x_coord, y_coord, z_coord, width, height, length) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", 1);){
                conn.setAutoCommit(false);
                for (Room room : rooms) {
                    stmt.setInt(1, dungeonId);
                    stmt.setString(2, room.getRoomType());
                    stmt.setInt(3, room.getXCoord());
                    stmt.setInt(4, room.getYCoord());
                    stmt.setInt(5, room.getZCoord());
                    stmt.setInt(6, room.getWidth());
                    stmt.setInt(7, room.getHeight());
                    stmt.setInt(8, room.getLength());
                    stmt.addBatch();
                }
                stmt.executeBatch();
                ResultSet generatedKeys = stmt.getGeneratedKeys();
                for (int roomIndex = 0; generatedKeys.next() && roomIndex < rooms.size(); ++roomIndex) {
                    ((Room)rooms.get(roomIndex)).setId(generatedKeys.getInt(1));
                }
                conn.commit();
                future.complete(null);
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to save rooms to database: ", e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private CompletableFuture<Void> updateDungeonStatus(int dungeonId, Dungeon.Status status) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection conn = this.plugin.getDatabaseManager().getConnection();
                 PreparedStatement stmt = conn.prepareStatement("UPDATE dungeons SET status = ? WHERE id = ?");){
                stmt.setString(1, status.toString());
                stmt.setInt(2, dungeonId);
                stmt.executeUpdate();
                future.complete(null);
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to update dungeon status: ", e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Void> collapseDungeon(Dungeon dungeon, World world) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            List<Room> rooms = dungeon.getRooms();
            if (rooms.isEmpty()) {
                future.complete(null);
                return future;
            }
            ArrayList<Vector> blockPositions = new ArrayList<Vector>();
            for (Room room : rooms) {
                for (int x = room.getXCoord(); x < room.getXCoord() + room.getWidth(); ++x) {
                    for (int y = room.getYCoord(); y < room.getYCoord() + room.getHeight(); ++y) {
                        for (int z = room.getZCoord(); z < room.getZCoord() + room.getLength(); ++z) {
                            blockPositions.add(new Vector(x, y, z));
                        }
                    }
                }
            }
            Collections.shuffle(blockPositions);
            int blocksPerTick = this.plugin.getConfigManager().getConfig().getInt("performance.blocksPerTick", 20);
            int totalTasks = (int)Math.ceil((double)blockPositions.size() / (double)blocksPerTick);
            int[] completedTasks = new int[]{0};
            int taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
                int startIndex = completedTasks[0] * blocksPerTick;
                int endIndex = Math.min(startIndex + blocksPerTick, blockPositions.size());
                for (int i = startIndex; i < endIndex; ++i) {
                    Vector pos = (Vector)blockPositions.get(i);
                    Block block = world.getBlockAt(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
                    block.setType(DungeonCollapser.getReplacementMaterial(world, pos));
                    world.spawnParticle(Particle.CLOUD, (double)pos.getBlockX() + 0.5, (double)pos.getBlockY() + 0.5, (double)pos.getBlockZ() + 0.5, 3, 0.3, 0.3, 0.3, 0.05);
                }
                completedTasks[0] = completedTasks[0] + 1;
                if (completedTasks[0] >= totalTasks) {
                    int currentTaskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {}, 0L);
                    Bukkit.getScheduler().cancelTask(currentTaskId);
                    future.complete(null);
                }
            }, 1L, 1L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (!future.isDone()) {
                    Bukkit.getScheduler().cancelTask(taskId);
                    future.complete(null);
                }
            }, 6000L);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error collapsing dungeon: ", e);
            future.completeExceptionally(e);
        }
        return future;
    }

    private void createRoomConnections(World world, List<Room> rooms, Dungeon dungeon, String theme) {
        if (rooms.size() < 2) {
            return;
        }
        this.plugin.getLogger().info("Creating connections between " + rooms.size() + " rooms for dungeon #" + dungeon.getId());
        ArrayList<Room> sortedRooms = new ArrayList<Room>(rooms);
        sortedRooms.sort(Comparator.comparingInt(room -> {
            String type;
            switch (type = room.getRoomType()) {
                case "ENTRANCE": {
                    return 0;
                }
                case "CORRIDOR": {
                    return 1;
                }
                case "TREASURE": {
                    return 2;
                }
                case "TRAP": {
                    return 3;
                }
                case "PUZZLE": {
                    return 4;
                }
                case "BOSS": {
                    return 5;
                }
            }
            return 6;
        }));
        for (int i = 0; i < sortedRooms.size() - 1; ++i) {
            Room currentRoom = (Room)sortedRooms.get(i);
            Room nextRoom = (Room)sortedRooms.get(i + 1);
            int currentX = currentRoom.getXCoord() + currentRoom.getWidth() / 2;
            int currentY = currentRoom.getYCoord() + currentRoom.getHeight() / 2;
            int currentZ = currentRoom.getZCoord() + currentRoom.getLength() / 2;
            int nextX = nextRoom.getXCoord() + nextRoom.getWidth() / 2;
            int nextY = nextRoom.getYCoord() + nextRoom.getHeight() / 2;
            int nextZ = nextRoom.getZCoord() + nextRoom.getLength() / 2;
            ConnectionPoint connection = this.findBestConnectionPoint(currentRoom, nextRoom);
            this.createTunnelBetweenPoints(world, connection.startX, connection.startY, connection.startZ, connection.endX, connection.endY, connection.endZ, theme, nextRoom.getRoomType().equals("BOSS"));
        }
    }

    private ConnectionPoint findBestConnectionPoint(Room room1, Room room2) {
        ArrayList<ConnectionPoint> possibleConnections = new ArrayList<ConnectionPoint>();
        int eastX = room1.getXCoord() + room1.getWidth() - 1;
        for (int y = room1.getYCoord() + 1; y < room1.getYCoord() + room1.getHeight() - 1; ++y) {
            for (int z = room1.getZCoord() + 1; z < room1.getZCoord() + room1.getLength() - 1; ++z) {
                int westX = room2.getXCoord();
                for (int y2 = room2.getYCoord() + 1; y2 < room2.getYCoord() + room2.getHeight() - 1; ++y2) {
                    for (int z2 = room2.getZCoord() + 1; z2 < room2.getZCoord() + room2.getLength() - 1; ++z2) {
                        possibleConnections.add(new ConnectionPoint(eastX, y, z, westX, y2, z2));
                    }
                }
            }
        }
        int westX = room1.getXCoord();
        for (int y = room1.getYCoord() + 1; y < room1.getYCoord() + room1.getHeight() - 1; ++y) {
            for (int z = room1.getZCoord() + 1; z < room1.getZCoord() + room1.getLength() - 1; ++z) {
                int eastX2 = room2.getXCoord() + room2.getWidth() - 1;
                for (int y2 = room2.getYCoord() + 1; y2 < room2.getYCoord() + room2.getHeight() - 1; ++y2) {
                    for (int z2 = room2.getZCoord() + 1; z2 < room2.getZCoord() + room2.getLength() - 1; ++z2) {
                        possibleConnections.add(new ConnectionPoint(westX, y, z, eastX2, y2, z2));
                    }
                }
            }
        }
        int northZ = room1.getZCoord();
        for (int y = room1.getYCoord() + 1; y < room1.getYCoord() + room1.getHeight() - 1; ++y) {
            for (int x = room1.getXCoord() + 1; x < room1.getXCoord() + room1.getWidth() - 1; ++x) {
                int southZ2 = room2.getZCoord() + room2.getLength() - 1;
                for (int y2 = room2.getYCoord() + 1; y2 < room2.getYCoord() + room2.getHeight() - 1; ++y2) {
                    for (int x2 = room2.getXCoord() + 1; x2 < room2.getXCoord() + room2.getWidth() - 1; ++x2) {
                        possibleConnections.add(new ConnectionPoint(x, y, northZ, x2, y2, southZ2));
                    }
                }
            }
        }
        int southZ = room1.getZCoord() + room1.getLength() - 1;
        for (int y = room1.getYCoord() + 1; y < room1.getYCoord() + room1.getHeight() - 1; ++y) {
            for (int x = room1.getXCoord() + 1; x < room1.getXCoord() + room1.getWidth() - 1; ++x) {
                int northZ2 = room2.getZCoord();
                for (int y2 = room2.getYCoord() + 1; y2 < room2.getYCoord() + room2.getHeight() - 1; ++y2) {
                    for (int x2 = room2.getXCoord() + 1; x2 < room2.getXCoord() + room2.getWidth() - 1; ++x2) {
                        possibleConnections.add(new ConnectionPoint(x, y, southZ, x2, y2, northZ2));
                    }
                }
            }
        }
        return possibleConnections.stream().min(Comparator.comparingDouble(c -> c.distance)).orElse(new ConnectionPoint(room1.getXCoord() + room1.getWidth() / 2, room1.getYCoord() + 1, room1.getZCoord() + room1.getLength() / 2, room2.getXCoord() + room2.getWidth() / 2, room2.getYCoord() + 1, room2.getZCoord() + room2.getLength() / 2));
    }

    private void createTunnelBetweenPoints(World world, int x1, int y1, int z1, int x2, int y2, int z2, String theme, boolean isBossConnection) {
        this.plugin.getLogger().info("Creating tunnel from (" + x1 + "," + y1 + "," + z1 + ") to (" + x2 + "," + y2 + "," + z2 + ")");
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        int minY = Math.min(y1, y2);
        int maxY = Math.max(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxZ = Math.max(z1, z2);
        List<Material> palette = this.blockPaletteManager.getBlockPalette(world.getBiome(x1, y1, z1).toString(), theme);
        Material doorMaterial = this.getDoorMaterialForTheme(theme, isBossConnection);
        int tunnelWidth = 3;
        int tunnelHeight = 3;
        if (maxX - minX > maxZ - minZ) {
            for (int x = minX; x <= maxX; ++x) {
                this.createTunnelSegment(world, x, y1, z1, tunnelWidth, tunnelHeight, true, palette, doorMaterial, x == minX || x == maxX, isBossConnection && (x == minX || x == maxX));
            }
        } else {
            for (int z = minZ; z <= maxZ; ++z) {
                this.createTunnelSegment(world, x1, y1, z, tunnelWidth, tunnelHeight, false, palette, doorMaterial, z == minZ || z == maxZ, isBossConnection && (z == minZ || z == maxZ));
            }
        }
        if (maxY - minY > 1) {
            this.createVerticalConnection(world, x1, minY, z1, maxY - minY, palette);
        }
    }

    private void createTunnelSegment(World world, int x, int y, int z, int width, int height, boolean isXAligned, List<Material> palette, Material doorMaterial, boolean isEndpoint, boolean isBossConnection) {
        block20: {
            int dx;
            int dy;
            int startY;
            int halfWidth;
            block19: {
                int dz;
                int dy2;
                halfWidth = width / 2;
                startY = y - 1;
                if (!isXAligned) break block19;
                for (dy2 = 0; dy2 < height; ++dy2) {
                    for (dz = -halfWidth; dz <= halfWidth; ++dz) {
                        world.getBlockAt(x, startY + dy2, z + dz).setType(Material.AIR);
                        if (dy2 == 0) {
                            world.getBlockAt(x, startY, z + dz).setType(palette.get(this.random.nextInt(palette.size())));
                            continue;
                        }
                        if (dy2 == height - 1) {
                            world.getBlockAt(x, startY + height - 1, z + dz).setType(palette.get(this.random.nextInt(palette.size())));
                            continue;
                        }
                        if (Math.abs(dz) != halfWidth) continue;
                        world.getBlockAt(x, startY + dy2, z + dz).setType(palette.get(this.random.nextInt(palette.size())));
                    }
                }
                if (!isEndpoint || doorMaterial == Material.AIR) break block20;
                if (isBossConnection) {
                    this.createBossRoomEntrance(world, x, startY, z, isXAligned, palette, doorMaterial);
                } else {
                    for (dy2 = 1; dy2 < height - 1; ++dy2) {
                        for (dz = -1; dz <= 1; ++dz) {
                            if (dy2 == 1 && dz == 0) {
                                world.getBlockAt(x, startY + dy2, z + dz).setType(doorMaterial);
                                continue;
                            }
                            world.getBlockAt(x, startY + dy2, z + dz).setType(Material.AIR);
                        }
                    }
                }
                break block20;
            }
            for (dy = 0; dy < height; ++dy) {
                for (dx = -halfWidth; dx <= halfWidth; ++dx) {
                    world.getBlockAt(x + dx, startY + dy, z).setType(Material.AIR);
                    if (dy == 0) {
                        world.getBlockAt(x + dx, startY, z).setType(palette.get(this.random.nextInt(palette.size())));
                        continue;
                    }
                    if (dy == height - 1) {
                        world.getBlockAt(x + dx, startY + height - 1, z).setType(palette.get(this.random.nextInt(palette.size())));
                        continue;
                    }
                    if (Math.abs(dx) != halfWidth) continue;
                    world.getBlockAt(x + dx, startY + dy, z).setType(palette.get(this.random.nextInt(palette.size())));
                }
            }
            if (isEndpoint && doorMaterial != Material.AIR) {
                if (isBossConnection) {
                    this.createBossRoomEntrance(world, x, startY, z, isXAligned, palette, doorMaterial);
                } else {
                    for (dy = 1; dy < height - 1; ++dy) {
                        for (dx = -1; dx <= 1; ++dx) {
                            if (dy == 1 && dx == 0) {
                                world.getBlockAt(x + dx, startY + dy, z).setType(doorMaterial);
                                continue;
                            }
                            world.getBlockAt(x + dx, startY + dy, z).setType(Material.AIR);
                        }
                    }
                }
            }
        }
    }

    private void createVerticalConnection(World world, int x, int minY, int z, int height, List<Material> palette) {
        for (int dy = 0; dy < height; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    world.getBlockAt(x + dx, minY + dy, z + dz).setType(Material.AIR);
                }
            }
            world.getBlockAt(x + 1, minY + dy, z).setType(Material.LADDER);
            Block ladderBlock = world.getBlockAt(x + 1, minY + dy, z);
            if (!(ladderBlock.getBlockData() instanceof Directional)) continue;
            Directional directional = (Directional)ladderBlock.getBlockData();
            directional.setFacing(BlockFace.WEST);
            ladderBlock.setBlockData((BlockData)directional);
        }
    }

    private void createBossRoomEntrance(World world, int x, int y, int z, boolean isXAligned, List<Material> palette, Material doorMaterial) {
        if (isXAligned) {
            for (int dy = 1; dy < 4; ++dy) {
                for (int dz = -2; dz <= 2; ++dz) {
                    if (Math.abs(dz) <= 1) {
                        world.getBlockAt(x, y + dy, z + dz).setType(Material.AIR);
                    }
                    if (Math.abs(dz) != 2 && dy != 3 || Math.abs(dz) > 2) continue;
                    world.getBlockAt(x, y + dy, z + dz).setType(palette.get(this.random.nextInt(palette.size())));
                }
            }
            world.getBlockAt(x, y + 3, z).setType(Material.IRON_BARS);
            world.getBlockAt(x, y + 3, z - 1).setType(Material.IRON_BARS);
            world.getBlockAt(x, y + 3, z + 1).setType(Material.IRON_BARS);
        } else {
            for (int dy = 1; dy < 4; ++dy) {
                for (int dx = -2; dx <= 2; ++dx) {
                    if (Math.abs(dx) <= 1) {
                        world.getBlockAt(x + dx, y + dy, z).setType(Material.AIR);
                    }
                    if (Math.abs(dx) != 2 && dy != 3 || Math.abs(dx) > 2) continue;
                    world.getBlockAt(x + dx, y + dy, z).setType(palette.get(this.random.nextInt(palette.size())));
                }
            }
            world.getBlockAt(x, y + 3, z).setType(Material.IRON_BARS);
            world.getBlockAt(x - 1, y + 3, z).setType(Material.IRON_BARS);
            world.getBlockAt(x + 1, y + 3, z).setType(Material.IRON_BARS);
        }
    }

    private Material getDoorMaterialForTheme(String theme, boolean isBossConnection) {
        if (isBossConnection) {
            return Material.IRON_DOOR;
        }
        if ((theme = theme.toLowerCase()).contains("ancient") || theme.contains("temple")) {
            return Material.IRON_DOOR;
        }
        if (theme.contains("mine") || theme.contains("dwarven")) {
            return Material.DARK_OAK_DOOR;
        }
        if (theme.contains("haunted") || theme.contains("cursed")) {
            return Material.DARK_OAK_DOOR;
        }
        if (theme.contains("wizard") || theme.contains("laboratory")) {
            return Material.WARPED_DOOR;
        }
        if (theme.contains("jungle") || theme.contains("tribal")) {
            return Material.JUNGLE_DOOR;
        }
        return Material.OAK_DOOR;
    }

    private static class ConnectionPoint {
        int startX;
        int startY;
        int startZ;
        int endX;
        int endY;
        int endZ;
        double distance;

        ConnectionPoint(int startX, int startY, int startZ, int endX, int endY, int endZ) {
            this.startX = startX;
            this.startY = startY;
            this.startZ = startZ;
            this.endX = endX;
            this.endY = endY;
            this.endZ = endZ;
            this.distance = Math.sqrt(Math.pow(endX - startX, 2.0) + Math.pow(endY - startY, 2.0) + Math.pow(endZ - startZ, 2.0));
        }
    }
}

