/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.dungeon.blocks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;

public class BlockPaletteManager {
    private final Map<String, Map<String, List<Material>>> blockPalettes = new HashMap<String, Map<String, List<Material>>>();

    public BlockPaletteManager() {
        this.initializeBlockPalettes();
    }

    private void initializeBlockPalettes() {
        HashMap<String, List<Material>> desertPalettes = new HashMap<String, List<Material>>();
        List<Material> desertTemple = List.of(Material.SANDSTONE, Material.CHISELED_SANDSTONE, Material.CUT_SANDSTONE, Material.SMOOTH_SANDSTONE, Material.ORANGE_TERRACOTTA, Material.YELLOW_TERRACOTTA, Material.SAND, Material.GOLD_BLOCK);
        desertPalettes.put("ancient_temple", desertTemple);
        List<Material> desertMine = List.of(Material.SANDSTONE, Material.TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.RED_SANDSTONE, Material.SMOOTH_RED_SANDSTONE, Material.STRIPPED_ACACIA_LOG, Material.ACACIA_PLANKS);
        desertPalettes.put("abandoned_mine", desertMine);
        this.blockPalettes.put("DESERT", desertPalettes);
        HashMap<String, List<Material>> forestPalettes = new HashMap<String, List<Material>>();
        List<Material> forestTemple = List.of(Material.MOSSY_COBBLESTONE, Material.COBBLESTONE, Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS, Material.CRACKED_STONE_BRICKS, Material.OAK_LOG, Material.OAK_PLANKS, Material.SPRUCE_PLANKS);
        forestPalettes.put("ancient_temple", forestTemple);
        List<Material> hauntedMansion = List.of(Material.DARK_OAK_PLANKS, Material.DARK_OAK_LOG, Material.COBWEB, Material.STONE_BRICKS, Material.CRACKED_STONE_BRICKS, Material.BLACK_WOOL);
        forestPalettes.put("haunted_mansion", hauntedMansion);
        this.blockPalettes.put("FOREST", forestPalettes);
        HashMap<String, List<Material>> defaultPalettes = new HashMap<String, List<Material>>();
        List<Material> defaultPalette = List.of(Material.STONE_BRICKS, Material.CRACKED_STONE_BRICKS, Material.MOSSY_STONE_BRICKS, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE, Material.ANDESITE);
        defaultPalettes.put("default", defaultPalette);
        this.blockPalettes.put("DEFAULT", defaultPalettes);
    }

    public List<Material> getBlockPalette(String biomeType, String theme) {
        if (this.blockPalettes.containsKey(biomeType)) {
            Map<String, List<Material>> themePalettes = this.blockPalettes.get(biomeType);
            if (themePalettes.containsKey(theme)) {
                return themePalettes.get(theme);
            }
            if (themePalettes.containsKey("default")) {
                return themePalettes.get("default");
            }
        }
        return this.blockPalettes.get("DEFAULT").get("default");
    }
}

