/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.dungeon.boss;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.integration.CustomMobResolver;
import com.ubivismedia.aidungeon.lib.gson.JsonArray;
import com.ubivismedia.aidungeon.lib.gson.JsonElement;
import com.ubivismedia.aidungeon.lib.gson.JsonObject;
import com.ubivismedia.aidungeon.model.Dungeon;
import com.ubivismedia.aidungeon.model.Room;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BossManager {
    private final AIDungeon plugin;
    private final Random random = new Random();
    private final Set<String> validEntityTypes = new HashSet<String>();
    private final CustomMobResolver customMobResolver;

    public BossManager(AIDungeon plugin) {
        this.plugin = plugin;
        this.customMobResolver = new CustomMobResolver(plugin);
        this.initializeValidEntityTypes();
    }

    private void initializeValidEntityTypes() {
        this.validEntityTypes.add("ZOMBIE");
        this.validEntityTypes.add("SKELETON");
        this.validEntityTypes.add("SPIDER");
        this.validEntityTypes.add("CAVE_SPIDER");
        this.validEntityTypes.add("CREEPER");
        this.validEntityTypes.add("ENDERMAN");
        this.validEntityTypes.add("WITCH");
        this.validEntityTypes.add("BLAZE");
        this.validEntityTypes.add("WITHER_SKELETON");
        this.validEntityTypes.add("VINDICATOR");
        this.validEntityTypes.add("EVOKER");
        this.validEntityTypes.add("PILLAGER");
        this.validEntityTypes.add("RAVAGER");
        this.validEntityTypes.add("ELDER_GUARDIAN");
        this.validEntityTypes.add("WARDEN");
        this.validEntityTypes.add("ILLUSIONER");
    }

    public LivingEntity spawnBoss(World world, Room bossRoom, JsonObject bossJson, int dungeonId, Dungeon dungeon) {
        Location bossLocation = new Location(world, (double)bossRoom.getXCoord() + (double)bossRoom.getWidth() / 2.0, (double)(bossRoom.getYCoord() + 1), (double)bossRoom.getZCoord() + (double)bossRoom.getLength() / 2.0);
        LivingEntity bossEntity = null;
        if (this.plugin.getConfigManager().getConfig().getBoolean("custom_mobs.enabled", false) && (bossEntity = this.customMobResolver.resolveAndSpawnCustomMob(world, dungeon, bossLocation)) != null) {
            this.plugin.getLogger().info("Spawned custom mob as boss in dungeon #" + dungeonId);
        }
        if (bossEntity == null) {
            String baseEntityType = this.validateEntityType(bossJson.has("baseEntity") ? bossJson.get("baseEntity").getAsString() : "ZOMBIE");
            try {
                EntityType entityType = EntityType.valueOf((String)baseEntityType);
                bossEntity = (LivingEntity)world.spawnEntity(bossLocation, entityType);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid entity type: " + baseEntityType + ", using ZOMBIE");
                bossEntity = (LivingEntity)world.spawnEntity(bossLocation, EntityType.ZOMBIE);
            }
        }
        if (bossEntity != null) {
            String bossName = bossJson.has("name") ? bossJson.get("name").getAsString() : "Dungeon Boss";
            bossEntity.setCustomName("\u00a7c" + bossName);
            bossEntity.setCustomNameVisible(true);
            double bossHealth = bossJson.has("health") ? bossJson.get("health").getAsDouble() : 100.0;
            bossHealth = Math.min(1000.0, Math.max(10.0, bossHealth));
            if (bossEntity.getAttribute(Attribute.MAX_HEALTH) != null) {
                bossEntity.getAttribute(Attribute.MAX_HEALTH).setBaseValue(bossHealth);
                bossEntity.setHealth(bossHealth);
            }
            this.equipBossEntity(bossEntity, dungeonId, bossJson, dungeon.getTheme());
            bossEntity.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "dungeon_boss"), PersistentDataType.INTEGER, (Object)dungeonId);
            if (bossJson.has("abilities")) {
                this.applyBossAbilities(bossEntity, bossJson);
            } else {
                this.applyDefaultAbilities(bossEntity, dungeon.getTheme());
            }
        }
        return bossEntity;
    }

    private String validateEntityType(String entityType) {
        entityType = entityType.startsWith("minecraft:") ? entityType.substring(10).toUpperCase() : entityType.toUpperCase();
        switch (entityType) {
            case "ZOMBIE_VILLAGER": 
            case "HUSK": 
            case "DROWNED": {
                return "ZOMBIE";
            }
            case "STRAY": 
            case "SKELETON_HORSE": {
                return "SKELETON";
            }
            case "GIANT": {
                return "ZOMBIE";
            }
            case "ILLAGER": 
            case "ILLUSIONER": {
                return "EVOKER";
            }
            case "ICE_GOLEM": 
            case "SNOW_GOLEM": {
                return "IRON_GOLEM";
            }
            case "ENDER_DRAGON": 
            case "WITHER": {
                return "WITHER_SKELETON";
            }
        }
        if (this.validEntityTypes.contains(entityType)) {
            return entityType;
        }
        return "ZOMBIE";
    }

    private void equipBossEntity(LivingEntity boss, int dungeonId, JsonObject bossJson, String theme) {
        if (!(boss instanceof Mob)) {
            return;
        }
        Mob mobBoss = (Mob)boss;
        mobBoss.setRemoveWhenFarAway(false);
        if (boss instanceof Zombie || boss instanceof Skeleton || boss instanceof Piglin) {
            Material weaponType = this.getMaterialForTheme(theme, true);
            Material armorType = this.getMaterialForTheme(theme, false);
            ItemStack weapon = new ItemStack(weaponType);
            ItemMeta weaponMeta = weapon.getItemMeta();
            if (weaponMeta != null) {
                weaponMeta.addEnchant(Enchantment.SHARPNESS, 3, true);
                weaponMeta.setUnbreakable(true);
                weapon.setItemMeta(weaponMeta);
            }
            ItemStack helmet = new ItemStack(armorType);
            ItemStack chestplate = new ItemStack(armorType);
            ItemStack leggings = new ItemStack(armorType);
            ItemStack boots = new ItemStack(armorType);
            for (ItemStack armor : new ItemStack[]{helmet, chestplate, leggings, boots}) {
                ItemMeta meta = armor.getItemMeta();
                if (meta == null) continue;
                meta.addEnchant(Enchantment.PROTECTION, 3, true);
                meta.setUnbreakable(true);
                armor.setItemMeta(meta);
            }
            mobBoss.getEquipment().setItemInMainHand(weapon);
            mobBoss.getEquipment().setHelmet(helmet);
            mobBoss.getEquipment().setChestplate(chestplate);
            mobBoss.getEquipment().setLeggings(leggings);
            mobBoss.getEquipment().setBoots(boots);
            mobBoss.getEquipment().setItemInMainHandDropChance(0.1f);
            mobBoss.getEquipment().setHelmetDropChance(0.05f);
            mobBoss.getEquipment().setChestplateDropChance(0.05f);
            mobBoss.getEquipment().setLeggingsDropChance(0.05f);
            mobBoss.getEquipment().setBootsDropChance(0.05f);
        }
    }

    private Material getMaterialForTheme(String theme, boolean isWeapon) {
        theme = theme.toLowerCase();
        if (isWeapon) {
            if (theme.contains("temple") || theme.contains("ancient")) {
                return Material.GOLDEN_SWORD;
            }
            if (theme.contains("mine") || theme.contains("dwarven")) {
                return Material.DIAMOND_PICKAXE;
            }
            if (theme.contains("haunted") || theme.contains("cursed")) {
                return Material.NETHERITE_SWORD;
            }
            if (theme.contains("ice") || theme.contains("frost")) {
                return Material.DIAMOND_AXE;
            }
            return Material.IRON_SWORD;
        }
        if (theme.contains("temple") || theme.contains("ancient")) {
            return Material.GOLDEN_CHESTPLATE;
        }
        if (theme.contains("mine") || theme.contains("dwarven")) {
            return Material.DIAMOND_CHESTPLATE;
        }
        if (theme.contains("haunted") || theme.contains("cursed")) {
            return Material.NETHERITE_CHESTPLATE;
        }
        if (theme.contains("ice") || theme.contains("frost")) {
            return Material.DIAMOND_CHESTPLATE;
        }
        return Material.IRON_CHESTPLATE;
    }

    private void applyDefaultAbilities(LivingEntity bossEntity, String theme) {
        ArrayList<String> abilities = new ArrayList<String>();
        if ((theme = theme.toLowerCase()).contains("fire") || theme.contains("infernal") || theme.contains("lava")) {
            abilities.add("fire_aura");
            abilities.add("speed_boost");
        } else if (theme.contains("ice") || theme.contains("frost") || theme.contains("frozen")) {
            abilities.add("slow_aura");
            abilities.add("resistance");
        } else if (theme.contains("cursed") || theme.contains("haunted") || theme.contains("undead")) {
            abilities.add("teleport");
            abilities.add("regeneration");
        } else if (theme.contains("temple") || theme.contains("ancient") || theme.contains("ruins")) {
            abilities.add("summon_minions");
            abilities.add("resistance");
        } else {
            abilities.add("speed_boost");
            abilities.add("regeneration");
        }
        for (String ability : abilities) {
            this.applyAbility(bossEntity, ability);
        }
    }

    private void applyBossAbilities(LivingEntity bossEntity, JsonObject bossJson) {
        if (!bossJson.has("abilities")) {
            return;
        }
        JsonArray abilities = bossJson.getAsJsonArray("abilities");
        for (JsonElement abilityElement : abilities) {
            try {
                String ability = abilityElement.getAsString().toLowerCase();
                this.applyAbility(bossEntity, ability);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error applying boss ability: " + e.getMessage());
            }
        }
    }

    private void applyAbility(LivingEntity bossEntity, String ability) {
        if (ability.contains("fire") && ability.contains("aura")) {
            ability = "fire_aura";
        } else if (ability.contains("slow") && ability.contains("aura")) {
            ability = "slow_aura";
        } else if (ability.contains("summon") && (ability.contains("minion") || ability.contains("zombie") || ability.contains("creeper") || ability.contains("skeleton") || ability.contains("wolf") || ability.contains("golem"))) {
            ability = "summon_minions";
        } else if (ability.contains("ice") || ability.contains("frost")) {
            ability = ability.contains("nova") || ability.contains("blast") || ability.contains("beam") ? "frost_attack" : "slow_aura";
        } else if (ability.contains("teleport")) {
            ability = "teleport";
        } else if (ability.contains("regen")) {
            ability = "regeneration";
        } else if (ability.contains("speed")) {
            ability = "speed_boost";
        } else if (ability.contains("resist") || ability.contains("armor") || ability.contains("shield")) {
            ability = "resistance";
        }
        switch (ability) {
            case "teleport": {
                this.applyTeleportAbility(bossEntity);
                break;
            }
            case "summon_minions": {
                this.applySummonMinionsAbility(bossEntity);
                break;
            }
            case "fire_aura": {
                this.applyFireAuraAbility(bossEntity);
                break;
            }
            case "frost_attack": {
                this.applyFrostAttackAbility(bossEntity);
                break;
            }
            case "slow_aura": {
                this.applySlowAuraAbility(bossEntity);
                break;
            }
            case "speed_boost": {
                this.applySpeedBoostAbility(bossEntity);
                break;
            }
            case "resistance": {
                this.applyResistanceAbility(bossEntity);
                break;
            }
            case "regeneration": {
                this.applyRegenerationAbility(bossEntity);
                break;
            }
        }
    }

    private void applyTeleportAbility(LivingEntity bossEntity) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task -> {
            if (bossEntity == null || bossEntity.isDead()) {
                task.cancel();
                return;
            }
            World world = bossEntity.getWorld();
            Location currentLoc = bossEntity.getLocation();
            double dx = (Math.random() - 0.5) * 10.0;
            double dy = (Math.random() - 0.5) * 5.0;
            double dz = (Math.random() - 0.5) * 10.0;
            Location teleportLoc = currentLoc.clone().add(dx, dy, dz);
            if (teleportLoc.getBlock().isPassable() && teleportLoc.getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
                bossEntity.teleport(teleportLoc);
                world.spawnParticle(Particle.PORTAL, currentLoc, 50, 0.5, 0.5, 0.5);
                world.playSound(currentLoc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            }
        }, 100L, 200L);
    }

    private void applySummonMinionsAbility(LivingEntity bossEntity) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task -> {
            if (bossEntity == null || bossEntity.isDead()) {
                task.cancel();
                return;
            }
            World world = bossEntity.getWorld();
            Location bossLoc = bossEntity.getLocation();
            int minionCount = 2 + this.random.nextInt(3);
            for (int i = 0; i < minionCount; ++i) {
                Skeleton minion;
                double dx = (Math.random() - 0.5) * 5.0;
                double dz = (Math.random() - 0.5) * 5.0;
                Location spawnLoc = bossLoc.clone().add(dx, 1.0, dz);
                if (this.random.nextDouble() < 0.25) {
                    minion = (Skeleton)world.spawnEntity(spawnLoc, EntityType.SKELETON);
                    minion.setMaxHealth(10.0);
                    minion.setHealth(10.0);
                    continue;
                }
                minion = (Zombie)world.spawnEntity(spawnLoc, EntityType.ZOMBIE);
                minion.setMaxHealth(10.0);
                minion.setHealth(10.0);
            }
            world.spawnParticle(Particle.LARGE_SMOKE, bossLoc, 20, 1.0, 1.0, 1.0);
            world.playSound(bossLoc, Sound.ENTITY_WITHER_SPAWN, 0.5f, 1.0f);
        }, 300L, 600L);
    }

    private void applyFireAuraAbility(LivingEntity bossEntity) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task -> {
            if (bossEntity == null || bossEntity.isDead()) {
                task.cancel();
                return;
            }
            World world = bossEntity.getWorld();
            Location bossLoc = bossEntity.getLocation();
            for (Entity nearby : bossEntity.getNearbyEntities(5.0, 5.0, 5.0)) {
                if (!(nearby instanceof Player)) continue;
                Player player = (Player)nearby;
                player.damage(4.0, (Entity)bossEntity);
                player.setFireTicks(60);
            }
            world.spawnParticle(Particle.FLAME, bossLoc, 50, 2.0, 2.0, 2.0);
            world.playSound(bossLoc, Sound.BLOCK_FIRE_AMBIENT, 0.5f, 1.0f);
        }, 100L, 100L);
    }

    private void applyFrostAttackAbility(LivingEntity bossEntity) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task -> {
            if (bossEntity == null || bossEntity.isDead()) {
                task.cancel();
                return;
            }
            World world = bossEntity.getWorld();
            Location bossLoc = bossEntity.getLocation();
            for (Entity nearby : bossEntity.getNearbyEntities(7.0, 7.0, 7.0)) {
                if (!(nearby instanceof Player)) continue;
                Player player = (Player)nearby;
                player.damage(3.0, (Entity)bossEntity);
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 60, 1));
            }
            world.spawnParticle(Particle.SNOWFLAKE, bossLoc, 50, 3.0, 3.0, 3.0);
            world.playSound(bossLoc, Sound.ENTITY_PLAYER_HURT_FREEZE, 1.0f, 1.0f);
        }, 200L, 200L);
    }

    private void applySlowAuraAbility(LivingEntity bossEntity) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task -> {
            if (bossEntity == null || bossEntity.isDead()) {
                task.cancel();
                return;
            }
            Location bossLoc = bossEntity.getLocation();
            for (Entity nearby : bossEntity.getNearbyEntities(6.0, 6.0, 6.0)) {
                if (!(nearby instanceof Player)) continue;
                Player player = (Player)nearby;
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 100, 1));
            }
            bossEntity.getWorld().spawnParticle(Particle.SNOWFLAKE, bossLoc, 30, 2.0, 2.0, 2.0);
        }, 100L, 100L);
    }

    private void applySpeedBoostAbility(LivingEntity bossEntity) {
        bossEntity.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1, false, true, true));
    }

    private void applyResistanceAbility(LivingEntity bossEntity) {
        bossEntity.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, Integer.MAX_VALUE, 1, false, true, true));
    }

    private void applyRegenerationAbility(LivingEntity bossEntity) {
        bossEntity.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, Integer.MAX_VALUE, 1, false, true, true));
    }
}

