/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.dungeon.features;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.lib.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;

public class FeatureGenerator {
    private final AIDungeon plugin;
    private final Logger logger;
    private final Map<String, String> featureAliases;

    public FeatureGenerator(AIDungeon plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.featureAliases = new HashMap<String, String>();
        this.initializeFeatureAliases();
    }

    private void initializeFeatureAliases() {
        this.featureAliases.put("spawner", "SPAWNER");
        this.featureAliases.put("mob_spawner", "SPAWNER");
        this.featureAliases.put("monster_spawner", "SPAWNER");
        this.featureAliases.put("chest", "CHEST");
        this.featureAliases.put("treasure_chest", "CHEST");
        this.featureAliases.put("loot_chest", "CHEST");
        this.featureAliases.put("pressure_plate", "PRESSURE_PLATE");
        this.featureAliases.put("pressure_plate_puzzle", "PRESSURE_PLATE");
        this.featureAliases.put("trap", "TRAP");
        this.featureAliases.put("trap_door", "TRAP");
        this.featureAliases.put("lever", "LEVER");
        this.featureAliases.put("button", "BUTTON");
        this.featureAliases.put("redstone", "REDSTONE");
        this.featureAliases.put("redstone_door", "REDSTONE_DOOR");
        this.featureAliases.put("door", "DOOR");
        this.featureAliases.put("torch", "TORCH");
        this.featureAliases.put("lantern", "LANTERN");
        this.featureAliases.put("light", "LIGHT");
        this.featureAliases.put("decoration", "DECORATION");
        this.featureAliases.put("skull", "SKULL");
        this.featureAliases.put("banner", "BANNER");
        this.featureAliases.put("painting", "PAINTING");
        this.featureAliases.put("vines", "VINES");
        this.featureAliases.put("cobweb", "COBWEB");
    }

    private String normalizeFeatureType(String featureType) {
        String lowerCase = featureType.toLowerCase();
        return this.featureAliases.getOrDefault(lowerCase, featureType.toUpperCase());
    }

    public void addFeature(World world, String featureType, int x, int y, int z, JsonObject featureData) {
        String normalizedType;
        switch (normalizedType = this.normalizeFeatureType(featureType)) {
            case "SPAWNER": {
                String entityType = featureData.has("entityType") ? featureData.get("entityType").getAsString() : "ZOMBIE";
                this.createSpawner(world, x, y, z, this.getEntityType(entityType));
                break;
            }
            case "CHEST": {
                String lootTable = featureData.has("lootTable") ? featureData.get("lootTable").getAsString() : "minecraft:chests/simple_dungeon";
                this.createChest(world, x, y, z, lootTable);
                break;
            }
            case "TRAP": {
                String trapType = featureData.has("trapType") ? featureData.get("trapType").getAsString() : "ARROW";
                this.createTrap(world, x, y, z, trapType);
                break;
            }
            case "PRESSURE_PLATE": {
                this.createPressurePlate(world, x, y, z);
                break;
            }
            case "LEVER": {
                this.createLever(world, x, y, z);
                break;
            }
            case "BUTTON": {
                this.createButton(world, x, y, z);
                break;
            }
            case "REDSTONE": 
            case "REDSTONE_DOOR": 
            case "DOOR": {
                this.createRedstoneMechanism(world, x, y, z, normalizedType);
                break;
            }
            case "DECORATION": {
                String decorationType = featureData.has("decorationType") ? featureData.get("decorationType").getAsString() : "TORCH";
                this.createDecoration(world, x, y, z, decorationType);
                break;
            }
            case "TORCH": {
                this.createDecoration(world, x, y, z, "TORCH");
                break;
            }
            case "LANTERN": {
                this.createDecoration(world, x, y, z, "LANTERN");
                break;
            }
            case "SKULL": {
                this.createDecoration(world, x, y, z, "SKULL");
                break;
            }
            case "COBWEB": {
                this.createDecoration(world, x, y, z, "COBWEB");
                break;
            }
            case "VINES": {
                this.createDecoration(world, x, y, z, "VINES");
                break;
            }
            case "LIGHT": {
                this.createLight(world, x, y, z);
                break;
            }
            default: {
                this.logger.warning("Unknown feature type: " + featureType);
                this.createDecoration(world, x, y, z, "TORCH");
            }
        }
    }

    private EntityType getEntityType(String entityTypeName) {
        try {
            return EntityType.valueOf((String)entityTypeName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            if (entityTypeName.equalsIgnoreCase("skeleton_king") || entityTypeName.equalsIgnoreCase("wither_skeleton_king")) {
                return EntityType.WITHER_SKELETON;
            }
            if (entityTypeName.equalsIgnoreCase("zombie_king") || entityTypeName.equalsIgnoreCase("zombie_lord")) {
                return EntityType.ZOMBIE;
            }
            if (entityTypeName.equalsIgnoreCase("spider_queen")) {
                return EntityType.SPIDER;
            }
            if (entityTypeName.contains("slime")) {
                return EntityType.SLIME;
            }
            if (entityTypeName.contains("creeper")) {
                return EntityType.CREEPER;
            }
            this.logger.warning("Invalid entity type: " + entityTypeName + ", using ZOMBIE");
            return EntityType.ZOMBIE;
        }
    }

    private void createSpawner(World world, int x, int y, int z, EntityType entityType) {
        Block block = world.getBlockAt(x, y, z);
        block.setType(Material.SPAWNER);
    }

    private void createChest(World world, int x, int y, int z, String lootTable) {
        Block block = world.getBlockAt(x, y, z);
        block.setType(Material.CHEST);
    }

    private void createTrap(World world, int x, int y, int z, String trapType) {
        Block block = world.getBlockAt(x, y, z);
        switch (trapType.toUpperCase()) {
            case "ARROW": {
                block.setType(Material.DISPENSER);
                break;
            }
            case "FALL": {
                block.setType(Material.STONE_PRESSURE_PLATE);
                break;
            }
            case "LAVA": {
                block.setType(Material.STONE_PRESSURE_PLATE);
                break;
            }
            default: {
                block.setType(Material.STONE_PRESSURE_PLATE);
            }
        }
    }

    private void createPressurePlate(World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        block.setType(Material.STONE_PRESSURE_PLATE);
    }

    private void createLever(World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        Block attached = null;
        for (BlockFace face : new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST}) {
            Block adjacentBlock = block.getRelative(face);
            if (!adjacentBlock.getType().isSolid()) continue;
            attached = adjacentBlock;
            break;
        }
        if (attached == null) {
            Block below = block.getRelative(BlockFace.DOWN);
            below.setType(Material.STONE);
            attached = below;
        }
        block.setType(Material.LEVER);
    }

    private void createButton(World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        block.setType(Material.STONE_BUTTON);
    }

    private void createRedstoneMechanism(World world, int x, int y, int z, String type) {
        Block block = world.getBlockAt(x, y, z);
        if (type.equals("REDSTONE_DOOR") || type.equals("DOOR")) {
            block.setType(Material.IRON_DOOR);
            Block pressurePlate = block.getRelative(BlockFace.SOUTH);
            pressurePlate.setType(Material.STONE_PRESSURE_PLATE);
        } else {
            block.setType(Material.REDSTONE_WIRE);
        }
    }

    private void createLight(World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        Material[] lightSources = new Material[]{Material.TORCH, Material.LANTERN, Material.GLOWSTONE, Material.SEA_LANTERN, Material.SHROOMLIGHT};
        Material lightMaterial = lightSources[(int)(Math.random() * (double)lightSources.length)];
        block.setType(lightMaterial);
    }

    private void createDecoration(World world, int x, int y, int z, String decorationType) {
        Block block = world.getBlockAt(x, y, z);
        switch (decorationType.toUpperCase()) {
            case "TORCH": {
                block.setType(Material.WALL_TORCH);
                break;
            }
            case "LANTERN": {
                block.setType(Material.LANTERN);
                break;
            }
            case "SKULL": {
                block.setType(Material.SKELETON_SKULL);
                break;
            }
            case "VINES": {
                block.setType(Material.VINE);
                break;
            }
            case "COBWEB": {
                block.setType(Material.COBWEB);
                break;
            }
            case "BANNER": {
                block.setType(Material.BLACK_BANNER);
                break;
            }
            case "BOOKSHELF": {
                block.setType(Material.BOOKSHELF);
                break;
            }
            case "CAULDRON": {
                block.setType(Material.CAULDRON);
                break;
            }
            case "BREWING_STAND": {
                block.setType(Material.BREWING_STAND);
                break;
            }
            default: {
                block.setType(Material.TORCH);
            }
        }
    }
}

