/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.dungeon.rooms;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.dungeon.blocks.BlockPaletteManager;
import com.ubivismedia.aidungeon.dungeon.features.FeatureGenerator;
import com.ubivismedia.aidungeon.lib.gson.JsonArray;
import com.ubivismedia.aidungeon.lib.gson.JsonElement;
import com.ubivismedia.aidungeon.lib.gson.JsonObject;
import com.ubivismedia.aidungeon.model.Dungeon;
import com.ubivismedia.aidungeon.model.Room;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.World;

public class RoomBuilder {
    private final AIDungeon plugin;
    private final BlockPaletteManager blockPaletteManager;
    private final FeatureGenerator featureGenerator;
    private final Random random = new Random();

    public RoomBuilder(AIDungeon plugin, BlockPaletteManager blockPaletteManager) {
        this.plugin = plugin;
        this.blockPaletteManager = blockPaletteManager;
        this.featureGenerator = new FeatureGenerator(plugin);
    }

    public CompletableFuture<List<Room>> buildDungeonFromDesign(Dungeon dungeon, World world, JsonObject design) {
        CompletableFuture<List<Room>> future = new CompletableFuture<List<Room>>();
        try {
            if (!design.has("rooms") || !design.get("rooms").isJsonArray()) {
                this.plugin.getLogger().warning("Dungeon design doesn't contain a valid rooms array.");
                List<Room> fallbackRooms = this.createSimpleDungeon(dungeon, world);
                future.complete(fallbackRooms);
                return future;
            }
            JsonArray roomsArray = design.getAsJsonArray("rooms");
            if (roomsArray.size() == 0) {
                this.plugin.getLogger().warning("Dungeon design contains empty rooms array.");
                List<Room> fallbackRooms = this.createSimpleDungeon(dungeon, world);
                future.complete(fallbackRooms);
                return future;
            }
            ArrayList<Room> rooms = new ArrayList<Room>();
            int entranceX = dungeon.getXCoord();
            int entranceY = dungeon.getYCoord();
            int entranceZ = dungeon.getZCoord();
            int maxRoomSize = this.plugin.getConfigManager().getConfig().getInt("generation.maxRoomSize", 20);
            int maxOffset = this.plugin.getConfigManager().getConfig().getInt("generation.maxRoomOffset", 50);
            for (JsonElement roomElement : roomsArray) {
                JsonObject roomJson = roomElement.getAsJsonObject();
                String roomType = this.getJsonStringWithDefault(roomJson, "roomType", "CORRIDOR");
                int width = this.clampValue(this.getJsonIntWithDefault(roomJson, "width", 7), 3, maxRoomSize);
                int height = this.clampValue(this.getJsonIntWithDefault(roomJson, "height", 4), 3, maxRoomSize);
                int length = this.clampValue(this.getJsonIntWithDefault(roomJson, "length", 7), 3, maxRoomSize);
                JsonObject relativePos = roomJson.has("relativePosition") && roomJson.get("relativePosition").isJsonObject() ? roomJson.getAsJsonObject("relativePosition") : this.createDefaultRelativePosition();
                int relX = this.clampValue(this.getJsonIntWithDefault(relativePos, "x", 0), -maxOffset, maxOffset);
                int relY = this.clampValue(this.getJsonIntWithDefault(relativePos, "y", 0), -maxOffset, maxOffset);
                int relZ = this.clampValue(this.getJsonIntWithDefault(relativePos, "z", 0), -maxOffset, maxOffset);
                Room room = new Room();
                room.setDungeonId(dungeon.getId());
                room.setRoomType(roomType);
                room.setWidth(width);
                room.setHeight(height);
                room.setLength(length);
                room.setXCoord(entranceX + relX);
                room.setYCoord(entranceY + relY);
                room.setZCoord(entranceZ + relZ);
                room.setExplorationStatus(Room.ExplorationStatus.UNEXPLORED);
                this.buildRoom(world, room, dungeon.getBiomeType(), dungeon.getTheme());
                if (roomJson.has("features") && roomJson.get("features").isJsonArray()) {
                    JsonArray featuresArray = roomJson.getAsJsonArray("features");
                    for (JsonElement featureElement : featuresArray) {
                        int featureZ;
                        int featureY;
                        if (!featureElement.isJsonObject()) continue;
                        JsonObject featureJson = featureElement.getAsJsonObject();
                        String featureType = this.getJsonStringWithDefault(featureJson, "type", "DECORATION");
                        int featureX = room.getXCoord() + this.getJsonIntWithDefault(featureJson, "x", width / 2);
                        if (!this.isInsideRoom(featureX, featureY = room.getYCoord() + this.getJsonIntWithDefault(featureJson, "y", 1), featureZ = room.getZCoord() + this.getJsonIntWithDefault(featureJson, "z", length / 2), room)) continue;
                        this.featureGenerator.addFeature(world, featureType, featureX, featureY, featureZ, featureJson);
                    }
                }
                rooms.add(room);
            }
            future.complete(rooms);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error building dungeon from design: ", e);
            List<Room> fallbackRooms = this.createSimpleDungeon(dungeon, world);
            future.complete(fallbackRooms);
        }
        return future;
    }

    public List<Room> createSimpleDungeon(Dungeon dungeon, World world) {
        ArrayList<Room> rooms = new ArrayList<Room>();
        try {
            int entranceX = dungeon.getXCoord();
            int entranceY = dungeon.getYCoord();
            int entranceZ = dungeon.getZCoord();
            Room entranceRoom = new Room();
            entranceRoom.setDungeonId(dungeon.getId());
            entranceRoom.setRoomType("ENTRANCE");
            entranceRoom.setWidth(7);
            entranceRoom.setHeight(4);
            entranceRoom.setLength(7);
            entranceRoom.setXCoord(entranceX - 3);
            entranceRoom.setYCoord(entranceY);
            entranceRoom.setZCoord(entranceZ - 3);
            entranceRoom.setExplorationStatus(Room.ExplorationStatus.UNEXPLORED);
            this.buildRoom(world, entranceRoom, dungeon.getBiomeType(), dungeon.getTheme());
            rooms.add(entranceRoom);
            Room corridor = new Room();
            corridor.setDungeonId(dungeon.getId());
            corridor.setRoomType("CORRIDOR");
            corridor.setWidth(3);
            corridor.setHeight(3);
            corridor.setLength(10);
            corridor.setXCoord(entranceX - 1);
            corridor.setYCoord(entranceY);
            corridor.setZCoord(entranceZ + 4);
            corridor.setExplorationStatus(Room.ExplorationStatus.UNEXPLORED);
            this.buildRoom(world, corridor, dungeon.getBiomeType(), dungeon.getTheme());
            rooms.add(corridor);
            Room treasureRoom = new Room();
            treasureRoom.setDungeonId(dungeon.getId());
            treasureRoom.setRoomType("TREASURE");
            treasureRoom.setWidth(5);
            treasureRoom.setHeight(4);
            treasureRoom.setLength(5);
            treasureRoom.setXCoord(entranceX - 2);
            treasureRoom.setYCoord(entranceY);
            treasureRoom.setZCoord(entranceZ + 14);
            treasureRoom.setExplorationStatus(Room.ExplorationStatus.UNEXPLORED);
            this.buildRoom(world, treasureRoom, dungeon.getBiomeType(), dungeon.getTheme());
            JsonObject chestData = new JsonObject();
            chestData.addProperty("lootTable", "minecraft:chests/simple_dungeon");
            this.featureGenerator.addFeature(world, "CHEST", treasureRoom.getXCoord() + 2, treasureRoom.getYCoord() + 1, treasureRoom.getZCoord() + 2, chestData);
            rooms.add(treasureRoom);
            Room bossRoom = new Room();
            bossRoom.setDungeonId(dungeon.getId());
            bossRoom.setRoomType("BOSS");
            bossRoom.setWidth(10);
            bossRoom.setHeight(5);
            bossRoom.setLength(10);
            bossRoom.setXCoord(entranceX - 5);
            bossRoom.setYCoord(entranceY - 3);
            bossRoom.setZCoord(entranceZ + 19);
            bossRoom.setExplorationStatus(Room.ExplorationStatus.UNEXPLORED);
            this.buildRoom(world, bossRoom, dungeon.getBiomeType(), dungeon.getTheme());
            rooms.add(bossRoom);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error creating simple dungeon: ", e);
        }
        return rooms;
    }

    private boolean isInsideRoom(int x, int y, int z, Room room) {
        return x >= room.getXCoord() && x < room.getXCoord() + room.getWidth() && y >= room.getYCoord() && y < room.getYCoord() + room.getHeight() && z >= room.getZCoord() && z < room.getZCoord() + room.getLength();
    }

    private JsonObject createDefaultRelativePosition() {
        JsonObject pos = new JsonObject();
        pos.addProperty("x", 0);
        pos.addProperty("y", 0);
        pos.addProperty("z", 0);
        return pos;
    }

    private void buildRoom(World world, Room room, String biomeType, String theme) {
        int z;
        int z2;
        int y;
        int x;
        int surfaceY;
        boolean isPyramid;
        List<Material> palette = this.blockPaletteManager.getBlockPalette(biomeType, theme);
        int startX = room.getXCoord();
        int startY = room.getYCoord();
        int startZ = room.getZCoord();
        int endX = startX + room.getWidth() - 1;
        int endY = startY + room.getHeight() - 1;
        int endZ = startZ + room.getLength() - 1;
        boolean isEntrance = room.getRoomType().equals("ENTRANCE");
        boolean bl = isPyramid = theme.toLowerCase().contains("pyramid") || theme.toLowerCase().contains("temple") && biomeType.toLowerCase().contains("desert");
        if (isEntrance && !isPyramid && endY < (surfaceY = world.getHighestBlockYAt(startX + room.getWidth() / 2, startZ + room.getLength() / 2)) - 3) {
            this.createEntranceShaft(world, startX + room.getWidth() / 2, endY, startZ + room.getLength() / 2, surfaceY, palette);
        }
        if (isEntrance && isPyramid) {
            this.buildPyramidStructure(world, startX, startY, startZ, room.getWidth(), room.getLength(), palette);
        }
        for (x = startX; x <= endX; ++x) {
            for (y = startY; y <= endY; ++y) {
                for (z2 = startZ; z2 <= endZ; ++z2) {
                    world.getBlockAt(x, y, z2).setType(Material.AIR);
                }
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (y = startY; y <= endY; ++y) {
                for (z2 = startZ; z2 <= endZ; ++z2) {
                    world.getBlockAt(x, y, z2).setType(Material.AIR);
                }
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (z = startZ; z <= endZ; ++z) {
                world.getBlockAt(x, startY, z).setType(this.randomBlock(palette));
                world.getBlockAt(x, endY, z).setType(this.randomBlock(palette));
            }
        }
        for (int y2 = startY + 1; y2 < endY; ++y2) {
            for (int x2 = startX; x2 <= endX; ++x2) {
                world.getBlockAt(x2, y2, startZ).setType(this.randomBlock(palette));
                world.getBlockAt(x2, y2, endZ).setType(this.randomBlock(palette));
            }
            for (z = startZ + 1; z < endZ; ++z) {
                world.getBlockAt(startX, y2, z).setType(this.randomBlock(palette));
                world.getBlockAt(endX, y2, z).setType(this.randomBlock(palette));
            }
        }
    }

    private Material randomBlock(List<Material> palette) {
        return palette.get(this.random.nextInt(palette.size()));
    }

    private int clampValue(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    private String getJsonStringWithDefault(JsonObject json, String key, String defaultValue) {
        if (json.has(key) && json.get(key).isJsonPrimitive() && json.get(key).getAsJsonPrimitive().isString()) {
            return json.get(key).getAsString();
        }
        return defaultValue;
    }

    private int getJsonIntWithDefault(JsonObject json, String key, int defaultValue) {
        if (json.has(key) && json.get(key).isJsonPrimitive() && json.get(key).getAsJsonPrimitive().isNumber()) {
            return json.get(key).getAsInt();
        }
        return defaultValue;
    }

    public CompletableFuture<List<Room>> buildFallbackDungeon(Dungeon dungeon, World world) {
        CompletableFuture<List<Room>> future = new CompletableFuture<List<Room>>();
        try {
            List<Room> rooms = this.createSimpleDungeon(dungeon, world);
            future.complete(rooms);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private void createEntranceShaft(World world, int x, int topY, int z, int surfaceY, List<Material> palette) {
        int shaftWidth = 3;
        for (int y = topY; y <= surfaceY; ++y) {
            for (int dx = -shaftWidth / 2; dx <= shaftWidth / 2; ++dx) {
                for (int dz = -shaftWidth / 2; dz <= shaftWidth / 2; ++dz) {
                    if (dx == 0 && dz == 0) {
                        world.getBlockAt(x + dx, y, z + dz).setType(Material.AIR);
                        continue;
                    }
                    if (Math.abs(dx) != shaftWidth / 2 && Math.abs(dz) != shaftWidth / 2) continue;
                    world.getBlockAt(x + dx, y, z + dz).setType(this.randomBlock(palette));
                }
            }
        }
        world.getBlockAt(x, surfaceY + 1, z).setType(Material.LANTERN);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx != 0 && dz != 0 || dx == 0 && dz == 0) continue;
                world.getBlockAt(x + dx, surfaceY, z + dz).setType(Material.MOSSY_COBBLESTONE);
            }
        }
    }

    private void buildPyramidStructure(World world, int startX, int startY, int startZ, int width, int length, List<Material> palette) {
        int centerX = startX + width / 2;
        int centerZ = startZ + length / 2;
        int baseWidth = Math.max(width + 20, 30);
        int baseLength = Math.max(length + 20, 30);
        int height = baseWidth / 2 + 2;
        for (int y = 0; y < height; ++y) {
            int levelWidth = baseWidth - y * 2;
            int levelLength = baseLength - y * 2;
            for (int dx = -levelWidth / 2; dx <= levelWidth / 2; ++dx) {
                for (int dz = -levelLength / 2; dz <= levelLength / 2; ++dz) {
                    int blockX = centerX + dx;
                    int blockZ = centerZ + dz;
                    int blockY = startY + y;
                    boolean isEdge = Math.abs(dx) == levelWidth / 2 || Math.abs(dz) == levelLength / 2;
                    boolean isInterior = this.isPointInBox(blockX, blockY, blockZ, startX, startY, startZ, startX + width, startY + height, startZ + length);
                    if (!isEdge && isInterior) continue;
                    Material blockMaterial = this.random.nextDouble() < 0.8 ? Material.SANDSTONE : (this.random.nextDouble() < 0.5 ? Material.CHISELED_SANDSTONE : Material.CUT_SANDSTONE);
                    world.getBlockAt(blockX, blockY, blockZ).setType(blockMaterial);
                }
            }
        }
    }

    private boolean isPointInBox(int x, int y, int z, int x1, int y1, int z1, int x2, int y2, int z2) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2 && z >= z1 && z <= z2;
    }
}

