/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.dungeon.theme;

import com.ubivismedia.aidungeon.AIDungeon;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ThemeSelector {
    private final AIDungeon plugin;
    private final Random random = new Random();
    private final Map<String, List<String>> biomeThemes = new HashMap<String, List<String>>();

    public ThemeSelector(AIDungeon plugin) {
        this.plugin = plugin;
        this.initializeBiomeThemes();
    }

    private void initializeBiomeThemes() {
        this.biomeThemes.put("DESERT", List.of("ancient_temple", "abandoned_mine", "forgotten_tomb"));
        this.biomeThemes.put("FOREST", List.of("ancient_temple", "haunted_mansion", "wizard_tower", "bandit_hideout"));
        this.biomeThemes.put("MOUNTAINS", List.of("abandoned_mine", "monster_den", "dwarven_halls"));
        this.biomeThemes.put("SWAMP", List.of("cursed_crypt", "wizard_tower", "forgotten_laboratory"));
        this.biomeThemes.put("SNOWY", List.of("frozen_temple", "ice_dungeon", "frost_giant_lair"));
        this.biomeThemes.put("JUNGLE", List.of("ancient_temple", "lost_city", "tribal_ruins"));
        this.biomeThemes.put("MUSHROOM", List.of("fungal_cavern", "alien_structure", "spore_colony"));
        this.biomeThemes.put("NETHER", List.of("demon_fortress", "infernal_bastion", "corrupted_shrine"));
        this.biomeThemes.put("END", List.of("void_stronghold", "alien_structure", "astral_temple"));
        this.biomeThemes.put("OCEAN", List.of("sunken_city", "atlantis_ruins", "kraken_lair"));
    }

    public String selectThemeForBiome(String biomeType) {
        List themeOptions;
        boolean useBiomeThemes = this.plugin.getConfigManager().getConfig().getBoolean("themes.useBiomeThemes", true);
        if (useBiomeThemes) {
            for (String biomPrefix : this.biomeThemes.keySet()) {
                if (!biomeType.contains(biomPrefix)) continue;
                List<String> themes = this.biomeThemes.get(biomPrefix);
                return this.randomChoice(themes);
            }
        }
        if ((themeOptions = this.plugin.getConfigManager().getConfig().getStringList("themes.options")) != null && !themeOptions.isEmpty()) {
            return (String)this.randomChoice(themeOptions);
        }
        return this.randomChoice(List.of("ancient_temple", "abandoned_mine", "haunted_mansion", "forgotten_laboratory", "cursed_crypt"));
    }

    private <T> T randomChoice(List<T> options) {
        return options.get(this.random.nextInt(options.size()));
    }
}

