/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.integration;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.model.Dungeon;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

public class CustomMobResolver {
    private final AIDungeon plugin;
    private final Map<String, CustomMobSpawner> mobSpawners = new HashMap<String, CustomMobSpawner>();

    public CustomMobResolver(AIDungeon plugin) {
        this.plugin = plugin;
        this.initializeSpawners();
    }

    private void initializeSpawners() {
        this.mobSpawners.put("MythicMobs", new MythicMobsSpawner());
        this.mobSpawners.put("CustomMobs", new CustomMobsSpawner());
        this.mobSpawners.put("ItemsAdder", new ItemsAdderSpawner());
        this.mobSpawners.put("EcoPets", new EcoPetsSpawner());
        this.mobSpawners.put("Citizens", new CitizensSpawner());
    }

    public LivingEntity resolveAndSpawnCustomMob(World world, Dungeon dungeon, Location spawnLocation) {
        boolean customMobsEnabled = this.plugin.getConfigManager().getConfig().getBoolean("custom_mobs.enabled", false);
        if (!customMobsEnabled) {
            return null;
        }
        List<CustomMobConfig> compatibleMobs = this.findCompatibleMobs(dungeon.getBiomeType(), dungeon.getTheme());
        if (compatibleMobs.isEmpty()) {
            compatibleMobs = this.getFallbackMobs();
        }
        List pluginPriority = this.plugin.getConfigManager().getConfig().getStringList("custom_mobs.plugin_priority");
        for (String preferredPlugin : pluginPriority) {
            for (CustomMobConfig mobConfig : compatibleMobs) {
                CustomMobSpawner spawner;
                if (!mobConfig.plugin.equalsIgnoreCase(preferredPlugin) || (spawner = this.mobSpawners.get(preferredPlugin)) == null || !spawner.isPluginAvailable()) continue;
                try {
                    LivingEntity spawnedMob = spawner.spawnMob(world, spawnLocation, mobConfig.id, mobConfig.name);
                    if (spawnedMob == null) continue;
                    return spawnedMob;
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Error spawning custom mob from " + preferredPlugin, e);
                }
            }
        }
        return null;
    }

    private List<CustomMobConfig> findCompatibleMobs(String biomeType, String theme) {
        ArrayList<CustomMobConfig> compatibleMobs = new ArrayList<CustomMobConfig>();
        ConfigurationSection biomeMobsSection = this.plugin.getConfigManager().getConfig().getConfigurationSection("custom_mobs.biome_mobs." + biomeType);
        if (biomeMobsSection == null) {
            return compatibleMobs;
        }
        for (String key : biomeMobsSection.getKeys(false)) {
            List compatibleThemes;
            ConfigurationSection mobSection = biomeMobsSection.getConfigurationSection(key);
            if (mobSection == null || !(compatibleThemes = mobSection.getStringList("themes")).contains(theme)) continue;
            CustomMobConfig mobConfig = new CustomMobConfig(mobSection.getString("name", "Unknown Mob"), mobSection.getString("plugin", "Unknown"), mobSection.getString("id", ""), mobSection.getDouble("weight", 1.0));
            compatibleMobs.add(mobConfig);
        }
        return compatibleMobs;
    }

    private List<CustomMobConfig> getFallbackMobs() {
        ArrayList<CustomMobConfig> fallbackMobs = new ArrayList<CustomMobConfig>();
        ConfigurationSection fallbackSection = this.plugin.getConfigManager().getConfig().getConfigurationSection("custom_mobs.fallback_mobs");
        if (fallbackSection == null) {
            return fallbackMobs;
        }
        for (String key : fallbackSection.getKeys(false)) {
            ConfigurationSection mobSection = fallbackSection.getConfigurationSection(key);
            if (mobSection == null) continue;
            CustomMobConfig mobConfig = new CustomMobConfig(mobSection.getString("name", "Dungeon Guardian"), mobSection.getString("plugin", "Unknown"), mobSection.getString("id", ""), mobSection.getDouble("weight", 1.0));
            fallbackMobs.add(mobConfig);
        }
        return fallbackMobs;
    }

    private static class MythicMobsSpawner
    implements CustomMobSpawner {
        private MythicMobsSpawner() {
        }

        @Override
        public boolean isPluginAvailable() {
            return Bukkit.getPluginManager().getPlugin("MythicMobs") != null;
        }

        @Override
        public LivingEntity spawnMob(World world, Location location, String id, String name) {
            try {
                Plugin mythicMobs = Bukkit.getPluginManager().getPlugin("MythicMobs");
                Class<?> apiClass = Class.forName("io.lumine.mythic.bukkit.MythicBukkit");
                Method getAPIMethod = apiClass.getMethod("inst", new Class[0]);
                Object mythicAPI = getAPIMethod.invoke(null, new Object[0]);
                Class<?> mobManagerClass = Class.forName("io.lumine.mythic.core.mobs.MobManager");
                Method spawnMobMethod = mobManagerClass.getMethod("spawnMob", String.class, Location.class);
                Object mythicMobManager = mythicAPI.getClass().getMethod("getMobManager", new Class[0]).invoke(mythicAPI, new Object[0]);
                Entity entity = (Entity)spawnMobMethod.invoke(mythicMobManager, id, location);
                return entity instanceof LivingEntity ? (LivingEntity)entity : null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class CustomMobsSpawner
    implements CustomMobSpawner {
        private CustomMobsSpawner() {
        }

        @Override
        public boolean isPluginAvailable() {
            return Bukkit.getPluginManager().getPlugin("CustomMobs") != null;
        }

        @Override
        public LivingEntity spawnMob(World world, Location location, String id, String name) {
            try {
                Plugin customMobsPlugin = Bukkit.getPluginManager().getPlugin("CustomMobs");
                Class<?> customMobsClass = Class.forName("de.hellfirepvp.custom.mobs.CustomMobs");
                Class<?> customMobManagerClass = Class.forName("de.hellfirepvp.custom.mobs.manager.MobManager");
                Method getInstanceMethod = customMobsClass.getMethod("getInstance", new Class[0]);
                Object customMobsInstance = getInstanceMethod.invoke(null, new Object[0]);
                Method getMobManagerMethod = customMobsClass.getMethod("getMobManager", new Class[0]);
                Object mobManager = getMobManagerMethod.invoke(customMobsInstance, new Object[0]);
                Method spawnCustomMobMethod = customMobManagerClass.getMethod("spawnCustomMob", String.class, Location.class);
                Entity entity = (Entity)spawnCustomMobMethod.invoke(mobManager, id, location);
                return entity instanceof LivingEntity ? (LivingEntity)entity : null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class ItemsAdderSpawner
    implements CustomMobSpawner {
        private ItemsAdderSpawner() {
        }

        @Override
        public boolean isPluginAvailable() {
            return Bukkit.getPluginManager().getPlugin("ItemsAdder") != null;
        }

        @Override
        public LivingEntity spawnMob(World world, Location location, String id, String name) {
            try {
                Plugin itemsAdderPlugin = Bukkit.getPluginManager().getPlugin("ItemsAdder");
                Class<?> customEntityClass = Class.forName("dev.lone.itemsadder.api.CustomEntity");
                Method spawnMethod = customEntityClass.getMethod("spawn", Location.class, String.class);
                Entity entity = (Entity)spawnMethod.invoke(null, location, id);
                return entity instanceof LivingEntity ? (LivingEntity)entity : null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class EcoPetsSpawner
    implements CustomMobSpawner {
        private EcoPetsSpawner() {
        }

        @Override
        public boolean isPluginAvailable() {
            return Bukkit.getPluginManager().getPlugin("EcoPets") != null;
        }

        @Override
        public LivingEntity spawnMob(World world, Location location, String id, String name) {
            try {
                Plugin ecoPetsPlugin = Bukkit.getPluginManager().getPlugin("EcoPets");
                Class<?> petManagerClass = Class.forName("com.willfp.ecopets.pets.PetManager");
                Class<?> petClass = Class.forName("com.willfp.ecopets.pets.Pet");
                Method getPetByIDMethod = petManagerClass.getMethod("getPetByID", String.class);
                Object pet = getPetByIDMethod.invoke(null, id);
                Method spawnMethod = petClass.getMethod("spawn", Location.class);
                Entity entity = (Entity)spawnMethod.invoke(pet, location);
                return entity instanceof LivingEntity ? (LivingEntity)entity : null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class CitizensSpawner
    implements CustomMobSpawner {
        private CitizensSpawner() {
        }

        @Override
        public boolean isPluginAvailable() {
            return Bukkit.getPluginManager().getPlugin("Citizens") != null;
        }

        @Override
        public LivingEntity spawnMob(World world, Location location, String id, String name) {
            try {
                Plugin citizensPlugin = Bukkit.getPluginManager().getPlugin("Citizens");
                Class<?> citizensClass = Class.forName("net.citizensnpcs.api.CitizensAPI");
                Class<?> npcRegistryClass = Class.forName("net.citizensnpcs.api.npc.NPCRegistry");
                Method getNPCRegistryMethod = citizensClass.getMethod("getNPCRegistry", new Class[0]);
                Object npcRegistry = getNPCRegistryMethod.invoke(null, new Object[0]);
                Method createNPCMethod = npcRegistryClass.getMethod("createNPC", EntityType.class, String.class);
                Object npc = createNPCMethod.invoke(npcRegistry, EntityType.ZOMBIE, name);
                Method spawnMethod = npcRegistryClass.getMethod("spawn", Location.class);
                Entity entity = (Entity)spawnMethod.invoke(npc, location);
                return entity instanceof LivingEntity ? (LivingEntity)entity : null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class CustomMobConfig {
        String name;
        String plugin;
        String id;
        double weight;

        CustomMobConfig(String name, String plugin, String id, double weight) {
            this.name = name;
            this.plugin = plugin;
            this.id = id;
            this.weight = weight;
        }
    }

    private static interface CustomMobSpawner {
        public boolean isPluginAvailable();

        public LivingEntity spawnMob(World var1, Location var2, String var3, String var4);
    }
}

