/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.integration;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.dungeon.DungeonManager;
import com.ubivismedia.aidungeon.model.Dungeon;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlaceholderAPIIntegration
extends PlaceholderExpansion {
    private final AIDungeon plugin;
    private final DungeonManager dungeonManager;
    private final Pattern indexedQuestPattern = Pattern.compile("quest_(\\d+)_(.+)");
    private final Pattern indexedDungeonPattern = Pattern.compile("dungeon_(\\d+)_(.+)");

    public PlaceholderAPIIntegration(AIDungeon plugin) {
        this.plugin = plugin;
        this.dungeonManager = plugin.getDungeonManager();
    }

    public String getIdentifier() {
        return "aidungeon";
    }

    public String getAuthor() {
        return "UbivisMedia";
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public static boolean isPluginEnabled(String pluginName) {
        return Bukkit.getPluginManager().isPluginEnabled(pluginName);
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String identifier) {
        Matcher dungeonMatcher;
        Player onlinePlayer;
        Dungeon nearestDungeon;
        if (player == null) {
            return "";
        }
        if (identifier.equals("total_dungeons")) {
            return String.valueOf(this.getTotalDungeons());
        }
        if (identifier.equals("player_completed_dungeons")) {
            return String.valueOf(this.getPlayerCompletedDungeons(player.getUniqueId()));
        }
        if (identifier.equals("player_active_quests")) {
            return String.valueOf(this.getPlayerActiveQuests(player.getUniqueId()));
        }
        if (identifier.equals("player_completed_quests")) {
            return String.valueOf(this.getPlayerCompletedQuests(player.getUniqueId()));
        }
        if (player.isOnline() && (nearestDungeon = this.findNearestDungeon(onlinePlayer = player.getPlayer())) != null) {
            switch (identifier) {
                case "nearest_dungeon_distance": {
                    return String.valueOf(Math.round(this.getDistanceToDungeon(onlinePlayer, nearestDungeon)));
                }
                case "nearest_dungeon_coords": {
                    return nearestDungeon.getXCoord() + "," + nearestDungeon.getYCoord() + "," + nearestDungeon.getZCoord();
                }
                case "nearest_dungeon_x": {
                    return String.valueOf(nearestDungeon.getXCoord());
                }
                case "nearest_dungeon_y": {
                    return String.valueOf(nearestDungeon.getYCoord());
                }
                case "nearest_dungeon_z": {
                    return String.valueOf(nearestDungeon.getZCoord());
                }
                case "nearest_dungeon_world": {
                    return nearestDungeon.getWorldName();
                }
                case "nearest_dungeon_biome": {
                    return nearestDungeon.getBiomeType();
                }
                case "nearest_dungeon_theme": {
                    return this.formatThemeName(nearestDungeon.getTheme());
                }
            }
        }
        if ((dungeonMatcher = this.indexedDungeonPattern.matcher(identifier)).matches()) {
            int index = Integer.parseInt(dungeonMatcher.group(1));
            String property = dungeonMatcher.group(2);
            return this.getDungeonInfoByIndex(index, property);
        }
        Matcher questMatcher = this.indexedQuestPattern.matcher(identifier);
        if (questMatcher.matches()) {
            int index = Integer.parseInt(questMatcher.group(1));
            String property = questMatcher.group(2);
            return this.getQuestInfoByIndex(player.getUniqueId(), index, property);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getTotalDungeons() {
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT COUNT(*) FROM dungeons");){
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error counting dungeons for placeholder", e);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getPlayerCompletedDungeons(UUID playerUuid) {
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT COUNT(*) FROM player_progress WHERE player_uuid = ? AND exploration_percent >= 100");){
            stmt.setString(1, playerUuid.toString());
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error counting completed dungeons for placeholder", e);
        }
        return 0;
    }

    private int getPlayerActiveQuests(UUID playerUuid) {
        return 0;
    }

    private int getPlayerCompletedQuests(UUID playerUuid) {
        return 0;
    }

    private Dungeon findNearestDungeon(Player player) {
        if (player == null) {
            return null;
        }
        Location playerLoc = player.getLocation();
        Dungeon nearestDungeon = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Dungeon dungeon : this.dungeonManager.getActiveDungeons().values()) {
            double distance;
            if (!dungeon.getWorldName().equals(playerLoc.getWorld().getName()) || !((distance = Math.sqrt(Math.pow((double)dungeon.getXCoord() - playerLoc.getX(), 2.0) + Math.pow((double)dungeon.getYCoord() - playerLoc.getY(), 2.0) + Math.pow((double)dungeon.getZCoord() - playerLoc.getZ(), 2.0))) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestDungeon = dungeon;
        }
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT id, world_name, biome_type, theme, x_coord, y_coord, z_coord, created_at, status, boss_defeated FROM dungeons WHERE world_name = ? AND status NOT IN ('COLLAPSED', 'COLLAPSING')");){
            stmt.setString(1, playerLoc.getWorld().getName());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt("id");
                if (this.dungeonManager.getDungeon(id) != null) continue;
                int x = rs.getInt("x_coord");
                int y = rs.getInt("y_coord");
                int z = rs.getInt("z_coord");
                double distance = Math.sqrt(Math.pow((double)x - playerLoc.getX(), 2.0) + Math.pow((double)y - playerLoc.getY(), 2.0) + Math.pow((double)z - playerLoc.getZ(), 2.0));
                if (!(distance < nearestDistance)) continue;
                Dungeon dungeon = new Dungeon();
                dungeon.setId(id);
                dungeon.setWorldName(rs.getString("world_name"));
                dungeon.setBiomeType(rs.getString("biome_type"));
                dungeon.setTheme(rs.getString("theme"));
                dungeon.setXCoord(x);
                dungeon.setYCoord(y);
                dungeon.setZCoord(z);
                dungeon.setCreatedAt(rs.getTimestamp("created_at").toLocalDateTime());
                dungeon.setStatus(Dungeon.Status.valueOf(rs.getString("status")));
                dungeon.setBossDefeated(rs.getBoolean("boss_defeated"));
                nearestDistance = distance;
                nearestDungeon = dungeon;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error finding nearest dungeon for placeholder", e);
        }
        return nearestDungeon;
    }

    private double getDistanceToDungeon(Player player, Dungeon dungeon) {
        if (player == null || dungeon == null) {
            return 0.0;
        }
        Location playerLoc = player.getLocation();
        return Math.sqrt(Math.pow((double)dungeon.getXCoord() - playerLoc.getX(), 2.0) + Math.pow((double)dungeon.getYCoord() - playerLoc.getY(), 2.0) + Math.pow((double)dungeon.getZCoord() - playerLoc.getZ(), 2.0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDungeonInfoByIndex(int index, String property) {
        if (index < 1) {
            return "";
        }
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT * FROM dungeons ORDER BY id LIMIT 1 OFFSET ?");){
            stmt.setInt(1, index - 1);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return "";
            switch (property) {
                case "world": {
                    String string = rs.getString("world_name");
                    return string;
                }
                case "biome": {
                    String string = rs.getString("biome_type");
                    return string;
                }
                case "x": {
                    String string = String.valueOf(rs.getInt("x_coord"));
                    return string;
                }
                case "y": {
                    String string = String.valueOf(rs.getInt("y_coord"));
                    return string;
                }
                case "z": {
                    String string = String.valueOf(rs.getInt("z_coord"));
                    return string;
                }
                case "coords": {
                    String string = rs.getInt("x_coord") + "," + rs.getInt("y_coord") + "," + rs.getInt("z_coord");
                    return string;
                }
                case "theme": {
                    String string = this.formatThemeName(rs.getString("theme"));
                    return string;
                }
                case "age": {
                    long createdTime = rs.getTimestamp("created_at").getTime();
                    long currentTime = System.currentTimeMillis();
                    int days = (int)((currentTime - createdTime) / 86400000L);
                    String string = String.valueOf(days);
                    return string;
                }
                case "discoverer": {
                    String string = "Unknown";
                    return string;
                }
            }
            String string = "";
            return string;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error getting dungeon info by index for placeholder", e);
        }
        return "";
    }

    private String getQuestInfoByIndex(UUID playerUuid, int index, String property) {
        return "Coming Soon";
    }

    private String formatThemeName(String theme) {
        if (theme == null || theme.isEmpty()) {
            return "Unknown";
        }
        String[] words = theme.split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return formatted.toString().trim();
    }
}

