/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.listeners;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.dungeon.DungeonManager;
import com.ubivismedia.aidungeon.model.Dungeon;
import com.ubivismedia.aidungeon.model.Room;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlayerEventListener
implements Listener {
    private final AIDungeon plugin;
    private final DungeonManager dungeonManager;

    public PlayerEventListener(AIDungeon plugin) {
        this.plugin = plugin;
        this.dungeonManager = plugin.getDungeonManager();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.dungeonManager == null || !this.dungeonManager.isInitialLoadComplete()) {
            return;
        }
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        try {
            Room room;
            Dungeon dungeon2;
            Player player = event.getPlayer();
            Location toLocation = event.getTo();
            if (this.plugin.getConfigManager().getConfig().getBoolean("debug.logExploration", false)) {
                for (Dungeon dungeon2 : this.dungeonManager.getActiveDungeons().values()) {
                    if (!dungeon2.getWorldName().equals(toLocation.getWorld().getName())) continue;
                    for (Room room2 : dungeon2.getRooms()) {
                        boolean isInRoom = room2.containsLocation(toLocation);
                        if (!isInRoom) continue;
                        this.plugin.getLogger().info("DEBUG: Player " + player.getName() + " is inside room " + room2.getId() + " of dungeon " + dungeon2.getId() + " (" + room2.getRoomType() + ") at " + toLocation.getBlockX() + "," + toLocation.getBlockY() + "," + toLocation.getBlockZ());
                        this.plugin.getLogger().info("DEBUG: Room boundaries - X: " + room2.getXCoord() + " to " + (room2.getXCoord() + room2.getWidth() - 1) + ", Y: " + room2.getYCoord() + " to " + (room2.getYCoord() + room2.getHeight() - 1) + ", Z: " + room2.getZCoord() + " to " + (room2.getZCoord() + room2.getLength() - 1));
                        this.plugin.getLogger().info("DEBUG: Room exploration status before: " + String.valueOf((Object)room2.getExplorationStatus()));
                    }
                }
            }
            if ((room = this.dungeonManager.getRoomAtLocation(toLocation)) != null && (dungeon2 = this.dungeonManager.getDungeon(room.getDungeonId())) != null) {
                this.dungeonManager.trackPlayerExploration(player, dungeon2, room);
                this.handleSpecialRoomTypes(player, dungeon2, room);
            }
            if (Math.random() < 0.01) {
                this.dungeonManager.scanAroundPlayer(player);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error handling player movement", e);
        }
    }

    private void handleSpecialRoomTypes(Player player, Dungeon dungeon, Room room) {
        switch (room.getRoomType()) {
            case "ENTRANCE": {
                if (room.getExplorationStatus() == Room.ExplorationStatus.EXPLORED) break;
                player.sendMessage("\u00a76[AIDungeon] \u00a7eYou have discovered a " + dungeon.getTheme().replace("_", " ") + "!");
                break;
            }
            case "TREASURE": {
                if (room.getExplorationStatus() == Room.ExplorationStatus.EXPLORED) break;
                player.sendMessage("\u00a76[AIDungeon] \u00a7eYou have found a treasure room!");
                break;
            }
            case "TRAP": {
                break;
            }
            case "BOSS": {
                if (room.getExplorationStatus() == Room.ExplorationStatus.EXPLORED) break;
                player.sendMessage("\u00a76[AIDungeon] \u00a7cYou have entered the boss room! Prepare for battle!");
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        NamespacedKey key;
        LivingEntity entity = event.getEntity();
        PersistentDataContainer container = entity.getPersistentDataContainer();
        if (container.has(key = new NamespacedKey((Plugin)this.plugin, "dungeon_boss"), PersistentDataType.INTEGER)) {
            int dungeonId = (Integer)container.get(key, PersistentDataType.INTEGER);
            Player killer = entity.getKiller();
            if (killer != null) {
                this.dungeonManager.registerBossDefeat(dungeonId, killer);
                this.rewardBossKillers(dungeonId, killer, entity.getLocation());
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        NamespacedKey key;
        Entity entity = event.getEntity();
        Entity damager = event.getDamager();
        if (!(entity instanceof LivingEntity) || !(damager instanceof Player)) {
            return;
        }
        PersistentDataContainer container = entity.getPersistentDataContainer();
        if (container.has(key = new NamespacedKey((Plugin)this.plugin, "dungeon_boss"), PersistentDataType.INTEGER)) {
            // empty if block
        }
    }

    private void rewardBossKillers(int dungeonId, Player killer, Location location) {
        Dungeon dungeon = this.dungeonManager.getDungeon(dungeonId);
        if (dungeon == null) {
            return;
        }
        int baseXp = 500;
        killer.giveExp(baseXp);
        killer.sendMessage("\u00a76[AIDungeon] \u00a7eYou have defeated the boss and earned " + baseXp + " XP!");
        for (Player player : location.getWorld().getPlayers()) {
            if (player.equals((Object)killer) || !(player.getLocation().distance(location) <= 30.0)) continue;
            int nearbyXp = baseXp / 2;
            player.giveExp(nearbyXp);
            player.sendMessage("\u00a76[AIDungeon] \u00a7eYou have helped defeat the boss and earned " + nearbyXp + " XP!");
        }
    }
}

