/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.model;

import com.ubivismedia.aidungeon.model.Room;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;

public class Dungeon {
    private int id;
    private String worldName;
    private String biomeType;
    private String theme;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private LocalDateTime createdAt;
    private Status status;
    private boolean bossDefeated;
    private List<Room> rooms = new ArrayList<Room>();

    public Location getEntranceLocation(World world) {
        return new Location(world, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
    }

    public Room getBossRoom() {
        for (Room room : this.rooms) {
            if (!room.getRoomType().equals("BOSS")) continue;
            return room;
        }
        return null;
    }

    public double getExplorationPercentage() {
        if (this.rooms.isEmpty()) {
            return 0.0;
        }
        long exploredRooms = this.rooms.stream().filter(room -> room.getExplorationStatus() == Room.ExplorationStatus.EXPLORED).count();
        return (double)exploredRooms / (double)this.rooms.size() * 100.0;
    }

    public boolean isFullyExplored() {
        return this.getExplorationPercentage() >= 100.0;
    }

    public int getId() {
        return this.id;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public String getBiomeType() {
        return this.biomeType;
    }

    public String getTheme() {
        return this.theme;
    }

    public int getXCoord() {
        return this.xCoord;
    }

    public int getYCoord() {
        return this.yCoord;
    }

    public int getZCoord() {
        return this.zCoord;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isBossDefeated() {
        return this.bossDefeated;
    }

    public List<Room> getRooms() {
        return this.rooms;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public void setBiomeType(String biomeType) {
        this.biomeType = biomeType;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public void setXCoord(int xCoord) {
        this.xCoord = xCoord;
    }

    public void setYCoord(int yCoord) {
        this.yCoord = yCoord;
    }

    public void setZCoord(int zCoord) {
        this.zCoord = zCoord;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setBossDefeated(boolean bossDefeated) {
        this.bossDefeated = bossDefeated;
    }

    public void setRooms(List<Room> rooms) {
        this.rooms = rooms;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dungeon)) {
            return false;
        }
        Dungeon other = (Dungeon)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getXCoord() != other.getXCoord()) {
            return false;
        }
        if (this.getYCoord() != other.getYCoord()) {
            return false;
        }
        if (this.getZCoord() != other.getZCoord()) {
            return false;
        }
        if (this.isBossDefeated() != other.isBossDefeated()) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
            return false;
        }
        String this$biomeType = this.getBiomeType();
        String other$biomeType = other.getBiomeType();
        if (this$biomeType == null ? other$biomeType != null : !this$biomeType.equals(other$biomeType)) {
            return false;
        }
        String this$theme = this.getTheme();
        String other$theme = other.getTheme();
        if (this$theme == null ? other$theme != null : !this$theme.equals(other$theme)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        List<Room> this$rooms = this.getRooms();
        List<Room> other$rooms = other.getRooms();
        return !(this$rooms == null ? other$rooms != null : !((Object)this$rooms).equals(other$rooms));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Dungeon;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getXCoord();
        result = result * 59 + this.getYCoord();
        result = result * 59 + this.getZCoord();
        result = result * 59 + (this.isBossDefeated() ? 79 : 97);
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        String $biomeType = this.getBiomeType();
        result = result * 59 + ($biomeType == null ? 43 : $biomeType.hashCode());
        String $theme = this.getTheme();
        result = result * 59 + ($theme == null ? 43 : $theme.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        List<Room> $rooms = this.getRooms();
        result = result * 59 + ($rooms == null ? 43 : ((Object)$rooms).hashCode());
        return result;
    }

    public String toString() {
        return "Dungeon(id=" + this.getId() + ", worldName=" + this.getWorldName() + ", biomeType=" + this.getBiomeType() + ", theme=" + this.getTheme() + ", xCoord=" + this.getXCoord() + ", yCoord=" + this.getYCoord() + ", zCoord=" + this.getZCoord() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", status=" + String.valueOf((Object)this.getStatus()) + ", bossDefeated=" + this.isBossDefeated() + ", rooms=" + String.valueOf(this.getRooms()) + ")";
    }

    public static enum Status {
        GENERATING,
        ACTIVE,
        EXPLORED,
        COLLAPSING,
        COLLAPSED;

    }
}

