/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.model;

import java.time.LocalDateTime;
import java.util.UUID;

public class PlayerProgress {
    private int id;
    private UUID playerUuid;
    private int dungeonId;
    private double explorationPercent;
    private LocalDateTime lastVisit;

    public boolean hasCompletedDungeon() {
        return this.explorationPercent >= 100.0;
    }

    public int getId() {
        return this.id;
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public int getDungeonId() {
        return this.dungeonId;
    }

    public double getExplorationPercent() {
        return this.explorationPercent;
    }

    public LocalDateTime getLastVisit() {
        return this.lastVisit;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setPlayerUuid(UUID playerUuid) {
        this.playerUuid = playerUuid;
    }

    public void setDungeonId(int dungeonId) {
        this.dungeonId = dungeonId;
    }

    public void setExplorationPercent(double explorationPercent) {
        this.explorationPercent = explorationPercent;
    }

    public void setLastVisit(LocalDateTime lastVisit) {
        this.lastVisit = lastVisit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerProgress)) {
            return false;
        }
        PlayerProgress other = (PlayerProgress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getDungeonId() != other.getDungeonId()) {
            return false;
        }
        if (Double.compare(this.getExplorationPercent(), other.getExplorationPercent()) != 0) {
            return false;
        }
        UUID this$playerUuid = this.getPlayerUuid();
        UUID other$playerUuid = other.getPlayerUuid();
        if (this$playerUuid == null ? other$playerUuid != null : !((Object)this$playerUuid).equals(other$playerUuid)) {
            return false;
        }
        LocalDateTime this$lastVisit = this.getLastVisit();
        LocalDateTime other$lastVisit = other.getLastVisit();
        return !(this$lastVisit == null ? other$lastVisit != null : !((Object)this$lastVisit).equals(other$lastVisit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerProgress;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getDungeonId();
        long $explorationPercent = Double.doubleToLongBits(this.getExplorationPercent());
        result = result * 59 + (int)($explorationPercent >>> 32 ^ $explorationPercent);
        UUID $playerUuid = this.getPlayerUuid();
        result = result * 59 + ($playerUuid == null ? 43 : ((Object)$playerUuid).hashCode());
        LocalDateTime $lastVisit = this.getLastVisit();
        result = result * 59 + ($lastVisit == null ? 43 : ((Object)$lastVisit).hashCode());
        return result;
    }

    public String toString() {
        return "PlayerProgress(id=" + this.getId() + ", playerUuid=" + String.valueOf(this.getPlayerUuid()) + ", dungeonId=" + this.getDungeonId() + ", explorationPercent=" + this.getExplorationPercent() + ", lastVisit=" + String.valueOf(this.getLastVisit()) + ")";
    }
}

