/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.model;

import org.bukkit.Location;
import org.bukkit.World;

public class Room {
    private int id;
    private int dungeonId;
    private String roomType;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private int width;
    private int height;
    private int length;
    private ExplorationStatus explorationStatus = ExplorationStatus.UNEXPLORED;

    public Location getCenterLocation(World world) {
        return new Location(world, (double)this.xCoord + (double)this.width / 2.0, (double)this.yCoord + (double)this.height / 2.0, (double)this.zCoord + (double)this.length / 2.0);
    }

    public boolean containsLocation(Location location) {
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        return x >= this.xCoord && x < this.xCoord + this.width && y >= this.yCoord && y < this.yCoord + this.height && z >= this.zCoord && z < this.zCoord + this.length;
    }

    public Location getMinLocation(World world) {
        return new Location(world, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
    }

    public Location getMaxLocation(World world) {
        return new Location(world, (double)(this.xCoord + this.width - 1), (double)(this.yCoord + this.height - 1), (double)(this.zCoord + this.length - 1));
    }

    public boolean isBossRoom() {
        return "BOSS".equals(this.roomType);
    }

    public boolean isEntranceRoom() {
        return "ENTRANCE".equals(this.roomType);
    }

    public boolean isTreasureRoom() {
        return "TREASURE".equals(this.roomType);
    }

    public int getId() {
        return this.id;
    }

    public int getDungeonId() {
        return this.dungeonId;
    }

    public String getRoomType() {
        return this.roomType;
    }

    public int getXCoord() {
        return this.xCoord;
    }

    public int getYCoord() {
        return this.yCoord;
    }

    public int getZCoord() {
        return this.zCoord;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLength() {
        return this.length;
    }

    public ExplorationStatus getExplorationStatus() {
        return this.explorationStatus;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setDungeonId(int dungeonId) {
        this.dungeonId = dungeonId;
    }

    public void setRoomType(String roomType) {
        this.roomType = roomType;
    }

    public void setXCoord(int xCoord) {
        this.xCoord = xCoord;
    }

    public void setYCoord(int yCoord) {
        this.yCoord = yCoord;
    }

    public void setZCoord(int zCoord) {
        this.zCoord = zCoord;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setExplorationStatus(ExplorationStatus explorationStatus) {
        this.explorationStatus = explorationStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Room)) {
            return false;
        }
        Room other = (Room)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getDungeonId() != other.getDungeonId()) {
            return false;
        }
        if (this.getXCoord() != other.getXCoord()) {
            return false;
        }
        if (this.getYCoord() != other.getYCoord()) {
            return false;
        }
        if (this.getZCoord() != other.getZCoord()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        String this$roomType = this.getRoomType();
        String other$roomType = other.getRoomType();
        if (this$roomType == null ? other$roomType != null : !this$roomType.equals(other$roomType)) {
            return false;
        }
        ExplorationStatus this$explorationStatus = this.getExplorationStatus();
        ExplorationStatus other$explorationStatus = other.getExplorationStatus();
        return !(this$explorationStatus == null ? other$explorationStatus != null : !((Object)((Object)this$explorationStatus)).equals((Object)other$explorationStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Room;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getDungeonId();
        result = result * 59 + this.getXCoord();
        result = result * 59 + this.getYCoord();
        result = result * 59 + this.getZCoord();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getLength();
        String $roomType = this.getRoomType();
        result = result * 59 + ($roomType == null ? 43 : $roomType.hashCode());
        ExplorationStatus $explorationStatus = this.getExplorationStatus();
        result = result * 59 + ($explorationStatus == null ? 43 : ((Object)((Object)$explorationStatus)).hashCode());
        return result;
    }

    public String toString() {
        return "Room(id=" + this.getId() + ", dungeonId=" + this.getDungeonId() + ", roomType=" + this.getRoomType() + ", xCoord=" + this.getXCoord() + ", yCoord=" + this.getYCoord() + ", zCoord=" + this.getZCoord() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", length=" + this.getLength() + ", explorationStatus=" + String.valueOf((Object)this.getExplorationStatus()) + ")";
    }

    public static enum ExplorationStatus {
        UNEXPLORED,
        PARTIALLY_EXPLORED,
        EXPLORED;

    }
}

