/*
 * Decompiled with CFR 0.152.
 */
package com.ubivismedia.aidungeon.scheduler;

import com.ubivismedia.aidungeon.AIDungeon;
import com.ubivismedia.aidungeon.config.ConfigManager;
import com.ubivismedia.aidungeon.dungeon.DungeonManager;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class DungeonScheduler {
    private final AIDungeon plugin;
    private final ConfigManager configManager;
    private final DungeonManager dungeonManager;
    private BukkitTask periodicCheckTask;
    private BukkitTask dailyScanTask;
    private BukkitTask pendingLocationsTask;

    public DungeonScheduler(AIDungeon plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.dungeonManager = plugin.getDungeonManager();
    }

    public void startSchedulers() {
        int periodicCheckMinutes = this.configManager.getPeriodicCheckMinutes();
        long periodicCheckTicks = (long)(periodicCheckMinutes * 60) * 20L;
        this.periodicCheckTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::runPeriodicCheck, 600L, periodicCheckTicks);
        this.scheduleDailyScan();
        this.pendingLocationsTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> this.dungeonManager.processPendingLocations(), 1200L, 12000L);
        this.plugin.getLogger().info("Dungeon schedulers have been started");
    }

    public void stopSchedulers() {
        if (this.periodicCheckTask != null) {
            this.periodicCheckTask.cancel();
        }
        if (this.dailyScanTask != null) {
            this.dailyScanTask.cancel();
        }
        if (this.pendingLocationsTask != null) {
            this.pendingLocationsTask.cancel();
        }
        this.plugin.getLogger().info("Dungeon schedulers have been stopped");
    }

    private void scheduleDailyScan() {
        long delayTicks;
        LocalDateTime nextRun;
        LocalTime scheduledTime = this.configManager.getDailyScanTime();
        LocalDateTime now = LocalDateTime.now();
        if (now.isAfter(nextRun = now.with(scheduledTime))) {
            nextRun = nextRun.plusDays(1L);
        }
        if ((delayTicks = (long)(nextRun.toLocalTime().toSecondOfDay() - now.toLocalTime().toSecondOfDay()) * 20L) < 0L) {
            delayTicks += 1728000L;
        }
        this.dailyScanTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::runDailyFullScan, delayTicks, 1728000L);
        this.plugin.getLogger().info("Daily scan scheduled for " + String.valueOf(scheduledTime) + " (in " + delayTicks / 20L / 60L + " minutes)");
    }

    private void runPeriodicCheck() {
        this.plugin.getLogger().info("Running periodic dungeon scan around players...");
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.dungeonManager.scanAroundPlayer(player);
        }
    }

    private void runDailyFullScan() {
        this.plugin.getLogger().info("Running daily full world scan...");
        ArrayList<World> worldsToScan = new ArrayList<World>();
        for (World world : Bukkit.getWorlds()) {
            if (world.getEnvironment() != World.Environment.NORMAL && !this.configManager.getConfig().getBoolean("generation.allowInOtherDimensions", false)) continue;
            worldsToScan.add(world);
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            int chunksPerBatch = 100;
            int ticksBetweenBatches = 20;
            for (World world : worldsToScan) {
                this.scanWorldOverTime(world, chunksPerBatch, ticksBetweenBatches);
            }
        });
    }

    private void scanWorldOverTime(World world, int chunksPerBatch, int ticksBetweenBatches) {
        this.plugin.getLogger().info("Scanning chunks in world: " + world.getName());
        for (Player player : world.getPlayers()) {
            int largeRadius = 500;
            int chunkX = player.getLocation().getBlockX() >> 4;
            int chunkZ = player.getLocation().getBlockZ() >> 4;
            int chunkRadius = largeRadius >> 4;
            for (int r = 0; r <= chunkRadius; ++r) {
                int radius = r;
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.scanChunkRing(world, chunkX, chunkZ, radius), (long)(r * ticksBetweenBatches));
            }
        }
    }

    private void scanChunkRing(World world, int centerX, int centerZ, int radius) {
        if (radius == 0) {
            this.processChunk(world, centerX, centerZ);
            return;
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (Math.abs(x) != radius && Math.abs(z) != radius) continue;
                this.processChunk(world, centerX + x, centerZ + z);
            }
        }
    }

    private void processChunk(World world, int chunkX, int chunkZ) {
        int blockX = chunkX << 4;
        int blockZ = chunkZ << 4;
        Random random = new Random();
        int x = blockX + random.nextInt(16);
        int z = blockZ + random.nextInt(16);
        if (!world.isChunkLoaded(chunkX, chunkZ)) {
            world.loadChunk(chunkX, chunkZ);
        }
        this.dungeonManager.scanAroundPlayer(null);
    }
}

