/*
 * Decompiled with CFR 0.152.
 */
package net.viotomix.itemframetweaks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.loader.api.FabricLoader;
import net.viotomix.itemframetweaks.ItemFrameTweaks;
import net.viotomix.itemframetweaks.config.Config;
import net.viotomix.itemframetweaks.config.ConfigData;
import org.apache.commons.io.IOUtils;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();
    private static Config CONFIG;

    public static Config getConfig() {
        return CONFIG;
    }

    public static boolean loadConfig() {
        CONFIG = null;
        try {
            ConfigData config;
            File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "item-frame-tweaks.json");
            if (configFile.exists()) {
                String json = IOUtils.toString((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8));
                config = (ConfigData)GSON.fromJson(json, ConfigData.class);
            } else {
                config = new ConfigData();
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8));
            writer.write(GSON.toJson((Object)config));
            writer.close();
            CONFIG = new Config(config);
            return true;
        }
        catch (IOException exception) {
            ItemFrameTweaks.LOGGER.error("An error occured while reading the config file!");
            exception.printStackTrace();
            CONFIG = new Config(new ConfigData());
            return false;
        }
    }
}

