/*
 * Decompiled with CFR 0.152.
 */
package org.lex.cws.Client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.ItemStack;
import org.lex.cws.Config;

public class TextureSwapButton
extends ImageButton {
    private final ResourceLocation defaultTexture;
    private final ResourceLocation hoverTexture;

    public TextureSwapButton(int x, int y, int width, int height, ResourceLocation defaultTexture, ResourceLocation hoverTexture, Button.OnPress onPress) {
        super(x, y, width, height, 0, 0, 0, defaultTexture, width, height, onPress);
        this.defaultTexture = defaultTexture;
        this.hoverTexture = hoverTexture;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.m_91087_();
        ResourceLocation texture = this.m_274382_() ? this.hoverTexture : this.defaultTexture;
        graphics.m_280163_(texture, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_7500_()) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof StonecutterMenu)) {
            return;
        }
        StonecutterMenu menu = (StonecutterMenu)abstractContainerMenu;
        ItemStack input = menu.m_38853_(0).m_7993_();
        if (input.m_41619_()) {
            return;
        }
        int totalCount = input.m_41613_();
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)input)) continue;
            totalCount += stack.m_41613_();
        }
        int stacks = (totalCount + input.m_41741_() - 1) / input.m_41741_();
        if (stacks < 4) {
            return;
        }
        int x = this.m_252754_() + 11;
        int y = this.m_252907_() + 5;
        switch (Config.costMode) {
            case XP: {
                int xpCost = Math.min(3, (int)Math.ceil(3.0 * (double)stacks / Math.max(1.0, (double)Config.xpStacksForMaxCost)));
                boolean hasXp = player.f_36078_ >= xpCost;
                String iconName = hasXp ? "textures/gui/levels/level_" + xpCost + ".png" : "textures/gui/levels/level_" + xpCost + "_disabled.png";
                ResourceLocation levelIcon = new ResourceLocation("cws", iconName);
                graphics.m_280163_(levelIcon, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                break;
            }
            case HUNGER: {
                boolean hasHunger;
                int hungerCost = Math.min(8, (int)Math.ceil(8.0 * (double)stacks / Math.max(1.0, (double)Config.hungerStacksForMaxCost)));
                boolean bl = hasHunger = player.m_36324_().m_38702_() >= hungerCost;
                if (!hasHunger) {
                    graphics.m_280246_(1.0f, 0.5f, 0.5f, 1.0f);
                }
                ResourceLocation hungerIcon = new ResourceLocation("cws", "textures/gui/levels/food_level_" + hungerCost + ".png");
                graphics.m_280163_(hungerIcon, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                if (hasHunger) break;
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
        }
    }
}

