/*
 * Decompiled with CFR 0.152.
 */
package org.lex.cws;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="cws", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.EnumValue<CostMode> COST_MODE = BUILDER.comment("How the Cut All button should consume resources: XP or HUNGER").defineEnum("costMode", (Enum)CostMode.XP);
    public static final ForgeConfigSpec.IntValue XP_STACKS_FOR_MAX_COST = BUILDER.comment("How many stacks are required to reach the maximum XP cost (3 levels) [Only Needed If Cost Mode Is XP]").defineInRange("xpStacksForMaxCost", 8, 1, 64);
    public static final ForgeConfigSpec.IntValue HUNGER_STACKS_FOR_MAX_COST = BUILDER.comment("How many stacks are required to reach the maximum hunger cost (8 hunger) [Only Needed If Cost Mode Is HUNGER]").defineInRange("hungerStacksForMaxCost", 8, 1, 64);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static CostMode costMode;
    public static int xpStacksForMaxCost;
    public static int hungerStacksForMaxCost;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.reload();
        }
    }

    public static void reload() {
        costMode = (CostMode)((Object)COST_MODE.get());
        xpStacksForMaxCost = (Integer)XP_STACKS_FOR_MAX_COST.get();
        hungerStacksForMaxCost = (Integer)HUNGER_STACKS_FOR_MAX_COST.get();
    }

    public static enum CostMode {
        XP,
        HUNGER,
        NONE;

    }
}

