/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;

public abstract class AbstractFireAlarmSignalBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final int ACTION_TICK_INTERVAL = 80;

    protected AbstractFireAlarmSignalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACE, (Comparable)AttachFace.WALL));
    }

    public static int getLightEmission(BlockState blockState) {
        return Boolean.TRUE.equals(blockState.getValue((Property)POWERED)) ? 15 : 2;
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return null;
    }

    protected void actionTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
    }

    protected void poweredSoundTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, boolean isPowered, RandomSource random) {
    }

    protected void checkConditionTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, boolean isPowered, RandomSource random) {
    }

    protected void playPoweredSound(ResourceLocation resourceLocation, ServerLevel serverLevel, BlockPos blockPos) {
        BuiltInRegistries.SOUND_EVENT.getOptional(resourceLocation).ifPresent(soundEvent -> serverLevel.playSound(null, blockPos, soundEvent, SoundSource.BLOCKS, 0.8f, 1.0f));
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, Orientation unused, boolean unused2) {
        if (!level.isClientSide) {
            boolean isPowered = (Boolean)blockState.getValue((Property)POWERED);
            if (isPowered != level.hasNeighborSignal(blockPos) && !isPowered) {
                level.setBlock(blockPos, (BlockState)blockState.cycle((Property)POWERED), 2);
            }
            level.scheduleTick(blockPos, (Block)this, 4);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateDefinition) {
        stateDefinition.add(new Property[]{FACE, FACING, POWERED});
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (Boolean.TRUE.equals(blockState.getValue((Property)POWERED)) && !serverLevel.hasNeighborSignal(blockPos)) {
            serverLevel.setBlock(blockPos, (BlockState)blockState.cycle((Property)POWERED), 2);
            return;
        }
        boolean isPowered = (Boolean)blockState.getValue((Property)POWERED);
        if (isPowered) {
            this.actionTick(blockState, serverLevel, blockPos, random);
        }
        this.poweredSoundTick(blockState, serverLevel, blockPos, isPowered, random);
        this.checkConditionTick(blockState, serverLevel, blockPos, isPowered, random);
        serverLevel.scheduleTick(blockPos, (Block)this, 80);
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        this.tick(blockState, serverLevel, blockPos, random);
    }
}

