/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.block;

import de.markusbordihn.fireextinguisher.block.FireExtinguisherSignPosition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ExitSign
extends Block {
    public static final String ID = "exit_sign";
    public static final String ID_LEFT = "exit_sign_left";
    public static final String ID_LEFT_DOWN = "exit_sign_left_down";
    public static final String ID_LEFT_UP = "exit_sign_left_up";
    public static final String ID_RIGHT = "exit_sign_right";
    public static final String ID_RIGHT_DOWN = "exit_sign_right_down";
    public static final String ID_RIGHT_UP = "exit_sign_right_up";
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<AttachFace> ATTACH_FACE = BlockStateProperties.ATTACH_FACE;
    protected static final VoxelShape CEILING_NORTH_SOUTH_AABB = Block.box((double)0.0, (double)4.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0);
    protected static final VoxelShape CEILING_EAST_WEST_AABB = Block.box((double)7.0, (double)4.0, (double)0.0, (double)9.0, (double)12.0, (double)16.0);
    protected static final VoxelShape FLOOR_NORTH_SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)8.0, (double)9.0);
    protected static final VoxelShape FLOOR_EAST_WEST_AABB = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH_AABB = Block.box((double)0.0, (double)4.0, (double)13.75, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST_AABB = Block.box((double)0.0, (double)4.0, (double)0.0, (double)2.25, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH_AABB = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)2.25);
    protected static final VoxelShape SHAPE_WEST_AABB = Block.box((double)13.75, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public ExitSign(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(blockState -> 15));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(ATTACH_FACE, (Comparable)AttachFace.FLOOR));
    }

    private static AttachFace getAttachFace(BlockPlaceContext context, Direction faceDirection) {
        AttachFace attachFace = AttachFace.FLOOR;
        if (faceDirection == Direction.DOWN) {
            attachFace = AttachFace.CEILING;
        } else if (faceDirection != Direction.UP) {
            double relativeClickLocation = context.getClickLocation().y % 1.0;
            attachFace = relativeClickLocation < 0.2 ? AttachFace.FLOOR : (relativeClickLocation > 0.8 ? AttachFace.CEILING : AttachFace.WALL);
        }
        return attachFace;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        AttachFace attachFace = (AttachFace)blockState.getValue(ATTACH_FACE);
        Direction facing = (Direction)blockState.getValue(FireExtinguisherSignPosition.FACING);
        if (attachFace == AttachFace.CEILING) {
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                return CEILING_NORTH_SOUTH_AABB;
            }
            if (facing == Direction.EAST || facing == Direction.WEST) {
                return CEILING_EAST_WEST_AABB;
            }
        }
        if (attachFace == AttachFace.FLOOR) {
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                return FLOOR_NORTH_SOUTH_AABB;
            }
            if (facing == Direction.EAST || facing == Direction.WEST) {
                return FLOOR_EAST_WEST_AABB;
            }
        }
        return switch (facing) {
            case Direction.EAST -> SHAPE_EAST_AABB;
            case Direction.SOUTH -> SHAPE_SOUTH_AABB;
            case Direction.WEST -> SHAPE_WEST_AABB;
            default -> SHAPE_NORTH_AABB;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockState) {
        blockState.add(new Property[]{ATTACH_FACE, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos().relative(direction.getOpposite()));
        Direction faceDirection = blockState.is((Block)this) && blockState.getValue(FACING) == direction ? direction.getOpposite() : direction;
        AttachFace attachFace = ExitSign.getAttachFace(context, faceDirection);
        return (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACH_FACE, (Comparable)attachFace)).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

