/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.block;

import de.markusbordihn.fireextinguisher.block.AbstractFireAlarmSignalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FireAlarmBellBlock
extends AbstractFireAlarmSignalBlock {
    public static final String ID = "fire_alarm_bell";
    protected static final ResourceLocation SOUND_EVENT = ResourceLocation.fromNamespaceAndPath((String)"fire_extinguisher", (String)"fire_alarm_bell");
    protected static final VoxelShape NORTH_AABB = Block.box((double)2.0, (double)2.0, (double)10.5, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)2.0, (double)2.0, (double)5.5, (double)14.0, (double)14.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)5.5);
    protected static final VoxelShape WEST_AABB = Block.box((double)10.5, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    protected static final VoxelShape UP_AABB = Block.box((double)2.0, (double)10.5, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape DOWN_AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.5, (double)14.0);

    public FireAlarmBellBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return switch ((AttachFace)blockState.getValue((Property)FACE)) {
            case AttachFace.FLOOR -> DOWN_AABB;
            case AttachFace.WALL -> {
                switch ((Direction)blockState.getValue((Property)FACING)) {
                    case EAST: {
                        yield EAST_AABB;
                    }
                    case WEST: {
                        yield WEST_AABB;
                    }
                    case SOUTH: {
                        yield SOUTH_AABB;
                    }
                }
                yield NORTH_AABB;
            }
            default -> UP_AABB;
        };
    }

    @Override
    public void poweredSoundTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, boolean isPowered, RandomSource random) {
        if (isPowered) {
            this.playPoweredSound(SOUND_EVENT, serverLevel, blockPos);
        }
    }
}

