/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.block;

import de.markusbordihn.fireextinguisher.block.AbstractFireAlarmSignalBlock;
import de.markusbordihn.fireextinguisher.config.FireExtinguisherConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FireAlarmSmokeDetectorBlock
extends AbstractFireAlarmSignalBlock {
    public static final String ID = "fire_alarm_smoke_detector";
    public static final BooleanProperty DISARMED = BlockStateProperties.DISARMED;
    protected static final ResourceLocation SOUND_EVENT = ResourceLocation.fromNamespaceAndPath((String)"fire_extinguisher", (String)"fire_alarm_smoke_detector");
    protected static final VoxelShape NORTH_AABB = Block.box((double)5.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)5.0, (double)5.0, (double)2.0, (double)11.0, (double)11.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)2.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)14.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    protected static final VoxelShape UP_AABB = Block.box((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape DOWN_AABB = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0);
    private static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");

    public FireAlarmSmokeDetectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISARMED, (Comparable)Boolean.valueOf(true)));
    }

    public static int getLightEmission(BlockState blockState) {
        if (Boolean.TRUE.equals(blockState.getValue((Property)POWERED))) {
            return 12;
        }
        if (!Boolean.TRUE.equals(blockState.getValue((Property)DISARMED))) {
            return 6;
        }
        return 2;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return switch ((AttachFace)blockState.getValue((Property)FACE)) {
            case AttachFace.FLOOR -> DOWN_AABB;
            case AttachFace.WALL -> {
                switch ((Direction)blockState.getValue((Property)FACING)) {
                    case EAST: {
                        yield EAST_AABB;
                    }
                    case WEST: {
                        yield WEST_AABB;
                    }
                    case SOUTH: {
                        yield SOUTH_AABB;
                    }
                }
                yield NORTH_AABB;
            }
            default -> UP_AABB;
        };
    }

    private void updateNeighbours(BlockState blockState, Level level, BlockPos blockPos) {
        level.updateNeighborsAt(blockPos, (Block)this);
        level.updateNeighborsAt(blockPos.relative(FireAlarmSmokeDetectorBlock.getConnectedDirection((BlockState)blockState).getOpposite()), (Block)this);
    }

    @Override
    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, Orientation unused, boolean unused2) {
    }

    @Override
    protected void checkConditionTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, boolean isPowered, RandomSource random) {
        Iterable blockPositions = BlockPos.withinManhattan((BlockPos)blockPos.above(), (int)FireExtinguisherConfig.smokeDetectorRadiusX, (int)FireExtinguisherConfig.smokeDetectorRadiusY, (int)FireExtinguisherConfig.smokeDetectorRadiusZ);
        boolean detectedFire = false;
        for (BlockPos blockBlockPosition : blockPositions) {
            BlockState blockBlockState = serverLevel.getBlockState(blockBlockPosition);
            if (!blockBlockState.is(Blocks.FIRE) && (!blockBlockState.is(Blocks.CAMPFIRE) || !(blockBlockState.getBlock() instanceof CampfireBlock) || !CampfireBlock.isLitCampfire((BlockState)blockState))) continue;
            detectedFire = true;
            break;
        }
        if (Boolean.TRUE.equals(blockState.getValue((Property)DISARMED))) {
            serverLevel.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)DISARMED, (Comparable)Boolean.valueOf(false)));
            log.debug("[Smoke Detector] At {} is armed and ready.", (Object)blockPos);
        }
        if (Boolean.TRUE.equals(blockState.getValue((Property)POWERED)) != detectedFire) {
            log.debug("[Smoke Detector] Fire detected at {} with state {}", (Object)blockPos, (Object)blockState);
            BlockState newBlockState = (BlockState)((BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(detectedFire))).setValue((Property)DISARMED, (Comparable)Boolean.valueOf(false));
            serverLevel.setBlockAndUpdate(blockPos, newBlockState);
            this.updateNeighbours(newBlockState, (Level)serverLevel, blockPos);
        }
    }

    public void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel level, BlockPos blockPos, boolean removed) {
        if (!removed && !blockState.is(blockState.getBlock())) {
            if (Boolean.TRUE.equals(blockState.getValue((Property)POWERED))) {
                this.updateNeighbours(blockState, (Level)level, blockPos);
            }
            super.affectNeighborsAfterRemoval(blockState, level, blockPos, removed);
        }
        if (removed && !level.isClientSide()) {
            log.debug("[Smoke Detector] At {} is removed.", (Object)blockPos);
        }
    }

    public boolean isSignalSource(BlockState blockState) {
        return true;
    }

    public int getSignal(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        return Boolean.TRUE.equals((Boolean)blockState.getValue((Property)POWERED) != false && (Boolean)blockState.getValue((Property)DISARMED) == false) ? 15 : 0;
    }

    public int getDirectSignal(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        return Boolean.TRUE.equals((Boolean)blockState.getValue((Property)POWERED) != false && (Boolean)blockState.getValue((Property)DISARMED) == false) && FireAlarmSmokeDetectorBlock.getConnectedDirection((BlockState)blockState) == direction ? 15 : 0;
    }

    @Override
    public void poweredSoundTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, boolean isPowered, RandomSource random) {
        if (Boolean.TRUE.equals(blockState.getValue((Property)POWERED))) {
            this.playPoweredSound(SOUND_EVENT, serverLevel, blockPos);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateDefinition) {
        super.createBlockStateDefinition(stateDefinition);
        stateDefinition.add(new Property[]{DISARMED});
    }
}

