/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FireAlarmSwitchBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final String ID = "fire_alarm_switch";
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    protected static final VoxelShape NORTH_AABB = Block.box((double)4.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)12.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)4.0, (double)3.0, (double)0.0, (double)12.0, (double)13.0, (double)3.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)13.0, (double)3.0, (double)4.0, (double)16.0, (double)13.0, (double)12.0);
    protected static final VoxelShape UP_AABB_Z = Block.box((double)4.0, (double)13.0, (double)3.0, (double)12.0, (double)16.0, (double)13.0);
    protected static final VoxelShape UP_AABB_X = Block.box((double)3.0, (double)13.0, (double)4.0, (double)13.0, (double)16.0, (double)12.0);
    protected static final VoxelShape DOWN_AABB_Z = Block.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)3.0, (double)13.0);
    protected static final VoxelShape DOWN_AABB_X = Block.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)3.0, (double)12.0);

    public FireAlarmSwitchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACE, (Comparable)AttachFace.WALL));
    }

    private static void makeParticle(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos, float particleTicks) {
        Direction facingBlockState = ((Direction)blockState.getValue((Property)FACING)).getOpposite();
        Direction connectedBlockState = FireAlarmSwitchBlock.getConnectedDirection((BlockState)blockState).getOpposite();
        double posX = (double)blockPos.getX() + 0.5 + 0.1 * (double)facingBlockState.getStepX() + 0.2 * (double)connectedBlockState.getStepX();
        double posY = (double)blockPos.getY() + 0.5 + 0.1 * (double)facingBlockState.getStepY() + 0.2 * (double)connectedBlockState.getStepY();
        double posZ = (double)blockPos.getZ() + 0.5 + 0.1 * (double)facingBlockState.getStepZ() + 0.2 * (double)connectedBlockState.getStepZ();
        levelAccessor.addParticle((ParticleOptions)new DustParticleOptions(0xFF0000, particleTicks), posX, posY, posZ, 0.0, 0.0, 0.0);
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return null;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return switch ((AttachFace)blockState.getValue((Property)FACE)) {
            case AttachFace.FLOOR -> {
                switch (((Direction)blockState.getValue((Property)FACING)).getAxis()) {
                    case X: {
                        yield DOWN_AABB_X;
                    }
                }
                yield DOWN_AABB_Z;
            }
            case AttachFace.WALL -> {
                switch ((Direction)blockState.getValue((Property)FACING)) {
                    case EAST: {
                        yield EAST_AABB;
                    }
                    case WEST: {
                        yield WEST_AABB;
                    }
                    case SOUTH: {
                        yield SOUTH_AABB;
                    }
                }
                yield NORTH_AABB;
            }
            default -> {
                switch (((Direction)blockState.getValue((Property)FACING)).getAxis()) {
                    case X: {
                        yield UP_AABB_X;
                    }
                }
                yield UP_AABB_Z;
            }
        };
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        float poweredValue;
        if (level.isClientSide) {
            BlockState powerBlockState = (BlockState)blockState.cycle((Property)POWERED);
            if (Boolean.TRUE.equals(powerBlockState.getValue((Property)POWERED))) {
                FireAlarmSwitchBlock.makeParticle(powerBlockState, (LevelAccessor)level, blockPos, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        BlockState powerBlockState = this.pull(blockState, level, blockPos);
        float f = poweredValue = Boolean.TRUE.equals(powerBlockState.getValue((Property)POWERED)) ? 0.6f : 0.5f;
        if (Boolean.TRUE.equals(powerBlockState.getValue((Property)POWERED))) {
            level.playSound(null, blockPos, SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 0.3f, 0.6f);
        }
        level.playSound(null, blockPos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, poweredValue);
        level.gameEvent((Entity)player, (Holder)(Boolean.TRUE.equals(powerBlockState.getValue((Property)POWERED)) ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), blockPos);
        return InteractionResult.CONSUME;
    }

    public BlockState pull(BlockState blockState, Level level, BlockPos blockPos) {
        blockState = (BlockState)blockState.cycle((Property)POWERED);
        level.setBlock(blockPos, blockState, 3);
        this.updateNeighbours(blockState, level, blockPos);
        return blockState;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource random) {
        if (Boolean.TRUE.equals(blockState.getValue((Property)POWERED)) && random.nextFloat() < 0.25f) {
            FireAlarmSwitchBlock.makeParticle(blockState, (LevelAccessor)level, blockPos, 0.5f);
        }
    }

    public void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel level, BlockPos blockPos, boolean removed) {
        if (!removed && !blockState.is(blockState.getBlock())) {
            if (Boolean.TRUE.equals(blockState.getValue((Property)POWERED))) {
                this.updateNeighbours(blockState, (Level)level, blockPos);
            }
            super.affectNeighborsAfterRemoval(blockState, level, blockPos, removed);
        }
    }

    public int getSignal(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        return Boolean.TRUE.equals(blockState.getValue((Property)POWERED)) ? 15 : 0;
    }

    public int getDirectSignal(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        return Boolean.TRUE.equals(blockState.getValue((Property)POWERED)) && FireAlarmSwitchBlock.getConnectedDirection((BlockState)blockState) == direction ? 15 : 0;
    }

    public boolean isSignalSource(BlockState blockState) {
        return true;
    }

    private void updateNeighbours(BlockState blockState, Level level, BlockPos blockPos) {
        level.updateNeighborsAt(blockPos, (Block)this);
        level.updateNeighborsAt(blockPos.relative(FireAlarmSwitchBlock.getConnectedDirection((BlockState)blockState).getOpposite()), (Block)this);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateDefinition) {
        stateDefinition.add(new Property[]{FACE, FACING, POWERED});
    }
}

