/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FireExtinguisherSign
extends Block {
    public static final String ID = "fire_extinguisher_sign";
    public static final String ID_LEFT = "fire_extinguisher_sign_left";
    public static final String ID_RIGHT = "fire_extinguisher_sign_right";
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    protected static final VoxelShape SHAPE_NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)14.75, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.25, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.25);
    protected static final VoxelShape SHAPE_WEST_AABB = Block.box((double)14.75, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public FireExtinguisherSign(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(blockState -> 10));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction facing = (Direction)blockState.getValue(FACING);
        return switch (facing) {
            case Direction.EAST -> SHAPE_EAST_AABB;
            case Direction.SOUTH -> SHAPE_SOUTH_AABB;
            case Direction.WEST -> SHAPE_WEST_AABB;
            default -> SHAPE_NORTH_AABB;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockState) {
        blockState.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

