/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.block;

import de.markusbordihn.fireextinguisher.block.AbstractFireAlarmSignalBlock;
import de.markusbordihn.fireextinguisher.config.FireExtinguisherConfig;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FireSprinklerBlock
extends AbstractFireAlarmSignalBlock {
    public static final String ID = "fire_sprinkler";
    protected static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");
    protected static final VoxelShape UP_AABB = Block.box((double)7.0, (double)13.325, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final Random random = new Random();

    public FireSprinklerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static void stopFire(ServerLevel serverLevel, BlockPos targetBlockPos) {
        Iterable blockPositions = BlockPos.withinManhattan((BlockPos)targetBlockPos.below(), (int)FireExtinguisherConfig.fireSprinklerRadiusX, (int)FireExtinguisherConfig.fireSprinklerRadiusY, (int)FireExtinguisherConfig.fireSprinklerRadiusZ);
        for (BlockPos blockPos : blockPositions) {
            BlockState blockState = serverLevel.getBlockState(blockPos);
            if (blockState.is(Blocks.FIRE)) {
                log.debug("[Fire Sprinkler] Remove fire block at {}", (Object)blockPos);
                serverLevel.removeBlock(blockPos, false);
                serverLevel.playSound(null, blockPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                continue;
            }
            if (!blockState.is(Blocks.CAMPFIRE) || !(blockState.getBlock() instanceof CampfireBlock) || !CampfireBlock.isLitCampfire((BlockState)blockState)) continue;
            log.debug("[Fire Sprinkler] Extinguish campfire block at {}", (Object)blockPos);
            serverLevel.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        if (context.getClickedFace() != Direction.DOWN) {
            return null;
        }
        if (blockPos.getY() < level.getMaxY() - 1 && !level.getBlockState(blockPos.above()).isAir()) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACE, (Comparable)AttachFace.CEILING)).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
        }
        return null;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return UP_AABB;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource random) {
        boolean isPowered = (Boolean)blockState.getValue((Property)POWERED);
        if (isPowered) {
            double x = blockPos.getX();
            double y = blockPos.getY();
            double z = blockPos.getZ();
            for (int i = 0; i < 8; ++i) {
                if ((y -= FireSprinklerBlock.random.nextDouble(1.0)) == (double)(blockPos.getY() - 2)) {
                    for (j = 0; j < 4; ++j) {
                        level.addParticle((ParticleOptions)ParticleTypes.CLOUD, x + 0.5, y + 0.5, z + 0.5, FireSprinklerBlock.random.nextDouble(-0.2, 0.2), 0.0, 0.0);
                        level.addParticle((ParticleOptions)ParticleTypes.CLOUD, x + 0.5, y + 0.5, z + 0.5, 0.0, 0.0, FireSprinklerBlock.random.nextDouble(-0.2, 0.2));
                        level.addParticle((ParticleOptions)ParticleTypes.CLOUD, x + 0.5, y + 0.5, z + 0.5, FireSprinklerBlock.random.nextDouble(-0.2, 0.2), 0.0, FireSprinklerBlock.random.nextDouble(-0.2, 0.1));
                    }
                } else if (y <= (double)(blockPos.getY() - 3)) {
                    for (j = 0; j < 8; ++j) {
                        level.addParticle((ParticleOptions)ParticleTypes.CLOUD, x + 0.5, y + 0.5, z + 0.5, FireSprinklerBlock.random.nextDouble(-0.5, 0.5), 0.0, 0.0);
                        level.addParticle((ParticleOptions)ParticleTypes.CLOUD, x + 0.5, y + 0.5, z + 0.5, 0.0, 0.0, FireSprinklerBlock.random.nextDouble(-0.5, 0.5));
                        level.addParticle((ParticleOptions)ParticleTypes.CLOUD, x + 0.5, y + 0.5, z + 0.5, FireSprinklerBlock.random.nextDouble(-0.5, 0.5), 0.0, FireSprinklerBlock.random.nextDouble(-0.5, 0.5));
                    }
                }
                level.addParticle((ParticleOptions)ParticleTypes.CLOUD, x + 0.5, y + 0.5, z + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void actionTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        FireSprinklerBlock.stopFire(serverLevel, blockPos);
    }
}

