/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.blockitem;

import de.markusbordihn.fireextinguisher.block.FireExtinguisherBlock;
import de.markusbordihn.fireextinguisher.config.FireExtinguisherConfig;
import de.markusbordihn.fireextinguisher.utils.ToolTips;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FireExtinguisherBlockItem
extends BlockItem {
    public static final String ID = "fire_extinguisher";
    public static final String ID_COPPER = "fire_extinguisher_copper";
    private static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");
    private static final double Y_SHIFT = 1.6;
    private static final int PARTICLE_FRAMES = 8;
    private static final int ATTACK_EFFECT_DURATION = 200;

    public FireExtinguisherBlockItem(Block block, String id) {
        this(block, new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)id))).stacksTo(1).durability(128).fireResistant());
    }

    public FireExtinguisherBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static void stopFireAnimation(Player player, Level level, BlockPos blockPos) {
        double x = player.getX();
        double y = player.getY();
        double z = player.getZ();
        double d = y = y >= 0.0 ? y + 1.6 : y - 1.6;
        if (blockPos != null) {
            double targetX = (double)blockPos.getX() + 0.5;
            double targetY = (double)blockPos.getY() + 0.5;
            double targetZ = (double)blockPos.getZ() + 0.5;
            double targetXRatio = (targetX - x) / 8.0;
            double targetYRatio = (targetY - y) / 8.0;
            double targetZRatio = (targetZ - z) / 8.0;
            for (int i = 0; i < 8; ++i) {
                x += targetXRatio;
                y += targetYRatio;
                z += targetZRatio;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 1, 0.2, 0.5, 0.2, 0.01);
                    continue;
                }
                level.addParticle((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void stopFire(ServerLevel serverLevel, Player player, InteractionHand hand, BlockPos targetBlockPos, ItemStack itemStack) {
        Iterable blockPositions = BlockPos.withinManhattan((BlockPos)targetBlockPos.above(), (int)FireExtinguisherConfig.fireExtinguisherRadiusX, (int)FireExtinguisherConfig.fireExtinguisherRadiusY, (int)FireExtinguisherConfig.fireExtinguisherRadiusZ);
        HashSet<BlockPos> affectedPositions = new HashSet<BlockPos>();
        for (BlockPos blockPos : blockPositions) {
            BlockState blockState = serverLevel.getBlockState(blockPos);
            if (blockState.is(Blocks.FIRE)) {
                log.debug("[FireExtinguisher] Removing Fire Block {} at {}", (Object)blockState, (Object)blockPos);
                serverLevel.removeBlock(blockPos, false);
                serverLevel.sendBlockUpdated(blockPos, Blocks.AIR.defaultBlockState(), blockState, 3);
                affectedPositions.add(blockPos);
                continue;
            }
            if (!blockState.is(Blocks.CAMPFIRE) || !(blockState.getBlock() instanceof CampfireBlock) || !CampfireBlock.isLitCampfire((BlockState)blockState)) continue;
            log.debug("[FireExtinguisher] Extinguish Campfire Block {} at {}", (Object)blockState, (Object)blockPos);
            BlockState newBlockState = (BlockState)blockState.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
            serverLevel.setBlock(blockPos, newBlockState, 3);
            serverLevel.sendBlockUpdated(blockPos, newBlockState, blockState, 3);
            affectedPositions.add(blockPos);
        }
        if (!affectedPositions.isEmpty()) {
            FireExtinguisherBlockItem.hurtAndBreak((Level)serverLevel, itemStack, player, hand);
            serverLevel.playSound(null, targetBlockPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void stopFireSound(Level level, Player player) {
        if (level.isClientSide) {
            player.playSound(SoundEvents.FIRE_EXTINGUISH, 1.0f, 1.0f);
        }
    }

    public static void hurtAndBreak(Level level, ItemStack itemStack, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            itemStack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
    }

    public boolean canDestroyBlock(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, LivingEntity livingEntity) {
        boolean bl;
        if (blockState.getBlock() instanceof FireExtinguisherBlock) {
            return true;
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            bl = player.isShiftKeyDown();
        } else {
            bl = false;
        }
        return bl;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        InteractionHand interactionHand = context.getHand();
        if (player != null && player.isShiftKeyDown()) {
            return super.useOn(context);
        }
        FireExtinguisherBlockItem.stopFireAnimation(player, level, blockPos);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            FireExtinguisherBlockItem.stopFire(serverLevel, player, interactionHand, blockPos, itemStack);
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.isOnFire()) {
            if (player.getRemainingFireTicks() > 2) {
                player.setRemainingFireTicks(2);
            }
            FireExtinguisherBlockItem.stopFireAnimation(player, level, player.blockPosition());
            FireExtinguisherBlockItem.stopFireSound(level, player);
            FireExtinguisherBlockItem.hurtAndBreak(level, itemStack, player, hand);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        BlockPos blockPos = livingEntity.getOnPos();
        Level level = player.level();
        FireExtinguisherBlockItem.stopFireAnimation(player, player.level(), blockPos.above());
        livingEntity.setTicksFrozen(1000);
        if (livingEntity.isOnFire()) {
            livingEntity.setRemainingFireTicks(2);
        }
        if (!level.isClientSide) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 200, 10));
            livingEntity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 200, 10));
            if (!(livingEntity instanceof Player)) {
                float attackDamage = 0.5f;
                if (livingEntity instanceof Blaze) {
                    attackDamage = 3.0f;
                }
                livingEntity.hurt(level.damageSources().magic(), attackDamage);
            }
            FireExtinguisherBlockItem.hurtAndBreak(level, itemStack, player, hand);
        } else {
            FireExtinguisherBlockItem.stopFireSound(level, player);
        }
        return InteractionResult.PASS;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 10;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipConsumer, TooltipFlag tooltipFlag) {
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)"tooltip.fire_extinguisher.fire_extinguisher", (Object[])new Object[]{FireExtinguisherConfig.fireExtinguisherRadiusX}).withStyle(ChatFormatting.GRAY));
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)"text.fire_extinguisher.fire_extinguisher_use").withStyle(ChatFormatting.GREEN));
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)"text.fire_extinguisher.fire_extinguisher_place").withStyle(ChatFormatting.DARK_GREEN));
    }
}

