/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.config;

import de.markusbordihn.fireextinguisher.config.Config;
import java.io.File;
import java.util.Properties;

public class FireExtinguisherConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "fire_extinguisher.cfg";
    public static final String CONFIG_FILE_HEADER = "Fire Extinguisher Configuration";
    public static int fireExtinguisherRadiusX = 1;
    public static int fireExtinguisherRadiusY = 2;
    public static int fireExtinguisherRadiusZ = 1;
    public static int fireAxtRadius = 1;
    public static int fireSprinklerRadiusX = 2;
    public static int fireSprinklerRadiusY = 3;
    public static int fireSprinklerRadiusZ = 2;
    public static int smokeDetectorRadiusX = 3;
    public static int smokeDetectorRadiusY = 5;
    public static int smokeDetectorRadiusZ = 3;
    public static boolean fireProtectionEnabled = true;
    public static int fireProtectionDuration = 25;
    public static int fireProtectionRenew = 80;
    public static boolean fireProtectionLightEnabled = true;
    public static int fireProtectionLightDuration = 180;
    public static int fireProtectionLightRenew = 40;
    public static boolean fireBootsSlowDownEnabled = true;
    public static boolean fireChestplateSlowDownEnabled = true;
    public static boolean fireLeggingsSlowDownEnabled = true;

    public static void registerConfig() {
        FireExtinguisherConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        FireExtinguisherConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = FireExtinguisherConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = FireExtinguisherConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        fireExtinguisherRadiusX = FireExtinguisherConfig.parseConfigValue(properties, "fireExtinguisherRadiusX", fireExtinguisherRadiusX);
        fireExtinguisherRadiusY = FireExtinguisherConfig.parseConfigValue(properties, "fireExtinguisherRadiusY", fireExtinguisherRadiusY);
        fireExtinguisherRadiusZ = FireExtinguisherConfig.parseConfigValue(properties, "fireExtinguisherRadiusZ", fireExtinguisherRadiusZ);
        fireAxtRadius = FireExtinguisherConfig.parseConfigValue(properties, "fireAxtRadius", fireAxtRadius);
        fireSprinklerRadiusX = FireExtinguisherConfig.parseConfigValue(properties, "fireSprinklerRadiusX", fireSprinklerRadiusX);
        fireSprinklerRadiusY = FireExtinguisherConfig.parseConfigValue(properties, "fireSprinklerRadiusY", fireSprinklerRadiusY);
        fireSprinklerRadiusZ = FireExtinguisherConfig.parseConfigValue(properties, "fireSprinklerRadiusZ", fireSprinklerRadiusZ);
        smokeDetectorRadiusX = FireExtinguisherConfig.parseConfigValue(properties, "smokeDetectorRadiusX", smokeDetectorRadiusX);
        smokeDetectorRadiusY = FireExtinguisherConfig.parseConfigValue(properties, "smokeDetectorRadiusY", smokeDetectorRadiusY);
        smokeDetectorRadiusZ = FireExtinguisherConfig.parseConfigValue(properties, "smokeDetectorRadiusZ", smokeDetectorRadiusZ);
        fireProtectionEnabled = FireExtinguisherConfig.parseConfigValue(properties, "fireProtectionEnabled", fireProtectionEnabled);
        fireProtectionDuration = FireExtinguisherConfig.parseConfigValue(properties, "fireProtectionDuration", fireProtectionDuration);
        fireProtectionRenew = FireExtinguisherConfig.parseConfigValue(properties, "fireProtectionRenew", fireProtectionRenew);
        fireProtectionLightEnabled = FireExtinguisherConfig.parseConfigValue(properties, "fireProtectionLightEnabled", fireProtectionLightEnabled);
        fireProtectionLightDuration = FireExtinguisherConfig.parseConfigValue(properties, "fireProtectionLightDuration", fireProtectionLightDuration);
        fireProtectionLightRenew = FireExtinguisherConfig.parseConfigValue(properties, "fireProtectionLightRenew", fireProtectionLightRenew);
        fireBootsSlowDownEnabled = FireExtinguisherConfig.parseConfigValue(properties, "fireBootsSlowDownEnabled", fireBootsSlowDownEnabled);
        fireChestplateSlowDownEnabled = FireExtinguisherConfig.parseConfigValue(properties, "fireChestplateSlowDownEnabled", fireChestplateSlowDownEnabled);
        fireLeggingsSlowDownEnabled = FireExtinguisherConfig.parseConfigValue(properties, "fireLeggingsSlowDownEnabled", fireLeggingsSlowDownEnabled);
        FireExtinguisherConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

