/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.gametest;

import de.markusbordihn.fireextinguisher.gametest.GameTestHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableTestHelper {
    private static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");

    private LootTableTestHelper() {
    }

    public static void testBlockDropItem(GameTestHelper helper, Block block, Item item) {
        LootTableTestHelper.testBlockDropItem(helper, block, item, Items.IRON_PICKAXE);
    }

    public static void testAxeBlockDropItem(GameTestHelper helper, Block block, Item item) {
        LootTableTestHelper.testBlockDropItem(helper, block, item, Items.IRON_AXE);
    }

    public static void testBlockDropItem(GameTestHelper helper, Block block, Item item, Item miningTool) {
        BlockPos blockPos = new BlockPos(0, 1, 0);
        LootTableTestHelper.testBlockDropItem(helper, block, item, miningTool, blockPos);
    }

    public static void testBlockDropItem(GameTestHelper helper, Block block, Item item, Item miningTool, BlockPos blockPos) {
        ItemStack itemStack = new ItemStack((ItemLike)miningTool);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.setBlock(blockPos, block);
        helper.assertBlockPresent(block, blockPos);
        BlockState blockState = helper.getBlockState(blockPos);
        GameTestHelpers.assertTrue(helper, "Expected block " + String.valueOf(block) + " but found " + String.valueOf(blockState.getBlock()), blockState.getBlock() == block);
        GameTestHelpers.assertTrue(helper, String.valueOf(itemStack.getItem()) + " can't mine " + String.valueOf(blockState.getBlock()), itemStack.getItem().mineBlock(itemStack, (Level)helper.getLevel(), blockState, helper.absolutePos(blockPos), (LivingEntity)player));
        GameTestHelpers.assertTrue(helper, String.valueOf(player) + " has not correct Tool " + String.valueOf(player.getMainHandItem()) + " for drops " + String.valueOf(blockState.getBlock()), player.hasCorrectToolForDrops(blockState));
        blockState.getBlock().playerDestroy((Level)helper.getLevel(), player, helper.absolutePos(blockPos), blockState, null, player.getMainHandItem());
        helper.assertItemEntityPresent(item, blockPos, 2.0);
        helper.destroyBlock(blockPos);
        helper.assertBlockNotPresent(block, blockPos);
    }
}

