/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.item;

import de.markusbordihn.fireextinguisher.config.FireExtinguisherConfig;
import de.markusbordihn.fireextinguisher.utils.ToolTips;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FireAxeItem
extends AxeItem {
    public static final String ID = "fire_axe";
    protected static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");

    public FireAxeItem() {
        this(ToolMaterial.IRON, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fire_extinguisher", (String)ID))).fireResistant());
    }

    public FireAxeItem(ToolMaterial tier, Item.Properties properties) {
        super(tier, 6.0f, -3.2f, properties);
    }

    public static void stopFire(Level level, Player player, InteractionHand hand, BlockPos targetBlockPos, ItemStack itemStack) {
        Iterable blockPositions = BlockPos.withinManhattan((BlockPos)targetBlockPos.above(), (int)FireExtinguisherConfig.fireAxtRadius, (int)FireExtinguisherConfig.fireAxtRadius, (int)FireExtinguisherConfig.fireAxtRadius);
        boolean hasStoppedFire = false;
        for (BlockPos blockPos : blockPositions) {
            BlockState blockState = level.getBlockState(blockPos);
            if (blockState.is(Blocks.FIRE)) {
                log.debug("[Fire Axt] Removing Fire Block {} at {}", (Object)blockState, (Object)blockPos);
                level.removeBlock(blockPos, false);
                FireAxeItem.stopFireSound(level, player);
                hasStoppedFire = true;
                continue;
            }
            if (!blockState.is(Blocks.CAMPFIRE) || !(blockState.getBlock() instanceof CampfireBlock) || !CampfireBlock.isLitCampfire((BlockState)blockState)) continue;
            log.debug("[Fire Axt] Extinguishing Campfire Block {} at {}", (Object)blockState, (Object)blockPos);
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)));
            FireAxeItem.stopFireSound(level, player);
            hasStoppedFire = true;
        }
        if (hasStoppedFire) {
            FireAxeItem.hurtAndBreak(level, itemStack, player, hand);
        }
    }

    public static void stopFireSound(Level level, Player player) {
        if (level.isClientSide) {
            player.playSound(SoundEvents.FIRE_EXTINGUISH, 1.0f, 1.0f);
        }
    }

    public static void hurtAndBreak(Level level, ItemStack itemStack, Player player, InteractionHand interactionHand) {
        if (!level.isClientSide) {
            itemStack.hurtAndBreak(1, (LivingEntity)player, interactionHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        InteractionHand interactionHand = context.getHand();
        FireAxeItem.stopFire(level, player, interactionHand, blockPos, itemStack);
        return context.getLevel().isClientSide() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
    }

    public boolean mineBlock(ItemStack itemStack, Level level, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            FireAxeItem.stopFire(level, player, player.getUsedItemHand(), blockPos, itemStack);
        }
        return super.mineBlock(itemStack, level, blockState, blockPos, livingEntity);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipConsumer, TooltipFlag tooltipFlag) {
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)"text.fire_extinguisher.fire_axe_description", (Object[])new Object[]{FireExtinguisherConfig.fireAxtRadius}).withStyle(ChatFormatting.GRAY));
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)"text.fire_extinguisher.fire_axe_use").withStyle(ChatFormatting.GREEN));
    }
}

