/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.item.equipment;

import de.markusbordihn.fireextinguisher.config.FireExtinguisherConfig;
import de.markusbordihn.fireextinguisher.item.ModArmorMaterials;
import de.markusbordihn.fireextinguisher.item.equipment.FireProtectionArmorItem;
import de.markusbordihn.fireextinguisher.utils.ToolTips;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.Level;

public class FireBootsLightItem
extends FireProtectionArmorItem {
    public static final String ID = "fire_boots_light";
    private int ticker = 0;

    public FireBootsLightItem() {
        this(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fire_extinguisher", (String)ID))));
    }

    public FireBootsLightItem(Item.Properties properties) {
        super(ModArmorMaterials.FIRE_PROTECTION_LIGHT.getArmorMaterial(), ArmorType.BOOTS, properties);
    }

    @Override
    protected void fireArmorTick(ItemStack itemStack, Level level, ServerPlayer serverPlayer) {
        if (Boolean.TRUE.equals(FireExtinguisherConfig.fireProtectionLightEnabled && this.ticker++ > FireExtinguisherConfig.fireProtectionLightRenew) && !serverPlayer.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            serverPlayer.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, FireExtinguisherConfig.fireProtectionLightDuration));
            this.ticker = 0;
        }
    }

    @Override
    public Class<?> getArmorClass() {
        return ((Object)((Object)this)).getClass();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipConsumer, TooltipFlag tooltipFlag) {
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)"text.fire_extinguisher.fire_boots_light_description").withStyle(ChatFormatting.GRAY));
        if (Boolean.TRUE.equals(FireExtinguisherConfig.fireProtectionLightEnabled)) {
            ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)"text.fire_extinguisher.fire_armor_config", (Object[])new Object[]{(double)Math.round((double)FireExtinguisherConfig.fireProtectionLightRenew / 20.0 * 10.0) / 10.0, (double)Math.round((double)FireExtinguisherConfig.fireProtectionLightDuration / 20.0 * 10.0) / 10.0}).withStyle(ChatFormatting.GREEN));
        }
    }
}

