/*
 * Decompiled with CFR 0.152.
 */
package de.draradech.simplefog.mixin;

import de.draradech.simplefog.SimpleFogMain;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.WaterFogEnvironment;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WaterFogEnvironment.class})
public class WaterFogEnvironmentMixin {
    @Inject(at={@At(value="TAIL")}, method={"setupFog(Lnet/minecraft/client/renderer/fog/FogData;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/BlockPos;Lnet/minecraft/client/multiplayer/ClientLevel;FLnet/minecraft/client/DeltaTracker;)V"})
    public void tailSetupFog(FogData fogData, Entity entity, BlockPos blockPos, ClientLevel clientLevel, float viewDistance, DeltaTracker deltaTracker, CallbackInfo ci) {
        if (!SimpleFogMain.config.waterToggle) {
            return;
        }
        fogData.environmentalStart = viewDistance * SimpleFogMain.config.waterStart * 0.01f;
        fogData.environmentalEnd = viewDistance * SimpleFogMain.config.waterEnd * 0.01f;
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            if (clientLevel.getBiome(blockPos).is(BiomeTags.HAS_CLOSER_WATER_FOG)) {
                fogData.environmentalEnd = viewDistance * SimpleFogMain.config.waterEndSwamp * 0.01f;
            }
            fogData.environmentalEnd *= Math.max(0.25f, localPlayer.getWaterVision());
        }
        fogData.skyEnd = fogData.environmentalEnd;
        fogData.cloudEnd = fogData.environmentalEnd;
    }
}

