/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfences.kikoz.objects;

import com.mcwfences.kikoz.objects.DoubleGate;
import com.mcwfences.kikoz.objects.FenceHitbox;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MetalFenceMiddle
extends Block {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final EnumProperty<FencePart> PART = EnumProperty.m_61598_((String)"fencepart", FencePart.class, (Enum[])new FencePart[]{FencePart.TOP, FencePart.MIDDLE, FencePart.BOTTOM});
    private static final VoxelShape POST = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0);
    private static final VoxelShape POST_COLLISION = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)24.0, (double)10.0);
    private static final VoxelShape NORTH_SHAPE_COLLISION = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)24.0, (double)6.0);
    private static final VoxelShape SOUTH_SHAPE_COLLISION = Block.m_49796_((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)24.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE_COLLISION = Block.m_49796_((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)24.0, (double)10.0);
    private static final VoxelShape WEST_SHAPE_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)24.0, (double)10.0);
    private static final Map<BlockState, VoxelShape> SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();
    private static final Map<BlockState, VoxelShape> COLLISION_SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();

    public MetalFenceMiddle(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)FencePart.TOP)));
    }

    private BlockState FenceState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean above = level.m_8055_(pos.m_7494_()).m_60734_() == this;
        boolean below = level.m_8055_(pos.m_7495_()).m_60734_() == this;
        FencePart connection = this.getConnectionStatus(above, below);
        return (BlockState)state.m_61124_(PART, (Comparable)((Object)connection));
    }

    private FencePart getConnectionStatus(boolean above, boolean below) {
        if (!above) {
            return FencePart.TOP;
        }
        if (above && below) {
            return FencePart.MIDDLE;
        }
        return FencePart.BOTTOM;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.m_60713_(state.m_60734_())) {
            this.FenceState(state, (LevelAccessor)level, pos);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState northState = level.m_8055_(pos.m_142127_());
        BlockState southState = level.m_8055_(pos.m_142128_());
        BlockState eastState = level.m_8055_(pos.m_142126_());
        BlockState westState = level.m_8055_(pos.m_142125_());
        boolean northConnects = this.canConnect(northState, northState.m_60783_((BlockGetter)level, pos.m_142127_(), Direction.SOUTH), Direction.SOUTH);
        boolean southConnects = this.canConnect(southState, southState.m_60783_((BlockGetter)level, pos.m_142128_(), Direction.NORTH), Direction.NORTH);
        boolean eastConnects = this.canConnect(eastState, eastState.m_60783_((BlockGetter)level, pos.m_142126_(), Direction.WEST), Direction.WEST);
        boolean westConnects = this.canConnect(westState, westState.m_60783_((BlockGetter)level, pos.m_142125_(), Direction.EAST), Direction.EAST);
        return this.FenceState((BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(northConnects))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(southConnects))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(eastConnects))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(westConnects)), (LevelAccessor)level, pos);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE_CACHE.computeIfAbsent(state, this::computeCollision);
    }

    private VoxelShape computeCollision(BlockState state) {
        VoxelShape shape = POST_COLLISION;
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_SHAPE_COLLISION);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE_COLLISION);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_SHAPE_COLLISION);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_SHAPE_COLLISION);
        }
        return shape;
    }

    public void placeAt(Level level, BlockPos pos, int num) {
        level.m_7731_(pos, this.m_49966_(), num);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE_CACHE.computeIfAbsent(state, this::computeShape);
    }

    private VoxelShape computeShape(BlockState state) {
        VoxelShape shape = POST;
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        return shape;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BooleanProperty property;
        if (direction.m_122434_().m_122479_() && (property = this.getProperty(direction)) != null) {
            boolean isNeighborSturdy = neighborState.m_60783_((BlockGetter)level, neighborPos, direction.m_122424_());
            boolean connects = neighborState.m_60795_() ? false : this.canConnect(neighborState, isNeighborSturdy, direction);
            state = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(connects));
        }
        boolean above = level.m_8055_(pos.m_7494_()).m_60734_() == this;
        boolean below = level.m_8055_(pos.m_7495_()).m_60734_() == this;
        FencePart connection = this.getConnectionStatus(above, below);
        state = (BlockState)state.m_61124_(PART, (Comparable)((Object)connection));
        return state;
    }

    public boolean canConnect(BlockState state, boolean bool, Direction dir) {
        Block block = state.m_60734_();
        boolean flag = this.isSameFence(state);
        boolean flag1 = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)dir);
        boolean flag2 = block instanceof WallBlock;
        boolean flag3 = block instanceof FenceHitbox;
        boolean flag4 = block instanceof DoubleGate;
        boolean flag5 = block instanceof FenceGateBlock;
        boolean flag6 = block instanceof FenceBlock;
        return !MetalFenceMiddle.m_152463_((BlockState)state) && bool || flag || flag1 || flag2 || flag3 || flag4 || flag5 || flag6;
    }

    private boolean isSameFence(BlockState state) {
        return state.m_204336_(BlockTags.f_13039_) && state.m_204336_(BlockTags.f_13098_) == this.m_49966_().m_204336_(BlockTags.f_13098_);
    }

    private BooleanProperty getProperty(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            default -> null;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, PART});
    }

    public static enum FencePart implements StringRepresentable
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private FencePart(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

