/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.quirksunchained;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.quirksunchained.ModelPartsMapper;
import net.mcreator.quirksunchained.client.model.ModelBigFist;
import net.mcreator.quirksunchained.client.model.ModelBigFistSlim;
import net.mcreator.quirksunchained.init.QuirksunchainedModMobEffects;
import net.mcreator.quirksunchained.network.QuirksunchainedModVariables;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;

public class BigFistRenderer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private final ModelBigFist<T> renderModel;
    private final ModelBigFistSlim<T> renderModelSlim;

    public BigFistRenderer(RenderLayerParent<T, M> parent, EntityModelSet modelSet) {
        super(parent);
        this.renderModel = new ModelBigFist(modelSet.m_171103_(ModelBigFist.LAYER_LOCATION));
        this.renderModelSlim = new ModelBigFistSlim(modelSet.m_171103_(ModelBigFistSlim.LAYER_LOCATION));
    }

    public void render(PoseStack pose, MultiBufferSource bufferSource, int light, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        EntityModel model;
        AbstractClientPlayer clientPlayer;
        boolean hasMuscleQuirk;
        QuirksunchainedModVariables.PlayerVariables variables = (QuirksunchainedModVariables.PlayerVariables)player.getCapability(QuirksunchainedModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new QuirksunchainedModVariables.PlayerVariables());
        boolean bl = hasMuscleQuirk = variables.Quirk.equals("Big Fist") || variables.Quirk.equals("Copy") && variables.CopyActiveQuirk.equals("Big Fist");
        if (!hasMuscleQuirk) {
            return;
        }
        boolean isSlim = player instanceof AbstractClientPlayer && (clientPlayer = (AbstractClientPlayer)player).m_108564_().equals("slim");
        EntityModel entityModel = model = isSlim ? this.renderModelSlim : this.renderModel;
        if (player.m_21023_((MobEffect)QuirksunchainedModMobEffects.BIG_FIST.get())) {
            ResourceLocation skinTexture = this.getSkinTexture(player);
            this.renderModel(pose, bufferSource, light, model, skinTexture, player);
        }
    }

    private ResourceLocation getSkinTexture(T player) {
        if (player instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player;
            return clientPlayer.m_108560_();
        }
        return new ResourceLocation("textures/entity/steve.png");
    }

    private void renderModel(PoseStack pose, MultiBufferSource bufferSource, int light, EntityModel<T> model, ResourceLocation texture, T player) {
        pose.m_85836_();
        int amplifier = player.m_21124_((MobEffect)QuirksunchainedModMobEffects.BIG_FIST.get()).m_19564_();
        if (model instanceof ModelBigFist) {
            ModelBigFist bigFistModel = (ModelBigFist)model;
            if (amplifier == 1) {
                this.scaleFistFolder(bigFistModel.RightArm, "bigfistright", 1.2f, 1.2f, 1.2f);
                this.scaleFistFolder(bigFistModel.LeftArm, "bigfistleft", 1.2f, 1.2f, 1.2f);
            } else {
                this.resetFistFolder(bigFistModel.RightArm, "bigfistright");
                this.resetFistFolder(bigFistModel.LeftArm, "bigfistleft");
            }
        } else if (model instanceof ModelBigFistSlim) {
            ModelBigFistSlim bigFistSlimModel = (ModelBigFistSlim)model;
            if (amplifier == 1) {
                this.scaleFistFolder(bigFistSlimModel.RightArm, "bigfistright", 1.2f, 1.2f, 1.2f);
                this.scaleFistFolder(bigFistSlimModel.LeftArm, "bigfistleft", 1.2f, 1.2f, 1.2f);
            } else {
                this.resetFistFolder(bigFistSlimModel.RightArm, "bigfistright");
                this.resetFistFolder(bigFistSlimModel.LeftArm, "bigfistleft");
            }
        }
        ModelPartsMapper.copyParts(model, (PlayerModel)this.m_117386_());
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
        model.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85849_();
    }

    private void scaleFistFolder(ModelPart armPart, String folderName, float x, float y, float z) {
        if (armPart.m_233562_(folderName)) {
            ModelPart folder = armPart.m_171324_(folderName);
            folder.f_233553_ = x;
            folder.f_233554_ = y;
            folder.f_233555_ = z;
        }
    }

    private void resetFistFolder(ModelPart armPart, String folderName) {
        this.scaleFistFolder(armPart, folderName, 1.0f, 1.0f, 1.0f);
    }
}

