/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.quirksunchained;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.quirksunchained.ModelPartsMapper;
import net.mcreator.quirksunchained.client.model.ModelFeatherSword;
import net.mcreator.quirksunchained.client.model.ModelFierceWings;
import net.mcreator.quirksunchained.client.model.ModelFierceWingsDive;
import net.mcreator.quirksunchained.network.QuirksunchainedModVariables;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class FierceWingsRenderer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private final ModelFeatherSword<T> renderModel;
    private final ModelFierceWings<T> wingModel;
    private final ModelFierceWingsDive<T> wingModelDive;

    public FierceWingsRenderer(RenderLayerParent<T, M> parent, EntityModelSet modelSet) {
        super(parent);
        this.renderModel = new ModelFeatherSword(modelSet.m_171103_(ModelFeatherSword.LAYER_LOCATION));
        this.wingModel = new ModelFierceWings(modelSet.m_171103_(ModelFierceWings.LAYER_LOCATION));
        this.wingModelDive = new ModelFierceWingsDive(modelSet.m_171103_(ModelFierceWingsDive.LAYER_LOCATION));
    }

    public void render(PoseStack pose, MultiBufferSource bufferSource, int light, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        QuirksunchainedModVariables.PlayerVariables variables = (QuirksunchainedModVariables.PlayerVariables)player.getCapability(QuirksunchainedModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new QuirksunchainedModVariables.PlayerVariables());
        if (variables.Quirk.equals("Fierce Wings") || variables.Quirk.equals("Copy") && variables.CopyActiveQuirk.equals("Fierce Wings")) {
            if (variables.FeatherSword) {
                this.renderModel(pose, bufferSource, light, player, partialTicks, this.renderModel, "quirksunchained:textures/entities/feathersword.png");
            }
            if (variables.ElytraOn || player.m_6069_()) {
                this.renderModel(pose, bufferSource, light, player, partialTicks, this.wingModelDive, "quirksunchained:textures/entities/fiercewings.png");
            } else {
                this.renderModel(pose, bufferSource, light, player, partialTicks, this.wingModel, "quirksunchained:textures/entities/fiercewings.png");
            }
        }
    }

    private void renderModel(PoseStack pose, MultiBufferSource bufferSource, int light, T player, float partialTicks, EntityModel<T> model, String texturePath) {
        pose.m_85836_();
        ResourceLocation texture = new ResourceLocation(texturePath);
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
        ModelPartsMapper.copyParts(model, (PlayerModel)this.m_117386_());
        if (model instanceof ModelFierceWings) {
            ModelFierceWings wings = (ModelFierceWings)model;
            if (wings.LeftWing != null && wings.RightWing != null) {
                this.applyCapePhysicsToWing(player, wings.LeftWing, partialTicks, true, false);
                this.applyCapePhysicsToWing(player, wings.RightWing, partialTicks, false, false);
            }
        } else if (model instanceof ModelFierceWingsDive) {
            ModelFierceWingsDive wingsDive = (ModelFierceWingsDive)model;
            if (wingsDive.LeftWing != null && wingsDive.RightWing != null) {
                this.applyCapePhysicsToWing(player, wingsDive.LeftWing, partialTicks, true, true);
                this.applyCapePhysicsToWing(player, wingsDive.RightWing, partialTicks, false, true);
            }
        }
        model.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85849_();
    }

    private void applyCapePhysicsToWing(T player, ModelPart wing, float partialTicks, boolean isLeft, boolean diveOnly) {
        float sideMultiplier;
        double d0 = Mth.m_14139_((double)partialTicks, (double)((Player)player).f_36102_, (double)((Player)player).f_36105_) - Mth.m_14139_((double)partialTicks, (double)((Player)player).f_19854_, (double)player.m_20185_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)((Player)player).f_36103_, (double)((Player)player).f_36106_) - Mth.m_14139_((double)partialTicks, (double)((Player)player).f_19855_, (double)player.m_20186_());
        double d2 = Mth.m_14139_((double)partialTicks, (double)((Player)player).f_36104_, (double)((Player)player).f_36075_) - Mth.m_14139_((double)partialTicks, (double)((Player)player).f_19856_, (double)player.m_20189_());
        float f = Mth.m_14189_((float)partialTicks, (float)((Player)player).f_20884_, (float)((Player)player).f_20883_);
        double d3 = Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        double d4 = -Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float f1 = (float)d1 * 10.0f;
        f1 = Mth.m_14036_((float)f1, (float)-6.0f, (float)32.0f);
        float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
        f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)150.0f);
        float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
        f3 = Mth.m_14036_((float)f3, (float)-20.0f, (float)20.0f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        float f4 = Mth.m_14179_((float)partialTicks, (float)((Player)player).f_36099_, (float)((Player)player).f_36100_);
        f1 += Mth.m_14031_((float)(Mth.m_14179_((float)partialTicks, (float)((Player)player).f_19867_, (float)((Player)player).f_19787_) * 6.0f)) * 32.0f * f4;
        if (player.m_6047_()) {
            f1 += 25.0f;
        }
        float f5 = sideMultiplier = isLeft ? 1.0f : -1.0f;
        if (diveOnly) {
            double xRotVal = Math.max(player.m_146909_(), 0.0f);
            wing.f_104205_ = (float)Math.toRadians(xRotVal * (double)sideMultiplier);
        } else {
            wing.f_104203_ = (float)Math.toRadians(6.0f + f2 / 2.0f + f1);
            wing.f_104204_ = (float)Math.toRadians((-6.0f - f2 / 2.0f - f1 + f3 / 2.0f) * sideMultiplier);
            wing.f_104205_ = (float)Math.toRadians((-6.0f - f2 / 2.0f - f1 + f3 / 2.0f) * sideMultiplier);
        }
    }
}

