/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.quirksunchained;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.quirksunchained.client.model.ModelHardenSpear;
import net.mcreator.quirksunchained.client.model.ModelHardening;
import net.mcreator.quirksunchained.client.model.ModelHardeningSlim;
import net.mcreator.quirksunchained.client.model.ModelSteelBody;
import net.mcreator.quirksunchained.client.model.ModelSteelBodySlim;
import net.mcreator.quirksunchained.init.QuirksunchainedModMobEffects;
import net.mcreator.quirksunchained.network.QuirksunchainedModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.HumanoidArm;

public class FirstPersonSteelRenderer {
    private static ModelSteelBody<AbstractClientPlayer> model = null;
    private static ModelSteelBodySlim<AbstractClientPlayer> modelSlim = null;
    private static ModelHardening<AbstractClientPlayer> harden = null;
    private static ModelHardeningSlim<AbstractClientPlayer> hardenSlim = null;
    private static ModelHardenSpear<AbstractClientPlayer> spear = null;

    public static void renderArm(PoseStack pose, MultiBufferSource buffers, int light, AbstractClientPlayer player, HumanoidArm armSide) {
        QuirksunchainedModVariables.PlayerVariables variables = (QuirksunchainedModVariables.PlayerVariables)player.getCapability(QuirksunchainedModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new QuirksunchainedModVariables.PlayerVariables());
        boolean hasSteel = variables.Quirk.equals("Steel") || variables.Quirk.equals("Copy") && variables.CopyActiveQuirk.equals("Steel");
        boolean isSlim = player.m_108564_().equals("slim");
        String steelTexturePrefix = player.m_6060_() ? "firesteel" : "steel";
        double SteelStage = 0.0;
        if (hasSteel) {
            SteelStage = variables.HardeningStage;
            FirstPersonSteelRenderer.loadModels();
            String steelTexture = "textures/entities/" + steelTexturePrefix + "body.png";
            String spearTexture = "textures/entities/" + steelTexturePrefix + "spear.png";
            if (SteelStage >= 5.0) {
                FirstPersonSteelRenderer.renderSteelArm(pose, buffers, light, player, armSide, isSlim, steelTexture, true);
            }
            if (SteelStage >= 1.0) {
                FirstPersonSteelRenderer.renderSteelArm(pose, buffers, light, player, armSide, isSlim, steelTexture, false);
            }
            if (player.m_21023_((MobEffect)QuirksunchainedModMobEffects.RED_SPEAR_EFFECT.get())) {
                FirstPersonSteelRenderer.renderSpear(pose, buffers, light, player, armSide, spearTexture);
            }
        }
    }

    private static void loadModels() {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        if (model == null) {
            model = new ModelSteelBody(modelSet.m_171103_(ModelSteelBody.LAYER_LOCATION));
        }
        if (modelSlim == null) {
            modelSlim = new ModelSteelBodySlim(modelSet.m_171103_(ModelSteelBodySlim.LAYER_LOCATION));
        }
        if (harden == null) {
            harden = new ModelHardening(modelSet.m_171103_(ModelHardening.LAYER_LOCATION));
        }
        if (hardenSlim == null) {
            hardenSlim = new ModelHardeningSlim(modelSet.m_171103_(ModelHardeningSlim.LAYER_LOCATION));
        }
        if (spear == null) {
            spear = new ModelHardenSpear(modelSet.m_171103_(ModelHardenSpear.LAYER_LOCATION));
        }
    }

    private static void renderSteelArm(PoseStack pose, MultiBufferSource buffers, int light, AbstractClientPlayer player, HumanoidArm armSide, boolean isSlim, String texturePath, boolean isHardening) {
        ModelPart rightArm;
        ModelPart modelPart = isSlim ? (isHardening ? FirstPersonSteelRenderer.hardenSlim.RightArm : FirstPersonSteelRenderer.modelSlim.RightArm) : (rightArm = isHardening ? FirstPersonSteelRenderer.harden.RightArm : FirstPersonSteelRenderer.model.RightArm);
        ModelPart leftArm = isSlim ? (isHardening ? FirstPersonSteelRenderer.hardenSlim.LeftArm : FirstPersonSteelRenderer.modelSlim.LeftArm) : (isHardening ? FirstPersonSteelRenderer.harden.LeftArm : FirstPersonSteelRenderer.model.LeftArm);
        FirstPersonSteelRenderer.renderArmPartForStage(pose, buffers, light, player, armSide, rightArm, leftArm, texturePath);
    }

    private static void renderSpear(PoseStack pose, MultiBufferSource buffers, int light, AbstractClientPlayer player, HumanoidArm armSide, String spearTexture) {
        FirstPersonSteelRenderer.renderArmPartForStage(pose, buffers, light, player, armSide, FirstPersonSteelRenderer.spear.RightArm, FirstPersonSteelRenderer.spear.LeftArm, spearTexture);
    }

    private static void renderArmPartForStage(PoseStack pose, MultiBufferSource buffers, int light, AbstractClientPlayer player, HumanoidArm armSide, ModelPart rightArm, ModelPart leftArm, String texturePath) {
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.04f, 0.0f);
        pose.m_252781_(Axis.f_252529_.m_252977_(0.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(0.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_(5.0f));
        ModelPart renderArm = armSide == HumanoidArm.RIGHT ? rightArm : leftArm;
        ResourceLocation texture = new ResourceLocation("quirksunchained", texturePath);
        VertexConsumer vertexConsumer = buffers.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
        renderArm.m_104301_(pose, vertexConsumer, light, OverlayTexture.f_118083_);
        pose.m_85849_();
    }
}

