/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.quirksunchained;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.quirksunchained.client.model.ModelHardenSpear;
import net.mcreator.quirksunchained.client.model.ModelHardeningArms;
import net.mcreator.quirksunchained.client.model.ModelHardeningArmsSlim;
import net.mcreator.quirksunchained.client.model.ModelHardeningBody;
import net.mcreator.quirksunchained.client.model.ModelHardeningHead;
import net.mcreator.quirksunchained.client.model.ModelHardeningLegs;
import net.mcreator.quirksunchained.client.model.ModelRedRiot;
import net.mcreator.quirksunchained.client.model.ModelRedRiotSlim;
import net.mcreator.quirksunchained.init.QuirksunchainedModMobEffects;
import net.mcreator.quirksunchained.network.QuirksunchainedModVariables;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;

public class HardeningRenderer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private final ModelHardenSpear<T> renderModelSpear;
    private final ModelRedRiot<T> hardenModel;
    private final ModelRedRiotSlim<T> hardenModelSlim;
    private final ModelHardeningArms<T> hardenArmModel;
    private final ModelHardeningArmsSlim<T> hardenArmModelSlim;
    private final ModelHardeningBody<T> hardenBodyModel;
    private final ModelHardeningLegs<T> hardenLegsModel;
    private final ModelHardeningHead<T> hardenHeadModel;

    public HardeningRenderer(RenderLayerParent<T, M> parent, EntityModelSet modelSet) {
        super(parent);
        this.renderModelSpear = new ModelHardenSpear(modelSet.m_171103_(ModelHardenSpear.LAYER_LOCATION));
        this.hardenModel = new ModelRedRiot(modelSet.m_171103_(ModelRedRiot.LAYER_LOCATION));
        this.hardenModelSlim = new ModelRedRiotSlim(modelSet.m_171103_(ModelRedRiotSlim.LAYER_LOCATION));
        this.hardenArmModel = new ModelHardeningArms(modelSet.m_171103_(ModelHardeningArms.LAYER_LOCATION));
        this.hardenArmModelSlim = new ModelHardeningArmsSlim(modelSet.m_171103_(ModelHardeningArmsSlim.LAYER_LOCATION));
        this.hardenBodyModel = new ModelHardeningBody(modelSet.m_171103_(ModelHardeningBody.LAYER_LOCATION));
        this.hardenLegsModel = new ModelHardeningLegs(modelSet.m_171103_(ModelHardeningLegs.LAYER_LOCATION));
        this.hardenHeadModel = new ModelHardeningHead(modelSet.m_171103_(ModelHardeningHead.LAYER_LOCATION));
    }

    public void render(PoseStack pose, MultiBufferSource bufferSource, int light, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hasSteel;
        QuirksunchainedModVariables.PlayerVariables variables = (QuirksunchainedModVariables.PlayerVariables)player.getCapability(QuirksunchainedModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new QuirksunchainedModVariables.PlayerVariables());
        boolean bl = hasSteel = variables.Quirk.equals("Hardening") || variables.Quirk.equals("Copy") && variables.CopyActiveQuirk.equals("Hardening");
        if (!hasSteel) {
            return;
        }
        double steelStage = variables.HardeningStage;
        String basePath = "quirksunchained:textures/entities/harden";
        PlayerModel parent = (PlayerModel)this.m_117386_();
        if (!(player instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player;
        ResourceLocation playerSkinLocation = clientPlayer.m_108560_();
        boolean isSlim = clientPlayer.m_108564_().equals("slim");
        if (steelStage >= 5.0) {
            if (isSlim) {
                this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.hardenModelSlim, playerSkinLocation);
            } else {
                this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.hardenModel, playerSkinLocation);
            }
        } else {
            if (steelStage >= 4.0) {
                this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.hardenHeadModel, playerSkinLocation);
            }
            if (steelStage >= 3.0) {
                this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.hardenLegsModel, playerSkinLocation);
            }
            if (steelStage >= 2.0) {
                this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.hardenBodyModel, playerSkinLocation);
            }
            if (steelStage >= 1.0) {
                if (isSlim) {
                    this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.hardenArmModelSlim, playerSkinLocation);
                } else {
                    this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.hardenArmModel, playerSkinLocation);
                }
            }
        }
        if (player.m_21023_((MobEffect)QuirksunchainedModMobEffects.RED_SPEAR_EFFECT.get())) {
            ResourceLocation spearTexture = new ResourceLocation(basePath + "spear.png");
            this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.renderModelSpear, spearTexture);
        }
    }

    private void renderModel(PoseStack pose, MultiBufferSource bufferSource, int light, PlayerModel<T> parent, Object model, ResourceLocation texture) {
        pose.m_85836_();
        pose.m_85841_(1.0f, 1.0f, 1.0f);
        pose.m_252880_(0.0f, 0.0f, 0.0f);
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
        if (model instanceof ModelRedRiot) {
            ModelRedRiot hard = (ModelRedRiot)((Object)model);
            this.copyParts(parent, (Object)hard);
            hard.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelRedRiotSlim) {
            ModelRedRiotSlim hardSlim = (ModelRedRiotSlim)((Object)model);
            this.copyParts(parent, (Object)hardSlim);
            hardSlim.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelHardenSpear) {
            ModelHardenSpear spear = (ModelHardenSpear)((Object)model);
            this.copyParts(parent, (Object)spear);
            spear.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelHardeningBody) {
            ModelHardeningBody hardenBody = (ModelHardeningBody)((Object)model);
            this.copyParts(parent, (Object)hardenBody);
            hardenBody.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelHardeningLegs) {
            ModelHardeningLegs hardenLegs = (ModelHardeningLegs)((Object)model);
            this.copyParts(parent, (Object)hardenLegs);
            hardenLegs.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelHardeningHead) {
            ModelHardeningHead hardenHead = (ModelHardeningHead)((Object)model);
            this.copyParts(parent, (Object)hardenHead);
            hardenHead.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelHardeningArms) {
            ModelHardeningArms hardenArm = (ModelHardeningArms)((Object)model);
            this.copyParts(parent, (Object)hardenArm);
            hardenArm.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelHardeningArmsSlim) {
            ModelHardeningArmsSlim hardenArmSlim = (ModelHardeningArmsSlim)((Object)model);
            this.copyParts(parent, (Object)hardenArmSlim);
            hardenArmSlim.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        pose.m_85849_();
    }

    private void copyParts(PlayerModel<T> parent, Object model) {
        if (model instanceof ModelRedRiot) {
            ModelRedRiot hard = (ModelRedRiot)((Object)model);
            hard.Head.m_104315_(parent.f_102808_);
            hard.Body.m_104315_(parent.f_102810_);
            hard.LeftArm.m_104315_(parent.f_102812_);
            hard.RightArm.m_104315_(parent.f_102811_);
            hard.LeftLeg.m_104315_(parent.f_102814_);
            hard.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelRedRiotSlim) {
            ModelRedRiotSlim hardSlim = (ModelRedRiotSlim)((Object)model);
            hardSlim.Head.m_104315_(parent.f_102808_);
            hardSlim.Body.m_104315_(parent.f_102810_);
            hardSlim.LeftArm.m_104315_(parent.f_102812_);
            hardSlim.RightArm.m_104315_(parent.f_102811_);
            hardSlim.LeftLeg.m_104315_(parent.f_102814_);
            hardSlim.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelHardenSpear) {
            ModelHardenSpear spear = (ModelHardenSpear)((Object)model);
            spear.Head.m_104315_(parent.f_102808_);
            spear.Body.m_104315_(parent.f_102810_);
            spear.LeftArm.m_104315_(parent.f_102812_);
            spear.RightArm.m_104315_(parent.f_102811_);
            spear.LeftLeg.m_104315_(parent.f_102814_);
            spear.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelHardeningBody) {
            ModelHardeningBody hardenBody = (ModelHardeningBody)((Object)model);
            hardenBody.Head.m_104315_(parent.f_102808_);
            hardenBody.Body.m_104315_(parent.f_102810_);
            hardenBody.LeftArm.m_104315_(parent.f_102812_);
            hardenBody.RightArm.m_104315_(parent.f_102811_);
            hardenBody.LeftLeg.m_104315_(parent.f_102814_);
            hardenBody.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelHardeningLegs) {
            ModelHardeningLegs hardenLegs = (ModelHardeningLegs)((Object)model);
            hardenLegs.Head.m_104315_(parent.f_102808_);
            hardenLegs.Body.m_104315_(parent.f_102810_);
            hardenLegs.LeftArm.m_104315_(parent.f_102812_);
            hardenLegs.RightArm.m_104315_(parent.f_102811_);
            hardenLegs.LeftLeg.m_104315_(parent.f_102814_);
            hardenLegs.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelHardeningHead) {
            ModelHardeningHead hardenHead = (ModelHardeningHead)((Object)model);
            hardenHead.Head.m_104315_(parent.f_102808_);
            hardenHead.Body.m_104315_(parent.f_102810_);
            hardenHead.LeftArm.m_104315_(parent.f_102812_);
            hardenHead.RightArm.m_104315_(parent.f_102811_);
            hardenHead.LeftLeg.m_104315_(parent.f_102814_);
            hardenHead.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelHardeningArms) {
            ModelHardeningArms hardenArm = (ModelHardeningArms)((Object)model);
            hardenArm.Head.m_104315_(parent.f_102808_);
            hardenArm.Body.m_104315_(parent.f_102810_);
            hardenArm.LeftArm.m_104315_(parent.f_102812_);
            hardenArm.RightArm.m_104315_(parent.f_102811_);
            hardenArm.LeftLeg.m_104315_(parent.f_102814_);
            hardenArm.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelHardeningArmsSlim) {
            ModelHardeningArmsSlim hardenArmSlim = (ModelHardeningArmsSlim)((Object)model);
            hardenArmSlim.Head.m_104315_(parent.f_102808_);
            hardenArmSlim.Body.m_104315_(parent.f_102810_);
            hardenArmSlim.LeftArm.m_104315_(parent.f_102812_);
            hardenArmSlim.RightArm.m_104315_(parent.f_102811_);
            hardenArmSlim.LeftLeg.m_104315_(parent.f_102814_);
            hardenArmSlim.RightLeg.m_104315_(parent.f_102813_);
        }
    }
}

