/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.quirksunchained;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.player.Player;

public class ModelPartsMapper {
    private static final Map<Class<?>, Map<String, Field>> FIELD_CACHE = new HashMap();
    private static final String[] PART_NAMES = new String[]{"Head", "Body", "LeftArm", "RightArm", "LeftLeg", "RightLeg"};

    public static <T extends Player> void copyParts(Object model, PlayerModel<T> parent) {
        if (model == null) {
            return;
        }
        Map<String, Field> fields = ModelPartsMapper.getFieldsForClass(model.getClass());
        try {
            ModelPartsMapper.copyPart(fields, model, "Head", parent.f_102808_);
            ModelPartsMapper.copyPart(fields, model, "Body", parent.f_102810_);
            ModelPartsMapper.copyPart(fields, model, "LeftArm", parent.f_102812_);
            ModelPartsMapper.copyPart(fields, model, "RightArm", parent.f_102811_);
            ModelPartsMapper.copyPart(fields, model, "LeftLeg", parent.f_102814_);
            ModelPartsMapper.copyPart(fields, model, "RightLeg", parent.f_102813_);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Map<String, Field> getFieldsForClass(Class<?> clazz) {
        return FIELD_CACHE.computeIfAbsent(clazz, c -> {
            HashMap<String, Field> fieldMap = new HashMap<String, Field>();
            for (Field field : c.getFields()) {
                if (!ModelPart.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                fieldMap.put(field.getName().toLowerCase(), field);
            }
            return fieldMap;
        });
    }

    private static void copyPart(Map<String, Field> fields, Object model, String partName, ModelPart source) throws Exception {
        ModelPart target;
        Field field = fields.get(partName.toLowerCase());
        if (field != null && (target = (ModelPart)field.get(model)) != null) {
            target.m_104315_(source);
        }
    }
}

