/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.quirksunchained;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.quirksunchained.ModelPartsMapper;
import net.mcreator.quirksunchained.client.model.ModelMuscular;
import net.mcreator.quirksunchained.client.model.ModelMuscularSlim;
import net.mcreator.quirksunchained.init.QuirksunchainedModMobEffects;
import net.mcreator.quirksunchained.network.QuirksunchainedModVariables;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;

public class MuscularRenderer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private final ModelMuscular<T> renderModel;
    private final ModelMuscularSlim<T> renderModelSlim;

    public MuscularRenderer(RenderLayerParent<T, M> parent, EntityModelSet modelSet) {
        super(parent);
        this.renderModel = new ModelMuscular(modelSet.m_171103_(ModelMuscular.LAYER_LOCATION));
        this.renderModelSlim = new ModelMuscularSlim(modelSet.m_171103_(ModelMuscularSlim.LAYER_LOCATION));
    }

    public void render(PoseStack pose, MultiBufferSource bufferSource, int light, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        EntityModel model;
        AbstractClientPlayer clientPlayer;
        boolean hasMuscleQuirk;
        QuirksunchainedModVariables.PlayerVariables variables = (QuirksunchainedModVariables.PlayerVariables)player.getCapability(QuirksunchainedModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new QuirksunchainedModVariables.PlayerVariables());
        boolean bl = hasMuscleQuirk = variables.Quirk.equals("Muscle Augmentation") || variables.Quirk.equals("Copy") && variables.CopyActiveQuirk.equals("Muscle Augmentation");
        if (!hasMuscleQuirk) {
            return;
        }
        double stage = variables.MuscleStage;
        boolean isSlim = player instanceof AbstractClientPlayer && (clientPlayer = (AbstractClientPlayer)player).m_108564_().equals("slim");
        EntityModel entityModel = model = isSlim ? this.renderModelSlim : this.renderModel;
        if (stage >= 5.0) {
            this.renderModel(pose, bufferSource, light, model, "quirksunchained:textures/entities/musculargod.png");
        } else {
            if (stage >= 4.0) {
                this.renderModel(pose, bufferSource, light, model, "quirksunchained:textures/entities/musculartendrils.png");
            }
            if (stage >= 3.0) {
                this.renderModel(pose, bufferSource, light, model, "quirksunchained:textures/entities/muscularlegs.png");
            }
            if (stage >= 2.0) {
                this.renderModel(pose, bufferSource, light, model, "quirksunchained:textures/entities/muscularchest.png");
            }
            if (stage >= 1.0) {
                this.renderModel(pose, bufferSource, light, model, "quirksunchained:textures/entities/musculararms.png");
            }
        }
        if (player.m_21023_((MobEffect)QuirksunchainedModMobEffects.CHARGE_EFFECT.get()) && "airpunchcharge".equals(variables.ChargeAnimation)) {
            this.renderModel(pose, bufferSource, light, this.renderModel, "quirksunchained:textures/entities/muscularcharge.png");
        }
    }

    private void renderModel(PoseStack pose, MultiBufferSource bufferSource, int light, EntityModel<T> model, String texturePath) {
        pose.m_85836_();
        ResourceLocation texture = new ResourceLocation(texturePath);
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
        ModelPartsMapper.copyParts(model, (PlayerModel)this.m_117386_());
        model.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85849_();
    }
}

