/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.quirksunchained;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.quirksunchained.client.model.ModelHardenSpear;
import net.mcreator.quirksunchained.client.model.ModelHardening;
import net.mcreator.quirksunchained.client.model.ModelHardeningSlim;
import net.mcreator.quirksunchained.client.model.ModelSteelBody;
import net.mcreator.quirksunchained.client.model.ModelSteelBodySlim;
import net.mcreator.quirksunchained.init.QuirksunchainedModMobEffects;
import net.mcreator.quirksunchained.network.QuirksunchainedModVariables;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;

public class SteelRenderer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private final ModelSteelBody<T> renderModel;
    private final ModelSteelBodySlim<T> renderModelSlim;
    private final ModelHardenSpear<T> renderModelSpear;
    private final ModelHardening<T> hardenModel;
    private final ModelHardeningSlim<T> hardenModelSlim;

    public SteelRenderer(RenderLayerParent<T, M> parent, EntityModelSet modelSet) {
        super(parent);
        this.renderModel = new ModelSteelBody(modelSet.m_171103_(ModelSteelBody.LAYER_LOCATION));
        this.renderModelSlim = new ModelSteelBodySlim(modelSet.m_171103_(ModelSteelBodySlim.LAYER_LOCATION));
        this.renderModelSpear = new ModelHardenSpear(modelSet.m_171103_(ModelHardenSpear.LAYER_LOCATION));
        this.hardenModel = new ModelHardening(modelSet.m_171103_(ModelHardening.LAYER_LOCATION));
        this.hardenModelSlim = new ModelHardeningSlim(modelSet.m_171103_(ModelHardeningSlim.LAYER_LOCATION));
    }

    public void render(PoseStack pose, MultiBufferSource bufferSource, int light, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AbstractClientPlayer clientPlayer;
        boolean isSlim;
        boolean hasSteel;
        QuirksunchainedModVariables.PlayerVariables variables = (QuirksunchainedModVariables.PlayerVariables)player.getCapability(QuirksunchainedModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new QuirksunchainedModVariables.PlayerVariables());
        boolean bl = hasSteel = variables.Quirk.equals("Steel") || variables.Quirk.equals("Copy") && variables.CopyActiveQuirk.equals("Steel");
        if (!hasSteel) {
            return;
        }
        double steelStage = variables.HardeningStage;
        String steelTexturePrefix = player.m_6060_() ? "firesteel" : "steel";
        String basePath = "quirksunchained:textures/entities/" + steelTexturePrefix;
        PlayerModel parent = (PlayerModel)this.m_117386_();
        boolean bl2 = isSlim = player instanceof AbstractClientPlayer && (clientPlayer = (AbstractClientPlayer)player).m_108564_().equals("slim");
        if (steelStage >= 5.0) {
            if (isSlim) {
                this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.hardenModelSlim, basePath + "body.png");
            } else {
                this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.hardenModel, basePath + "body.png");
            }
        }
        if (steelStage >= 4.0) {
            this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.renderModel, basePath + "head.png");
        }
        if (steelStage >= 3.0) {
            this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.renderModel, basePath + "legs.png");
        }
        if (steelStage >= 2.0) {
            this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.renderModel, basePath + "chest.png");
        }
        if (steelStage >= 1.0) {
            if (isSlim) {
                this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.renderModelSlim, basePath + "arms.png");
            } else {
                this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.renderModel, basePath + "arms.png");
            }
        }
        if (player.m_21023_((MobEffect)QuirksunchainedModMobEffects.RED_SPEAR_EFFECT.get())) {
            this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.renderModelSpear, basePath + "spear.png");
        }
    }

    private void renderModel(PoseStack pose, MultiBufferSource bufferSource, int light, PlayerModel<T> parent, Object model, String texturePath) {
        pose.m_85836_();
        pose.m_85841_(1.0f, 1.0f, 1.0f);
        pose.m_252880_(0.0f, 0.0f, 0.0f);
        ResourceLocation texture = new ResourceLocation(texturePath);
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
        if (model instanceof ModelSteelBody) {
            ModelSteelBody steel = (ModelSteelBody)((Object)model);
            this.copyParts(parent, (Object)steel);
            steel.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelSteelBodySlim) {
            ModelSteelBodySlim slim = (ModelSteelBodySlim)((Object)model);
            this.copyParts(parent, (Object)slim);
            slim.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelHardening) {
            ModelHardening hard = (ModelHardening)((Object)model);
            this.copyParts(parent, (Object)hard);
            hard.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelHardeningSlim) {
            ModelHardeningSlim hardSlim = (ModelHardeningSlim)((Object)model);
            this.copyParts(parent, (Object)hardSlim);
            hardSlim.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelHardenSpear) {
            ModelHardenSpear spear = (ModelHardenSpear)((Object)model);
            this.copyParts(parent, (Object)spear);
            spear.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        pose.m_85849_();
    }

    private void copyParts(PlayerModel<T> parent, Object model) {
        if (model instanceof ModelSteelBody) {
            ModelSteelBody body = (ModelSteelBody)((Object)model);
            body.Head.m_104315_(parent.f_102808_);
            body.Body.m_104315_(parent.f_102810_);
            body.LeftArm.m_104315_(parent.f_102812_);
            body.RightArm.m_104315_(parent.f_102811_);
            body.LeftLeg.m_104315_(parent.f_102814_);
            body.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelSteelBodySlim) {
            ModelSteelBodySlim slim = (ModelSteelBodySlim)((Object)model);
            slim.Head.m_104315_(parent.f_102808_);
            slim.Body.m_104315_(parent.f_102810_);
            slim.LeftArm.m_104315_(parent.f_102812_);
            slim.RightArm.m_104315_(parent.f_102811_);
            slim.LeftLeg.m_104315_(parent.f_102814_);
            slim.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelHardening) {
            ModelHardening hard = (ModelHardening)((Object)model);
            hard.Head.m_104315_(parent.f_102808_);
            hard.Body.m_104315_(parent.f_102810_);
            hard.LeftArm.m_104315_(parent.f_102812_);
            hard.RightArm.m_104315_(parent.f_102811_);
            hard.LeftLeg.m_104315_(parent.f_102814_);
            hard.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelHardeningSlim) {
            ModelHardeningSlim hardSlim = (ModelHardeningSlim)((Object)model);
            hardSlim.Head.m_104315_(parent.f_102808_);
            hardSlim.Body.m_104315_(parent.f_102810_);
            hardSlim.LeftArm.m_104315_(parent.f_102812_);
            hardSlim.RightArm.m_104315_(parent.f_102811_);
            hardSlim.LeftLeg.m_104315_(parent.f_102814_);
            hardSlim.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelHardenSpear) {
            ModelHardenSpear spear = (ModelHardenSpear)((Object)model);
            spear.Head.m_104315_(parent.f_102808_);
            spear.Body.m_104315_(parent.f_102810_);
            spear.LeftArm.m_104315_(parent.f_102812_);
            spear.RightArm.m_104315_(parent.f_102811_);
            spear.LeftLeg.m_104315_(parent.f_102814_);
            spear.RightLeg.m_104315_(parent.f_102813_);
        }
    }
}

