/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.quirksunchained;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.quirksunchained.client.model.ModelBasePlayer;
import net.mcreator.quirksunchained.client.model.ModelBasePlayerSlim;
import net.mcreator.quirksunchained.client.model.ModelStressFull;
import net.mcreator.quirksunchained.client.model.ModelStressMedium;
import net.mcreator.quirksunchained.client.model.ModelStressSlimMedium;
import net.mcreator.quirksunchained.network.QuirksunchainedModVariables;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class StressRenderer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private final ModelBasePlayer<T> renderModel;
    private final ModelBasePlayerSlim<T> renderModelSlim;
    private final ModelStressMedium<T> stressModel;
    private final ModelStressSlimMedium<T> stressModelSlim;
    private final ModelStressFull<T> stressFullModel;

    public StressRenderer(RenderLayerParent<T, M> parent, EntityModelSet modelSet) {
        super(parent);
        this.renderModel = new ModelBasePlayer(modelSet.m_171103_(ModelBasePlayer.LAYER_LOCATION));
        this.renderModelSlim = new ModelBasePlayerSlim(modelSet.m_171103_(ModelBasePlayerSlim.LAYER_LOCATION));
        this.stressModel = new ModelStressMedium(modelSet.m_171103_(ModelStressMedium.LAYER_LOCATION));
        this.stressModelSlim = new ModelStressSlimMedium(modelSet.m_171103_(ModelStressSlimMedium.LAYER_LOCATION));
        this.stressFullModel = new ModelStressFull(modelSet.m_171103_(ModelStressFull.LAYER_LOCATION));
    }

    public void render(PoseStack pose, MultiBufferSource bufferSource, int light, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AbstractClientPlayer clientPlayer;
        boolean isSlim;
        QuirksunchainedModVariables.PlayerVariables variables = (QuirksunchainedModVariables.PlayerVariables)player.getCapability(QuirksunchainedModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new QuirksunchainedModVariables.PlayerVariables());
        boolean bl = isSlim = player instanceof AbstractClientPlayer && (clientPlayer = (AbstractClientPlayer)player).m_108564_().equals("slim");
        if (variables.Quirk.equals("Stress") || variables.Quirk.equals("Copy") && variables.CopyActiveQuirk.equals("Stress")) {
            if (variables.StressForm.equals("Light")) {
                if (isSlim) {
                    parent = (PlayerModel)this.m_117386_();
                    this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.renderModelSlim, "quirksunchained:textures/entities/stresslight.png");
                } else {
                    parent = (PlayerModel)this.m_117386_();
                    this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.renderModel, "quirksunchained:textures/entities/stresslight.png");
                }
            } else if (variables.StressForm.equals("Medium")) {
                if (isSlim) {
                    parent = (PlayerModel)this.m_117386_();
                    this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.renderModelSlim, "quirksunchained:textures/entities/stresslight.png");
                } else {
                    parent = (PlayerModel)this.m_117386_();
                    this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.renderModel, "quirksunchained:textures/entities/stresslight.png");
                }
                if (isSlim) {
                    parent = (PlayerModel)this.m_117386_();
                    this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.stressModelSlim, "quirksunchained:textures/entities/stressmedium.png");
                } else {
                    parent = (PlayerModel)this.m_117386_();
                    this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.stressModel, "quirksunchained:textures/entities/stressmedium.png");
                }
            } else if (variables.StressForm.equals("Full")) {
                parent = (PlayerModel)this.m_117386_();
                this.renderModel(pose, bufferSource, light, (PlayerModel<T>)parent, this.stressFullModel, "quirksunchained:textures/entities/stressfull.png");
            }
        }
    }

    private void renderModel(PoseStack pose, MultiBufferSource bufferSource, int light, PlayerModel<T> parent, Object model, String texturePath) {
        pose.m_85836_();
        pose.m_85841_(1.0f, 1.0f, 1.0f);
        pose.m_252880_(0.0f, 0.0f, 0.0f);
        ResourceLocation texture = new ResourceLocation(texturePath);
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
        this.copyParts(parent, model);
        if (model instanceof ModelBasePlayer) {
            ModelBasePlayer muscular = (ModelBasePlayer)((Object)model);
            muscular.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelBasePlayerSlim) {
            ModelBasePlayerSlim muscularSlim = (ModelBasePlayerSlim)((Object)model);
            muscularSlim.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelStressMedium) {
            ModelStressMedium stress = (ModelStressMedium)((Object)model);
            stress.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelStressSlimMedium) {
            ModelStressSlimMedium stressSlim = (ModelStressSlimMedium)((Object)model);
            stressSlim.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof ModelStressFull) {
            ModelStressFull stressFull = (ModelStressFull)((Object)model);
            stressFull.m_7695_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        pose.m_85849_();
    }

    private void copyParts(PlayerModel<T> parent, Object model) {
        if (model instanceof ModelBasePlayer) {
            ModelBasePlayer muscular = (ModelBasePlayer)((Object)model);
            muscular.Head.m_104315_(parent.f_102808_);
            muscular.Body.m_104315_(parent.f_102810_);
            muscular.LeftArm.m_104315_(parent.f_102812_);
            muscular.RightArm.m_104315_(parent.f_102811_);
            muscular.LeftLeg.m_104315_(parent.f_102814_);
            muscular.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelBasePlayerSlim) {
            ModelBasePlayerSlim muscularSlim = (ModelBasePlayerSlim)((Object)model);
            muscularSlim.Head.m_104315_(parent.f_102808_);
            muscularSlim.Body.m_104315_(parent.f_102810_);
            muscularSlim.LeftArm.m_104315_(parent.f_102812_);
            muscularSlim.RightArm.m_104315_(parent.f_102811_);
            muscularSlim.LeftLeg.m_104315_(parent.f_102814_);
            muscularSlim.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelStressMedium) {
            ModelStressMedium stress = (ModelStressMedium)((Object)model);
            stress.Head.m_104315_(parent.f_102808_);
            stress.Body.m_104315_(parent.f_102810_);
            stress.LeftArm.m_104315_(parent.f_102812_);
            stress.RightArm.m_104315_(parent.f_102811_);
            stress.LeftLeg.m_104315_(parent.f_102814_);
            stress.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelStressSlimMedium) {
            ModelStressSlimMedium stressSlim = (ModelStressSlimMedium)((Object)model);
            stressSlim.Head.m_104315_(parent.f_102808_);
            stressSlim.Body.m_104315_(parent.f_102810_);
            stressSlim.LeftArm.m_104315_(parent.f_102812_);
            stressSlim.RightArm.m_104315_(parent.f_102811_);
            stressSlim.LeftLeg.m_104315_(parent.f_102814_);
            stressSlim.RightLeg.m_104315_(parent.f_102813_);
        } else if (model instanceof ModelStressFull) {
            ModelStressFull stressFull = (ModelStressFull)((Object)model);
            stressFull.Head.m_104315_(parent.f_102808_);
            stressFull.Body.m_104315_(parent.f_102810_);
            stressFull.LeftArm.m_104315_(parent.f_102812_);
            stressFull.RightArm.m_104315_(parent.f_102811_);
            stressFull.LeftLeg.m_104315_(parent.f_102814_);
            stressFull.RightLeg.m_104315_(parent.f_102813_);
        }
    }
}

