/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.quirksunchained;

import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SyncPlayerAnimationPacket {
    private int entityId;
    private ResourceLocation animationId;
    private boolean applyLookRotation;
    private boolean applyCustomLookRotation;
    private double customRotation;
    private double customRotationYaw;

    public SyncPlayerAnimationPacket(int entityId, ResourceLocation animationId, boolean applyLookRotation, boolean applyCustomLookRotation, double customRotation, double customRotationYaw) {
        this.entityId = entityId;
        this.animationId = animationId;
        this.applyLookRotation = applyLookRotation;
        this.applyCustomLookRotation = applyCustomLookRotation;
        this.customRotation = customRotation;
        this.customRotationYaw = customRotationYaw;
    }

    public static SyncPlayerAnimationPacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        ResourceLocation animId = buf.m_130281_();
        boolean applyLookRotation = buf.readBoolean();
        boolean applyCustomLookRotation = buf.readBoolean();
        double customRotation = buf.readDouble();
        double customRotationYaw = buf.readDouble();
        return new SyncPlayerAnimationPacket(entityId, animId, applyLookRotation, applyCustomLookRotation, customRotation, customRotationYaw);
    }

    public static void encode(SyncPlayerAnimationPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.entityId);
        buf.m_130085_(pkt.animationId);
        buf.writeBoolean(pkt.applyLookRotation);
        buf.writeBoolean(pkt.applyCustomLookRotation);
        buf.writeDouble(pkt.customRotation);
        buf.writeDouble(pkt.customRotationYaw);
    }

    public static void handle(SyncPlayerAnimationPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            KeyframeAnimation anim;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity entity = level.m_6815_(pkt.entityId);
            if (!(entity instanceof AbstractClientPlayer)) {
                return;
            }
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)entity;
            ModifierLayer animLayer = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)clientPlayer).get(new ResourceLocation("quirksunchained", "combat"));
            if (animLayer != null && (anim = PlayerAnimationRegistry.getAnimation((ResourceLocation)pkt.animationId)) != null) {
                KeyframeAnimationPlayer finalAnimation;
                KeyframeAnimationPlayer animPlayer = new KeyframeAnimationPlayer(anim);
                if (pkt.applyLookRotation) {
                    AdjustmentModifier modifier = new AdjustmentModifier(partName -> {
                        float pitch = (float)(-Math.toRadians(entity.m_146909_()));
                        if ("body".equals(partName)) {
                            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(pitch, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f)));
                        }
                        return Optional.empty();
                    });
                    modifier.setAnim((IAnimation)animPlayer);
                    finalAnimation = modifier;
                } else if (pkt.applyCustomLookRotation) {
                    AdjustmentModifier modifier = new AdjustmentModifier(partName -> {
                        float pitch = (float)pkt.customRotation;
                        float yaw = (float)pkt.customRotationYaw;
                        if (yaw != 0.0f) {
                            if ("body".equals(partName)) {
                                return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(pitch, yaw, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f)));
                            }
                        } else if ("body".equals(partName)) {
                            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(pitch, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f)));
                        }
                        return Optional.empty();
                    });
                    modifier.setAnim((IAnimation)animPlayer);
                    finalAnimation = modifier;
                } else {
                    finalAnimation = animPlayer;
                }
                animLayer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (Ease)Ease.INOUTSINE), (IAnimation)finalAnimation);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

