/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.quirksunchained.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.quirksunchained.QuirksunchainedMod;
import net.mcreator.quirksunchained.procedures.AwakenGuiOpenProcedure;
import net.mcreator.quirksunchained.procedures.BoosterSweepSelectProcedure;
import net.mcreator.quirksunchained.procedures.CombatGuiOpenProcedure;
import net.mcreator.quirksunchained.procedures.EngineBoostSelectProcedure;
import net.mcreator.quirksunchained.procedures.JetStreamSelectProcedure;
import net.mcreator.quirksunchained.procedures.ReciproAssaultSelectProcedure;
import net.mcreator.quirksunchained.procedures.ReciproBurstSelectProcedure;
import net.mcreator.quirksunchained.procedures.SlotPress1Procedure;
import net.mcreator.quirksunchained.procedures.SlotPress2Procedure;
import net.mcreator.quirksunchained.procedures.SlotPress3Procedure;
import net.mcreator.quirksunchained.procedures.SlotPress4Procedure;
import net.mcreator.quirksunchained.procedures.SlotPressClearProcedure;
import net.mcreator.quirksunchained.procedures.StyleGuiOpenProcedure;
import net.mcreator.quirksunchained.procedures.TurbineBarrageSelectProcedure;
import net.mcreator.quirksunchained.procedures.TurboFlipperSelectProcedure;
import net.mcreator.quirksunchained.world.inventory.EngineGuiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EngineGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private HashMap<String, String> textstate;

    public EngineGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.textstate = EngineGuiButtonMessage.readTextState(buffer);
    }

    public EngineGuiButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.textstate = textstate;
    }

    public static void buffer(EngineGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        EngineGuiButtonMessage.writeTextState(message.textstate, buffer);
    }

    public static void handler(EngineGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HashMap<String, String> textstate = message.textstate;
            EngineGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = EngineGuiMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CombatGuiOpenProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            StyleGuiOpenProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            AwakenGuiOpenProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            EngineBoostSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            BoosterSweepSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            TurboFlipperSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            ReciproBurstSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            JetStreamSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            TurbineBarrageSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            ReciproAssaultSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            SlotPress1Procedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            SlotPress2Procedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            SlotPress3Procedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            SlotPress4Procedure.execute((Entity)entity);
        }
        if (buttonID == 14) {
            SlotPressClearProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        QuirksunchainedMod.addNetworkMessage(EngineGuiButtonMessage.class, EngineGuiButtonMessage::buffer, EngineGuiButtonMessage::new, EngineGuiButtonMessage::handler);
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getKey()));
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getValue()));
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130238_().getString();
            String value = buffer.m_130238_().getString();
            map.put(key, value);
        }
        return map;
    }
}

