/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.quirksunchained.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.quirksunchained.QuirksunchainedMod;
import net.mcreator.quirksunchained.procedures.ApShotSelectProcedure;
import net.mcreator.quirksunchained.procedures.AwakenGuiOpenProcedure;
import net.mcreator.quirksunchained.procedures.BouncingBettySelectProcedure;
import net.mcreator.quirksunchained.procedures.CombatGuiOpenProcedure;
import net.mcreator.quirksunchained.procedures.ExDashSelectProcedure;
import net.mcreator.quirksunchained.procedures.ExPultSelectProcedure;
import net.mcreator.quirksunchained.procedures.ExplodeSelectProcedure;
import net.mcreator.quirksunchained.procedures.HowitzerSelectProcedure;
import net.mcreator.quirksunchained.procedures.LandmineSelectProcedure;
import net.mcreator.quirksunchained.procedures.SlotPress1Procedure;
import net.mcreator.quirksunchained.procedures.SlotPress2Procedure;
import net.mcreator.quirksunchained.procedures.SlotPress3Procedure;
import net.mcreator.quirksunchained.procedures.SlotPress4Procedure;
import net.mcreator.quirksunchained.procedures.SlotPressClearProcedure;
import net.mcreator.quirksunchained.procedures.StyleGuiOpenProcedure;
import net.mcreator.quirksunchained.world.inventory.ExplosionGuiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ExplosionGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private HashMap<String, String> textstate;

    public ExplosionGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.textstate = ExplosionGuiButtonMessage.readTextState(buffer);
    }

    public ExplosionGuiButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.textstate = textstate;
    }

    public static void buffer(ExplosionGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        ExplosionGuiButtonMessage.writeTextState(message.textstate, buffer);
    }

    public static void handler(ExplosionGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HashMap<String, String> textstate = message.textstate;
            ExplosionGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ExplosionGuiMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CombatGuiOpenProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            ExplodeSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ExDashSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ApShotSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ExPultSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            BouncingBettySelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            LandmineSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            HowitzerSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            AwakenGuiOpenProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 9) {
            StyleGuiOpenProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 10) {
            SlotPress1Procedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            SlotPress2Procedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            SlotPress3Procedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            SlotPress4Procedure.execute((Entity)entity);
        }
        if (buttonID == 14) {
            SlotPressClearProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        QuirksunchainedMod.addNetworkMessage(ExplosionGuiButtonMessage.class, ExplosionGuiButtonMessage::buffer, ExplosionGuiButtonMessage::new, ExplosionGuiButtonMessage::handler);
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getKey()));
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getValue()));
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130238_().getString();
            String value = buffer.m_130238_().getString();
            map.put(key, value);
        }
        return map;
    }
}

