/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.necklace;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class PanicNecklaceItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"panic").stat(StatData.builder((String)"movement").initialValue(0.1, 0.2).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value * 10.0), (int)1)).build()).stat(StatData.builder((String)"radius").initialValue(6.0, 8.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-2348773).borderBottom(-11075571).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)Attributes.f_22279_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
    }

    public static void addSpeed(ItemStack stack, double val) {
        PanicNecklaceItem.setSpeed(stack, PanicNecklaceItem.getSpeed(stack) + val);
    }

    public static double getSpeed(ItemStack stack) {
        return NBTUtils.getDouble((ItemStack)stack, (String)"speed", (double)0.0);
    }

    public static void setSpeed(ItemStack stack, double val) {
        NBTUtils.setDouble((ItemStack)stack, (String)"speed", (double)Math.max(val, 0.0));
    }

    @Mod.EventBusSubscriber
    public static class PanicNecklaceEvent {
        @SubscribeEvent
        public static void onPlayerDamage(LivingHurtEvent event) {
            PanicNecklaceItem relic;
            Player player;
            block5: {
                block4: {
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) break block4;
                    player = (Player)livingEntity;
                    if (event.getSource().m_7639_() instanceof Mob) break block5;
                }
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.PANIC_NECKLACE.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof PanicNecklaceItem) || !(relic = (PanicNecklaceItem)item).canUseAbility(stack, "panic")) {
                return;
            }
            relic.spreadExperience((LivingEntity)player, stack, 1);
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            double modifier;
            PanicNecklaceItem relic;
            Player player = event.player;
            if (event.phase != TickEvent.Phase.END || player.m_20193_().m_5776_()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.PANIC_NECKLACE.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof PanicNecklaceItem) || !(relic = (PanicNecklaceItem)item).canPlayerUseActiveAbility(player, stack, "panic")) {
                return;
            }
            double radius = relic.getAbilityValue(stack, "panic", "radius");
            double target = (double)player.m_20193_().m_45976_(Monster.class, player.m_20191_().m_82400_(radius)).stream().filter(mob -> mob.m_5448_() == player).count() * relic.getAbilityValue(stack, "panic", "movement") + (double)player.m_20193_().m_45976_(Player.class, player.m_20191_().m_82400_(radius)).stream().filter(player1 -> !player1.m_20148_().equals(player.m_20148_())).count();
            double speed = PanicNecklaceItem.getSpeed(stack);
            double step = 0.01;
            double d = speed < target ? step : (modifier = speed > target ? -step : 0.0);
            if (modifier != 0.0) {
                PanicNecklaceItem.addSpeed(stack, modifier);
            }
            EntityUtils.resetAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)Attributes.f_22279_, (float)((float)PanicNecklaceItem.getSpeed(stack)), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        }
    }
}

