/*
 * Decompiled with CFR 0.152.
 */
package xyz.gagsch.trashorigins;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import java.util.OptionalInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import xyz.gagsch.trashorigins.power.Powers;
import xyz.gagsch.trashorigins.power.piglin.GoldToolCraft;
import xyz.gagsch.trashorigins.power.piglin.PiglinBehavior;

@Mod(value="trashorigins")
public class TrashOrigins {
    public static final String MODID = "trashorigins";
    public static final Logger LOGGER = LogUtils.getLogger();

    public TrashOrigins() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(FogStuff.class);
        MinecraftForge.EVENT_BUS.register(PiglinBehavior.class);
        MinecraftForge.EVENT_BUS.register(GoldToolCraft.class);
        Powers.POWER_FACTORIES.register(bus);
    }

    public static class FogStuff {
        @SubscribeEvent
        public static void renderFog(ViewportEvent.RenderFog event) {
            if (event.getType() == FogType.NONE) {
                IPowerContainer.get((Entity)event.getCamera().m_90592_()).ifPresent(handler -> {
                    if (handler.hasPower(Powers.BLIND_LOCATION) && handler.hasPower(Powers.ECHO_LOCATE_LOCATION)) {
                        OptionalInt cooldown = ((ConfiguredPower)handler.getPower(Powers.ECHO_LOCATE_LOCATION).m_203334_()).getValue(handler.getOwner());
                        float start = FogStuff.getStart(cooldown);
                        RenderSystem.setShaderFogStart((float)start);
                        RenderSystem.setShaderFogEnd((float)(start + 3.0f));
                    }
                });
            }
        }

        private static float getStart(OptionalInt cooldown) {
            float start = 7.0f;
            if (cooldown.isPresent() && cooldown.getAsInt() > 1100) {
                int value = 1200 - cooldown.getAsInt();
                start = value < 13 ? (start += (float)value) : (value > 87 ? (start -= (float)(value - 100)) : 20.0f);
            }
            return start;
        }
    }
}

