/*
 * Decompiled with CFR 0.152.
 */
package xyz.gagsch.trashorigins.power.piglin;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;
import xyz.gagsch.trashorigins.power.Powers;

public class PiglinBehavior {
    public static final Map<Player, List<AbstractPiglin>> PIGLIN_BEHAVIOR_MAP = new HashMap<Player, List<AbstractPiglin>>();
    public static final PiglinTeleporter PIGLIN_TELEPORTER = new PiglinTeleporter();

    public static boolean addBehavior(Player player, AbstractPiglin piglin, ItemStack itemstack) {
        if (piglin.m_6162_() || PIGLIN_BEHAVIOR_MAP.containsKey(player) && (PIGLIN_BEHAVIOR_MAP.get(player).size() >= 15 || PIGLIN_BEHAVIOR_MAP.get(player).contains(piglin))) {
            return false;
        }
        boolean value = false;
        if (itemstack.m_150930_(Items.f_42417_) && !piglin.getPersistentData().m_128403_("owner")) {
            piglin.getPersistentData().m_128362_("owner", player.m_20148_());
            itemstack.m_41774_(1);
            value = true;
        }
        if (value || piglin.getPersistentData().m_128403_("owner") && player.m_20148_().equals(piglin.getPersistentData().m_128342_("owner"))) {
            PIGLIN_BEHAVIOR_MAP.computeIfAbsent(player, k -> new ArrayList()).add(piglin);
            piglin.m_34670_(true);
            value = true;
        }
        return value;
    }

    @SubscribeEvent
    public static void onPiglinInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (entity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)entity;
            if (!event.getLevel().m_5776_()) {
                IPowerContainer.get((Entity)player).ifPresent(handler -> {
                    ItemStack itemstack = player.m_21120_(event.getHand());
                    if (handler.hasPower(Powers.PIGLIN_CAPITALISM_LOCATION) && PiglinBehavior.addBehavior(player, piglin, itemstack)) {
                        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123748_, false, piglin.m_20185_(), piglin.m_20186_() + 1.0, piglin.m_20189_(), 0.5f, 0.5f, 0.5f, 0.1f, 15);
                        ((ServerPlayer)player).f_8906_.m_9829_((Packet)packet);
                        event.setCancellationResult(InteractionResult.CONSUME);
                        event.setCanceled(true);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        Iterator<Player> playerIterator = PIGLIN_BEHAVIOR_MAP.keySet().iterator();
        while (playerIterator.hasNext()) {
            Player player = playerIterator.next();
            if (player.m_21224_()) {
                for (AbstractPiglin piglin : PIGLIN_BEHAVIOR_MAP.get(player)) {
                    piglin.getPersistentData().m_128473_("owner");
                    piglin.m_34670_(false);
                }
                PIGLIN_BEHAVIOR_MAP.get(player).clear();
                playerIterator.remove();
                continue;
            }
            Iterator<AbstractPiglin> iterator = PIGLIN_BEHAVIOR_MAP.get(player).iterator();
            LivingEntity target = PiglinBehavior.getTarget(player);
            boolean targetNull = target == null || target.m_213877_() || player.m_20280_((Entity)target) > 400.0;
            Optional currentTarget = Optional.empty();
            UUID targetUUID = null;
            while (iterator.hasNext()) {
                double distance;
                AbstractPiglin abstractPiglin = iterator.next();
                Brain brain = abstractPiglin.m_6274_();
                if (!abstractPiglin.m_6084_()) {
                    if (abstractPiglin.m_21224_()) {
                        player.m_213846_(abstractPiglin.m_21231_().m_19293_());
                    }
                    iterator.remove();
                    continue;
                }
                if (!targetNull && !(target instanceof AbstractPiglin)) {
                    targetUUID = target.m_20148_();
                    Optional optional = currentTarget = brain.m_21952_(MemoryModuleType.f_26334_).isPresent() && ((UUID)brain.m_21952_(MemoryModuleType.f_26334_).get()).equals(abstractPiglin.getPersistentData().m_128342_("owner")) ? currentTarget : brain.m_21952_(MemoryModuleType.f_26334_);
                }
                if ((distance = player.m_20280_((Entity)abstractPiglin)) > 400.0) {
                    brain.m_21936_(MemoryModuleType.f_26334_);
                    brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(player.m_20183_(), 1.0f, 1));
                    if (!(distance > 1600.0)) continue;
                    abstractPiglin.m_6021_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                    continue;
                }
                if (!targetNull && currentTarget.isPresent() && currentTarget.get() != targetUUID) {
                    brain.m_21879_(MemoryModuleType.f_26334_, (Object)targetUUID);
                    continue;
                }
                if (!targetNull && currentTarget.isEmpty()) {
                    brain.m_21879_(MemoryModuleType.f_26334_, (Object)targetUUID);
                    continue;
                }
                if (!targetNull) continue;
                brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(player.m_20183_(), 0.95f, 4));
            }
        }
    }

    @Nullable
    private static LivingEntity getTarget(Player player) {
        LivingEntity target;
        LivingEntity lastHurt = player.m_21214_();
        LivingEntity lastHurtBy = player.m_21188_();
        LivingEntity livingEntity = target = lastHurt != null ? lastHurt : lastHurtBy;
        if (lastHurt != lastHurtBy) {
            if (lastHurt instanceof Player) {
                target = lastHurtBy;
            } else if (lastHurtBy instanceof Player) {
                target = lastHurt;
            }
        }
        if (target == null || target.m_213877_()) {
            return PiglinBehavior.findNearestHostile(player);
        }
        return target;
    }

    @Nullable
    private static LivingEntity findNearestHostile(Player player) {
        Level level = player.m_9236_();
        AABB area = player.m_20191_().m_82400_(10.0);
        List entities = level.m_45971_(Mob.class, TargetingConditions.m_148352_(), (LivingEntity)player, area);
        return entities.stream().filter(e -> !(e instanceof AbstractPiglin) && e.m_6084_() && player == e.m_5448_()).min(Comparator.comparingDouble(e -> e.m_20280_((Entity)player))).orElse(null);
    }

    @SubscribeEvent
    public static void dimensionTravel(EntityTravelToDimensionEvent event) {
        AbstractPiglin piglin;
        Object object;
        if (event.getEntity().m_9236_().f_46443_ || !((object = event.getEntity()) instanceof AbstractPiglin) || !(piglin = (AbstractPiglin)object).getPersistentData().m_128403_("owner")) {
            return;
        }
        for (Player player : PIGLIN_BEHAVIOR_MAP.keySet()) {
            if (!PIGLIN_BEHAVIOR_MAP.get(player).contains(piglin)) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void playerDimensionTravel(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity().m_9236_().f_46443_ || !PIGLIN_BEHAVIOR_MAP.containsKey(event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        ServerLevel level = player.m_20194_().m_129880_(event.getTo());
        HashSet piglins = new HashSet(PIGLIN_BEHAVIOR_MAP.get(player));
        PIGLIN_BEHAVIOR_MAP.get(player).clear();
        for (AbstractPiglin piglin : piglins) {
            if (piglin == null || !piglin.m_6084_()) continue;
            AbstractPiglin newPiglin = (AbstractPiglin)piglin.changeDimension(level, (ITeleporter)PIGLIN_TELEPORTER);
            PIGLIN_BEHAVIOR_MAP.get(player).add(newPiglin);
        }
    }

    public static class PiglinTeleporter
    implements ITeleporter {
    }
}

