/*
 * Decompiled with CFR 0.152.
 */
package xyz.gagsch.trashorigins.power.radiant;

import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.configuration.NoConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;
import xyz.gagsch.trashorigins.power.Powers;

public class LightBoostPower
extends PowerFactory<NoConfiguration> {
    public static final UUID SPEED_MOD_UUID = UUID.fromString("11111111-1111-1111-1111-112111111111");
    public static final UUID DAMAGE_MOD_UUID = UUID.fromString("22222222-2222-2222-2222-223222222222");
    public static final UUID ATTACK_SPEED_MOD_UUID = UUID.fromString("33333333-3333-3333-3333-334333333333");
    public static ConfiguredPower<?, ?> LIGHT_ENERGY_POWER;

    public LightBoostPower() {
        super(NoConfiguration.CODEC);
        this.ticking(true);
    }

    protected int tickInterval(NoConfiguration configuration, Entity entity) {
        return 3;
    }

    public void tick(@NotNull ConfiguredPower<NoConfiguration, ?> configuration, Entity entity) {
        if (!entity.m_9236_().f_46443_ && entity instanceof LivingEntity) {
            AttributeInstance attackAttr;
            LivingEntity living = (LivingEntity)entity;
            float brightness = entity.m_9236_().m_46803_(entity.m_20183_());
            float multiplier = 0.25f + brightness / 15.0f * 1.25f - 1.0f;
            AttributeInstance speedAttr = living.m_21051_(Attributes.f_22279_);
            if (speedAttr != null) {
                speedAttr.m_22120_(SPEED_MOD_UUID);
                speedAttr.m_22118_(new AttributeModifier(SPEED_MOD_UUID, "Light speed boost", (double)multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if ((attackAttr = living.m_21051_(Attributes.f_22281_)) != null) {
                attackAttr.m_22120_(DAMAGE_MOD_UUID);
                attackAttr.m_22118_(new AttributeModifier(DAMAGE_MOD_UUID, "Light damage boost", (double)multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            AttributeInstance attackSpeedAttr = living.m_21051_(Attributes.f_22283_);
            if (attackAttr != null) {
                attackAttr.m_22120_(ATTACK_SPEED_MOD_UUID);
                attackAttr.m_22118_(new AttributeModifier(ATTACK_SPEED_MOD_UUID, "Light attack speed boost", (double)multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            LIGHT_ENERGY_POWER = (ConfiguredPower)ApoliAPI.getPowers().m_7745_(Powers.LIGHT_ENERGY_LOCATION);
            LIGHT_ENERGY_POWER.assign(entity, (int)((double)brightness * 6.67));
            ApoliAPI.synchronizePowerContainer((Entity)entity);
        }
    }
}

