/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.jade.server;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.api.machine.component.CrafterAccess;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.component.FluidAccess;
import aztech.modern_industrialization.api.machine.component.InventoryAccess;
import aztech.modern_industrialization.api.machine.component.ItemAccess;
import aztech.modern_industrialization.api.machine.holder.CrafterComponentHolder;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.api.machine.holder.FluidStorageComponentHolder;
import aztech.modern_industrialization.api.machine.holder.MultiblockInventoryComponentHolder;
import aztech.modern_industrialization.compat.jade.server.MIJadeCommonPlugin;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import snownee.jade.api.Accessor;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ProgressView;
import snownee.jade.api.view.ViewGroup;

public abstract sealed class MachineComponentProvider<S, C>
implements IServerExtensionProvider<S>,
IClientExtensionProvider<S, C> {
    public ResourceLocation getUid() {
        return MI.id("machine");
    }

    public static final class Progress
    extends MachineComponentProvider<CompoundTag, ProgressView> {
        public List<ViewGroup<CompoundTag>> getGroups(Accessor<?> accessor) {
            CrafterComponentHolder holder;
            CrafterAccess component;
            float progress;
            Object object = accessor.getTarget();
            if (object instanceof CrafterComponentHolder && (progress = (component = (holder = (CrafterComponentHolder)object).getCrafterComponent()).getProgress()) > 0.0f) {
                InventoryAccess inventory = holder.getCrafterComponent().getInventory();
                ViewGroup progressData = new ViewGroup(new ArrayList());
                progressData.views.add(ProgressView.create((float)progress));
                return List.of(progressData);
            }
            return List.of();
        }

        public List<ClientViewGroup<ProgressView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> list) {
            return ClientViewGroup.map(list, ProgressView::read, null);
        }
    }

    public static final class Items
    extends MachineComponentProvider<ItemStack, ItemView> {
        public List<ViewGroup<ItemStack>> getGroups(Accessor<?> accessor) {
            MachineBlockEntity machine = (MachineBlockEntity)accessor.getTarget();
            if (machine instanceof MultiblockInventoryComponentHolder) {
                MultiblockInventoryComponentHolder holder = (MultiblockInventoryComponentHolder)((Object)machine);
                InventoryAccess component = holder.getMultiblockInventoryComponent();
                List<? extends ItemAccess> inputs = component.getItemInputs();
                List<? extends ItemAccess> outputs = component.getItemOutputs();
                if (!inputs.isEmpty() || !outputs.isEmpty()) {
                    ViewGroup itemData = new ViewGroup(new ArrayList());
                    this.addItems((ViewGroup<ItemStack>)itemData, inputs);
                    this.addItems((ViewGroup<ItemStack>)itemData, outputs);
                    return List.of(itemData);
                }
                return List.of();
            }
            ViewGroup itemData = new ViewGroup(new ArrayList());
            this.addItems((ViewGroup<ItemStack>)itemData, machine.getInventory().getItemStacks());
            return List.of(itemData);
        }

        private void addItems(ViewGroup<ItemStack> data, List<? extends ItemAccess> stacks) {
            for (ItemAccess itemAccess : stacks) {
                ItemStack vanillaStack = itemAccess.toStack();
                if (vanillaStack.isEmpty()) continue;
                data.views.add(vanillaStack);
            }
        }

        public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> list) {
            return ClientViewGroup.map(list, ItemView::new, null);
        }
    }

    public static final class Fluids
    extends MachineComponentProvider<CompoundTag, FluidView> {
        public List<ViewGroup<CompoundTag>> getGroups(Accessor<?> accessor) {
            MachineBlockEntity machine = (MachineBlockEntity)accessor.getTarget();
            if (machine instanceof MultiblockInventoryComponentHolder) {
                MultiblockInventoryComponentHolder holder = (MultiblockInventoryComponentHolder)((Object)machine);
                InventoryAccess component = holder.getMultiblockInventoryComponent();
                List<? extends FluidAccess> inputs = component.getFluidInputs();
                List<? extends FluidAccess> outputs = component.getFluidOutputs();
                if (!inputs.isEmpty() || !outputs.isEmpty()) {
                    ViewGroup fluidData = new ViewGroup(new ArrayList());
                    this.addFluids((ViewGroup<CompoundTag>)fluidData, inputs);
                    this.addFluids((ViewGroup<CompoundTag>)fluidData, outputs);
                    return List.of(fluidData);
                }
                return List.of();
            }
            if (machine instanceof FluidStorageComponentHolder) {
                FluidStorageComponentHolder holder = (FluidStorageComponentHolder)((Object)machine);
                FluidAccess component = holder.getFluidStorageComponent();
                if (component != null) {
                    FluidVariant fluid = component.getVariant();
                    ViewGroup fluidData = new ViewGroup(new ArrayList());
                    fluidData.views.add(FluidView.writeDefault((JadeFluidObject)MIJadeCommonPlugin.fluidStack(fluid, component.getAmount()), (long)component.getCapacity()));
                    return List.of(fluidData);
                }
                return List.of();
            }
            List<ConfigurableFluidStack> stacks = machine.getInventory().getFluidStacks();
            ViewGroup fluidData = new ViewGroup(new ArrayList());
            this.addFluids((ViewGroup<CompoundTag>)fluidData, stacks);
            return List.of(fluidData);
        }

        private void addFluids(ViewGroup<CompoundTag> data, List<? extends FluidAccess> stacks) {
            for (FluidAccess fluidAccess : stacks) {
                data.views.add(FluidView.writeDefault((JadeFluidObject)MIJadeCommonPlugin.fluidStack(fluidAccess.getVariant(), fluidAccess.getAmount()), (long)fluidAccess.getCapacity()));
            }
        }

        public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> list) {
            return ClientViewGroup.map(list, FluidView::readDefault, null);
        }
    }

    public static final class Energy
    extends MachineComponentProvider<CompoundTag, EnergyView> {
        public List<ViewGroup<CompoundTag>> getGroups(Accessor<?> accessor) {
            Object object = accessor.getTarget();
            if (object instanceof EnergyListComponentHolder) {
                EnergyListComponentHolder holder = (EnergyListComponentHolder)object;
                components = holder.getEnergyComponents();
                if (!components.isEmpty()) {
                    long stored = 0L;
                    long capacity = 0L;
                    for (EnergyAccess energyAccess : components) {
                        stored += energyAccess.getEu();
                        capacity += energyAccess.getCapacity();
                    }
                    return List.of(new ViewGroup(List.of(EnergyView.of((long)stored, (long)capacity))));
                }
            } else {
                components = accessor.getTarget();
                if (components instanceof EnergyComponentHolder) {
                    EnergyComponentHolder holder = (EnergyComponentHolder)((Object)components);
                    EnergyAccess component = holder.getEnergyComponent();
                    return List.of(new ViewGroup(List.of(EnergyView.of((long)component.getEu(), (long)component.getCapacity()))));
                }
            }
            return List.of();
        }

        public List<ClientViewGroup<EnergyView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> list) {
            return ClientViewGroup.map(list, tag -> EnergyView.read((CompoundTag)tag, (String)" EU"), null);
        }
    }
}

